/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.config.file;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.Function;
import me.vierdant.playeremotes.config.Config;
import me.vierdant.playeremotes.config.ConfigFormat;
import me.vierdant.playeremotes.config.concurrent.ConcurrentConfig;
import me.vierdant.playeremotes.config.file.CheckedFileConfig;
import me.vierdant.playeremotes.config.file.FileConfigBuilder;

public interface FileConfig
extends ConcurrentConfig,
AutoCloseable {
    public File getFile();

    public Path getNioPath();

    public void save();

    public void load();

    @Override
    public void close();

    @Override
    default public FileConfig checked() {
        return new CheckedFileConfig(this);
    }

    @Override
    public <R> R bulkUpdate(Function<? super Config, R> var1);

    @Override
    default public void bulkUpdate(Consumer<? super Config> action) {
        this.bulkUpdate((? super Config config) -> {
            action.accept((Config)config);
            return null;
        });
    }

    public static FileConfigBuilder builder(Path file, ConfigFormat<?> format) {
        return new FileConfigBuilder(file, (ConfigFormat<? extends Config>)format);
    }

    public static FileConfigBuilder builder(File file, ConfigFormat<?> format) {
        return FileConfig.builder(file.toPath(), format);
    }

    public static FileConfigBuilder builder(String filePath, ConfigFormat<?> format) {
        return FileConfig.builder(Paths.get(filePath, new String[0]), format);
    }
}

