/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.ponder;

import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlockEntity;
import com.railwayteam.railways.mixin_interfaces.IStandardBogeyTEVirtualCoupling;
import com.railwayteam.railways.registry.CRBlocks;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.ParrotElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TrainScenes {
    public static void signaling(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("train_semaphore", "Visualizing Signal states using Semaphores");
        scene.configureBasePlate(1, 0, 15);
        scene.scaleSceneView(0.5f);
        scene.showBasePlate();
        scene.rotateCameraY(85.0f);
        for (int i = 16; i >= 0; --i) {
            scene.world.showSection(util.select.position(i, 1, 7), Direction.DOWN);
            scene.world.showSection(util.select.position(i, 1, 15 - i), Direction.DOWN);
            scene.idle(1);
        }
        scene.world.toggleControls(util.grid.at(13, 3, 7));
        scene.world.toggleControls(util.grid.at(13, 3, 1));
        scene.world.toggleControls(util.grid.at(13, 3, 4));
        BlockPos signal1 = new BlockPos(12, 1, 10);
        BlockPos signal2 = new BlockPos(9, 1, 2);
        BlockPos signal3 = new BlockPos(7, 1, 12);
        BlockPos signal4 = new BlockPos(4, 1, 4);
        BlockPos semaphore1a = new BlockPos(12, 4, 10);
        BlockPos semaphore1b = new BlockPos(12, 6, 10);
        BlockPos semaphore2a = new BlockPos(9, 4, 2);
        BlockPos semaphore2b = new BlockPos(9, 6, 2);
        BlockPos semaphore3 = new BlockPos(7, 2, 12);
        BlockPos semaphore4 = new BlockPos(4, 4, 4);
        Selection train1 = util.select.fromTo(11, 2, 6, 15, 3, 8);
        Selection train2 = util.select.fromTo(15, 2, 3, 11, 3, 5);
        Selection train3 = util.select.fromTo(11, 2, 0, 15, 3, 2);
        scene.idle(3);
        scene.world.showSection(util.select.position(signal1), Direction.DOWN);
        scene.idle(3);
        scene.world.showSection(util.select.position(signal2), Direction.DOWN);
        scene.idle(3);
        scene.world.showSection(util.select.position(signal3), Direction.DOWN);
        scene.idle(3);
        scene.world.showSection(util.select.position(signal4), Direction.DOWN);
        scene.world.replaceBlocks(util.select.position(semaphore1a.m_7494_()), Blocks.f_50016_.m_49966_(), false);
        scene.idle(15);
        scene.world.showSection(util.select.fromTo(signal1.m_7918_(0, 1, 0), signal1.m_7918_(0, 2, 0)), Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(util.select.position(semaphore1a), Direction.DOWN);
        scene.idle(10);
        scene.overlay.showText(60).pointAt(util.vector.topOf(semaphore1a)).attachKeyFrame().placeNearTarget().text("Semaphores are placed on poles above Train Signals");
        scene.idle(65);
        scene.world.showSection(util.select.fromTo(signal4.m_7918_(0, 1, 0), signal4.m_7918_(0, 2, 0)), Direction.DOWN);
        scene.idle(10);
        scene.overlay.showText(60).pointAt(util.vector.topOf(semaphore4.m_7495_())).attachKeyFrame().placeNearTarget().text("Semaphore poles can be made of different materials");
        scene.idle(50);
        scene.world.showSection(util.select.position(semaphore4), Direction.DOWN);
        scene.idle(10);
        scene.world.replaceBlocks(util.select.position(semaphore2a.m_7494_()), Blocks.f_50016_.m_49966_(), false);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(signal2.m_7918_(0, 1, 0), signal2.m_7918_(0, 2, 0)), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(semaphore2a), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(signal3.m_7918_(0, 1, 0), signal3.m_7918_(0, 1, 0)), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(semaphore3), Direction.DOWN);
        scene.idle(10);
        scene.special.movePointOfInterest(new Vec3(0.0, 3.0, 8.0));
        ElementLink trainElement = scene.world.showIndependentSection(train1, null);
        ElementLink birb1 = scene.special.createBirb(util.vector.centerOf(18, 3, 7), ParrotElement.FacePointOfInterestPose::new);
        scene.world.moveSection(trainElement, util.vector.of(4.0, 0.0, 0.0), 0);
        scene.world.moveSection(trainElement, util.vector.of(-9.0, 0.0, 0.0), 30);
        scene.world.animateBogey(util.grid.at(13, 2, 7), 9.0f, 30);
        scene.special.moveParrot(birb1, util.vector.of(-9.0, 0.0, 0.0), 30);
        scene.idle(10);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.RED);
        scene.effects.indicateRedstone(semaphore1a);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.RED);
        scene.effects.indicateRedstone(semaphore2a);
        scene.idle(35);
        ElementLink trainElement2 = scene.world.showIndependentSection(train3, null);
        ElementLink birb2 = scene.special.createBirb(util.vector.centerOf(18, 3, 7), ParrotElement.FacePointOfInterestPose::new);
        scene.world.moveSection(trainElement2, util.vector.of(4.0, 0.0, 6.0), 0);
        scene.world.moveSection(trainElement2, util.vector.of(-3.5, 0.0, 0.0), 25);
        scene.world.animateBogey(util.grid.at(13, 2, 1), 3.5f, 25);
        scene.special.moveParrot(birb2, util.vector.of(-3.5, 0.0, 0.0), 25);
        scene.idle(30);
        scene.special.movePointOfInterest(semaphore1a);
        scene.idle(10);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(semaphore1a, Direction.WEST)).attachKeyFrame().placeNearTarget().text("Semaphores show the current state of the signal below the pole");
        scene.idle(80);
        scene.special.movePointOfInterest(new Vec3(-3.0, 3.0, 8.0));
        scene.idle(5);
        scene.world.moveSection(trainElement, util.vector.of(-10.0, 0.0, 0.0), 35);
        scene.world.animateBogey(util.grid.at(13, 2, 7), 10.0f, 35);
        scene.special.moveParrot(birb1, util.vector.of(-10.0, 0.0, 0.0), 35);
        scene.idle(5);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.GREEN);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.GREEN);
        scene.world.changeSignalState(signal4, SignalBlockEntity.SignalState.RED);
        scene.idle(5);
        scene.world.hideIndependentSection(trainElement, null);
        scene.special.hideElement(birb1, null);
        scene.idle(10);
        scene.world.moveSection(trainElement2, util.vector.of(-11.5, 0.0, 0.0), 40);
        scene.world.animateBogey(util.grid.at(13, 2, 1), 11.5f, 40);
        scene.special.moveParrot(birb2, util.vector.of(-11.5, 0.0, 0.0), 40);
        scene.idle(3);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.RED);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.RED);
        scene.idle(5);
        scene.world.changeSignalState(signal4, SignalBlockEntity.SignalState.GREEN);
        scene.idle(20);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.GREEN);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.GREEN);
        scene.world.changeSignalState(signal4, SignalBlockEntity.SignalState.RED);
        scene.idle(20);
        scene.special.movePointOfInterest(signal1);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(signal1, Direction.EAST), Pointing.RIGHT).rightClick().withWrench(), 40);
        scene.idle(6);
        scene.world.cycleBlockProperty(signal1, (Property)SignalBlock.TYPE);
        scene.idle(15);
        float pY = 0.1875f;
        scene.overlay.showText(60).pointAt(util.vector.blockSurface(signal1, Direction.WEST)).attachKeyFrame().placeNearTarget().text("If a brass signal has multiple valid exit paths...");
        scene.idle(70);
        Vec3 m1 = util.vector.topOf(12, 0, 7).m_82520_(0.0, (double)pY, 0.0);
        Vec3 m2 = util.vector.topOf(4, 0, 7).m_82520_(0.0, (double)pY, 0.0);
        Vec3 m3 = util.vector.topOf(12, 0, 3).m_82520_(0.0, (double)pY, 0.0);
        Vec3 m4 = util.vector.topOf(5, 0, 10).m_82520_(0.0, (double)pY, 0.0);
        Vec3 c1 = util.vector.topOf(8, 0, 7).m_82520_(0.0, (double)pY, 0.0);
        AABB bb = new AABB(m1, m1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb.m_82377_((double)0.45f, 0.0, (double)0.45f), 30);
        scene.idle(10);
        AABB bb2 = bb.m_82386_(-0.45, 0.0, 0.0);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, c1, m1.m_82520_(-0.45, 0.0, 0.0), 20);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m2.m_82520_(0.45, 0.0, 0.0), c1, 10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m4.m_82520_(0.45, 0.0, -0.45), c1, 10);
        scene.idle(20);
        scene.special.movePointOfInterest(semaphore1a);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(semaphore1a, Direction.WEST)).attachKeyFrame().placeNearTarget().text("... a second semaphore can be placed above the first");
        scene.idle(50);
        scene.world.restoreBlocks(util.select.position(semaphore1a.m_7494_()));
        scene.world.showSection(util.select.position(semaphore1b.m_7495_()), Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(util.select.position(semaphore1b), Direction.DOWN);
        scene.idle(30);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(semaphore1a, Direction.WEST)).attachKeyFrame().placeNearTarget().text("The bottom semaphore will now close if any of the available paths are blocked");
        scene.idle(70);
        bb2 = new AABB(new BlockPos((Vec3i)semaphore1a)).m_82377_(-0.25, 0.0, -0.25);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb2, bb2, 30);
        bb = new AABB(m1, m1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb.m_82377_((double)0.45f, 0.0, (double)0.45f), 30);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, c1, m1.m_82520_(-0.45, 0.0, 0.0), 20);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m2.m_82520_(0.45, 0.0, 0.0), c1, 10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m4.m_82520_(0.45, 0.0, -0.45), c1, 10);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, (Object)bb2, bb2, 30);
        scene.overlay.showBigLine(PonderPalette.RED, m2.m_82520_(0.45, 0.0, 0.0), m1.m_82520_(-0.45, 0.0, 0.0), 30);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.YELLOW);
        scene.special.movePointOfInterest(semaphore1b);
        scene.idle(30);
        scene.overlay.showText(60).pointAt(util.vector.blockSurface(semaphore1b, Direction.WEST)).attachKeyFrame().placeNearTarget().text("The top semaphore will close if all paths are blocked");
        scene.idle(60);
        bb2 = new AABB(new BlockPos((Vec3i)semaphore1b)).m_82377_(-0.25, 0.0, -0.25);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb2, bb2, 30);
        bb = new AABB(m1, m1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb.m_82377_((double)0.45f, 0.0, (double)0.45f), 30);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, c1, m1.m_82520_(-0.45, 0.0, 0.0), 20);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m2.m_82520_(0.45, 0.0, 0.0), c1, 10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m4.m_82520_(0.45, 0.0, -0.45), c1, 10);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb2, bb2, 30);
        scene.overlay.showBigLine(PonderPalette.GREEN, c1, m1.m_82520_(-0.45, 0.0, 0.0), 30);
        scene.overlay.showBigLine(PonderPalette.GREEN, m4.m_82520_(0.45, 0.0, -0.45), c1, 30);
        scene.idle(30);
        ElementLink trainElement3 = scene.world.showIndependentSection(train2, null);
        scene.world.rotateSection(trainElement3, 0.0, 45.0, 0.0, 0);
        scene.world.moveSection(trainElement3, util.vector.of(4.0, 0.0, -6.0), 0);
        scene.world.moveSection(trainElement3, util.vector.of(-14.0, 0.0, 14.0), 40);
        scene.world.animateBogey(util.grid.at(13, 2, 4), -14.0f, 40);
        ElementLink birb3 = scene.special.createBirb(util.vector.of(18.0, 3.5, -2.0), ParrotElement.FacePointOfInterestPose::new);
        scene.special.moveParrot(birb3, util.vector.of(-14.0, 0.0, 14.0), 40);
        scene.idle(12);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.RED);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.RED);
        scene.idle(20);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.GREEN);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.YELLOW);
        scene.world.changeSignalState(signal3, SignalBlockEntity.SignalState.RED);
        scene.idle(20);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb2, bb2, 30);
        bb = new AABB(m1, m1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb.m_82377_((double)0.45f, 0.0, (double)0.45f), 30);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, c1, m1.m_82520_(-0.45, 0.0, 0.0), 20);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m2.m_82520_(0.45, 0.0, 0.0), c1, 10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m4.m_82520_(0.45, 0.0, -0.45), c1, 10);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, (Object)bb2, bb2, 30);
        scene.overlay.showBigLine(PonderPalette.RED, m2.m_82520_(0.45, 0.0, 0.0), m1.m_82520_(-0.45, 0.0, 0.0), 30);
        scene.overlay.showBigLine(PonderPalette.RED, m4.m_82520_(0.45, 0.0, -0.45), c1, 30);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.RED);
        scene.idle(20);
        scene.special.movePointOfInterest(semaphore2b);
        scene.world.restoreBlocks(util.select.position(semaphore2a.m_7494_()));
        scene.world.showSection(util.select.position(semaphore2b.m_7495_()), Direction.DOWN);
        scene.idle(10);
        scene.world.showSection(util.select.position(semaphore2b), Direction.DOWN);
        scene.idle(30);
        scene.overlay.showText(80).pointAt(util.vector.blockSurface(semaphore2b, Direction.WEST)).attachKeyFrame().placeNearTarget().text("When 2 semaphores are placed on a non-brass signal, they both close simultaneously");
        scene.idle(80);
        trainElement = scene.world.showIndependentSection(train1, null);
        scene.world.rotateSection(trainElement, 0.0, 45.0, 0.0, 0);
        scene.world.moveSection(trainElement, util.vector.of(4.0, 0.0, -9.0), 0);
        scene.world.moveSection(trainElement, util.vector.of(-9.0, 0.0, 9.0), 40);
        scene.world.animateBogey(util.grid.at(13, 2, 7), -9.0f, 40);
        birb1 = scene.special.createBirb(util.vector.of(18.0, 3.5, -2.0), ParrotElement.FacePointOfInterestPose::new);
        scene.special.moveParrot(birb1, util.vector.of(-9.0, 0.0, 9.0), 40);
        scene.idle(15);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.RED);
        scene.idle(10);
    }

    public static void trackSwitch(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("train_switch", "Using Track Switches");
        scene.configureBasePlate(0, 0, 15);
        scene.scaleSceneView(0.45f);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        BlockPos switchPos = util.grid.at(4, 1, 1);
        BlockPos switchTargetPos = util.grid.at(7, 1, 1);
        BlockPos straightEndPos = util.grid.at(7, 1, 12);
        BlockPos leftButtonPos = util.grid.at(5, 1, 1);
        BlockPos straightButtonPos = util.grid.at(4, 1, 0);
        BlockPos rightButtonPos = util.grid.at(3, 1, 1);
        final BlockPos comparatorPos = util.grid.at(4, 1, 2);
        final BlockPos redstonePos = util.grid.at(4, 1, 3);
        BlockPos targetPos = util.grid.at(3, 1, 3);
        final BlockPos nixiePos = util.grid.at(3, 2, 3);
        BlockPos trackPos = util.grid.at(7, 1, 0);
        BlockPos leftTrackPos = util.grid.at(12, 1, 12);
        BlockPos leftTrack2Pos = util.grid.at(13, 1, 13);
        BlockPos rightTrackPos = util.grid.at(2, 1, 12);
        BlockPos rightTrack2Pos = util.grid.at(1, 1, 13);
        Selection leftTrack = util.select.position(leftTrackPos);
        Selection leftTrack2 = util.select.position(leftTrack2Pos);
        Selection rightTrack = util.select.position(rightTrackPos);
        Selection rightTrack2 = util.select.position(rightTrack2Pos);
        Selection switchSel = util.select.position(switchPos);
        Selection comparator = util.select.position(comparatorPos);
        Selection redstone = util.select.position(redstonePos);
        Selection targetBlock = util.select.position(targetPos);
        Selection nixie = util.select.position(nixiePos);
        Selection leftButton = util.select.position(leftButtonPos);
        Selection straightButton = util.select.position(straightButtonPos);
        Selection rightButton = util.select.position(rightButtonPos);
        scene.world.showSection(leftTrack, Direction.DOWN);
        scene.world.showSection(rightTrack, Direction.DOWN);
        for (int i = 0; i < 15; ++i) {
            scene.world.showSection(util.select.position(7, 1, i), Direction.DOWN);
            if (i == 1) {
                scene.world.showSection(leftTrack2, Direction.DOWN);
                scene.world.showSection(rightTrack2, Direction.DOWN);
            }
            scene.idle(1);
        }
        scene.idle(10);
        Vec3 target = util.vector.topOf(switchTargetPos.m_7495_());
        AABB bb = new AABB(target, target).m_82386_(0.0, 0.125, 0.0);
        scene.overlay.showControls(new InputWindowElement(target, Pointing.DOWN).rightClick().withItem(CRBlocks.ANDESITE_SWITCH.asStack()), 40);
        scene.idle(6);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, bb.m_82377_((double)0.45f, 0.0625, (double)0.45f), 60);
        scene.idle(10);
        scene.overlay.showText(50).pointAt(target).placeNearTarget().colored(PonderPalette.GREEN).text("Select a Train Track then place the Switch nearby");
        scene.idle(20);
        scene.world.showSection(switchSel, Direction.DOWN);
        TrainScenes.initSwitch(scene, switchPos, new TrackSwitchBlockEntity.PonderData(util.vector.topOf(switchTargetPos.m_7495_()), util.vector.topOf(leftTrackPos.m_7495_()), util.vector.topOf(straightEndPos.m_7495_()), util.vector.topOf(rightTrackPos.m_7495_())));
        scene.idle(15);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, new AABB(switchPos), 20);
        scene.idle(25);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(switchPos, Direction.WEST)).attachKeyFrame().placeNearTarget().text("The Switch will direct any Trains passing over the marker");
        scene.idle(70);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(switchPos, Direction.EAST), Pointing.RIGHT).rightClick(), 60);
        scene.idle(10);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(switchPos, Direction.WEST)).attachKeyFrame().placeNearTarget().text("Cycle the switch to the right by using it");
        TrainScenes.setSwitchState(scene, switchPos, TrackSwitchBlock.SwitchState.REVERSE_RIGHT);
        scene.idle(70);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(switchPos, Direction.EAST), Pointing.RIGHT).rightClick().whileSneaking(), 20);
        scene.idle(10);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(switchPos, Direction.WEST)).attachKeyFrame().placeNearTarget().text("Cycle the switch to the left by using it while sneaking");
        TrainScenes.setSwitchState(scene, switchPos, TrackSwitchBlock.SwitchState.NORMAL);
        scene.idle(25);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(switchPos, Direction.EAST), Pointing.RIGHT).rightClick().whileSneaking(), 40);
        TrainScenes.setSwitchState(scene, switchPos, TrackSwitchBlock.SwitchState.REVERSE_LEFT);
        scene.idle(45);
        scene.idle(20);
        scene.world.modifyBlock(redstonePos, state -> (BlockState)state.m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(1)), false);
        scene.world.modifyBlockEntity(nixiePos, NixieTubeBlockEntity.class, n -> n.updateRedstoneStrength(1));
        scene.world.showSection(comparator, Direction.DOWN);
        scene.idle(3);
        scene.world.showSection(redstone, Direction.DOWN);
        scene.idle(3);
        scene.world.showSection(targetBlock, Direction.DOWN);
        scene.idle(3);
        scene.world.showSection(nixie, Direction.DOWN);
        scene.idle(5);
        scene.overlay.showText(90).pointAt(util.vector.blockSurface(comparatorPos, Direction.WEST)).attachKeyFrame().placeNearTarget().text("Switches provide a comparator signal based on the direction: 1 for left, 0 for straight, and 2 for right");
        scene.idle(80);
        scene.world.showSection(leftButton, Direction.DOWN);
        scene.idle(2);
        scene.world.showSection(straightButton, Direction.DOWN);
        scene.idle(2);
        scene.world.showSection(rightButton, Direction.DOWN);
        scene.idle(5);
        scene.idle(20);
        scene.overlay.showText(90).pointAt(util.vector.topOf(rightButtonPos).m_82492_(0.0, 0.75, 0.0)).attachKeyFrame().placeNearTarget().text("Switch direction can also be set by a redstone signal, and can be locked by powering the bottom");
        scene.idle(15);
        scene.world.toggleRedstonePower(rightButton);
        TrainScenes.setSwitchState(scene, switchPos, TrackSwitchBlock.SwitchState.REVERSE_RIGHT);
        scene.world.modifyBlock(redstonePos, state -> (BlockState)state.m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(2)), false);
        scene.world.modifyBlockEntity(nixiePos, NixieTubeBlockEntity.class, n -> {
            n.updateRedstoneStrength(2);
            n.updateDisplayedStrings();
        });
        scene.idle(30);
        scene.world.toggleRedstonePower(rightButton);
        scene.idle(10);
        scene.world.toggleRedstonePower(straightButton);
        TrainScenes.setSwitchState(scene, switchPos, TrackSwitchBlock.SwitchState.NORMAL);
        scene.world.modifyBlock(redstonePos, state -> (BlockState)state.m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(0)), false);
        scene.world.modifyBlockEntity(nixiePos, NixieTubeBlockEntity.class, n -> {
            n.updateRedstoneStrength(0);
            n.updateDisplayedStrings();
        });
        scene.world.toggleRedstonePower(comparator);
        scene.idle(30);
        scene.world.toggleRedstonePower(straightButton);
        scene.idle(20);
        for (int i = 0; i < 3; ++i) {
            scene.world.createEntity(level -> new Arrow((Level)level, (double)switchPos.m_123341_() + 0.5, 30.0, (double)switchPos.m_123343_() + 0.5){

                protected void m_8060_(@NotNull BlockHitResult result) {
                    super.m_8060_(result);
                    BlockEntity blockEntity = this.f_19853_.m_7702_(result.m_82425_());
                    if (blockEntity instanceof TrackSwitchBlockEntity) {
                        TrackSwitchBlockEntity switchBE = (TrackSwitchBlockEntity)blockEntity;
                        switchBE.setStatePonder(switchBE.getState().nextStateForPonder(TrackSwitchBlock.SwitchConstraint.NONE));
                        int output = switchBE.getTargetAnalogOutput();
                        this.f_19853_.m_46597_(comparatorPos, (BlockState)this.f_19853_.m_8055_(comparatorPos).m_61124_((Property)ComparatorBlock.f_52496_, (Comparable)Boolean.valueOf(output != 0)));
                        this.f_19853_.m_46597_(redstonePos, (BlockState)this.f_19853_.m_8055_(redstonePos).m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(output)));
                        BlockEntity blockEntity2 = this.f_19853_.m_7702_(nixiePos);
                        if (blockEntity2 instanceof NixieTubeBlockEntity) {
                            NixieTubeBlockEntity nixieBE = (NixieTubeBlockEntity)blockEntity2;
                            nixieBE.updateRedstoneStrength(output);
                            nixieBE.updateDisplayedStrings();
                        }
                        if ((blockEntity2 = this.f_19853_) instanceof PonderWorld) {
                            PonderWorld ponderWorld = (PonderWorld)blockEntity2;
                            ponderWorld.scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
                        }
                    }
                    this.m_146870_();
                }
            });
            scene.idle(20);
            if (i != 0) continue;
            scene.overlay.showText(70).pointAt(util.vector.blockSurface(switchPos, Direction.WEST)).attachKeyFrame().placeNearTarget().text("Projectiles also cycle switches on impact");
        }
        scene.idle(60);
    }

    private static void initSwitch(SceneBuilder scene, final BlockPos switchPos, final TrackSwitchBlockEntity.PonderData data) {
        scene.addInstruction(new PonderInstruction(){

            public boolean isComplete() {
                return true;
            }

            private Optional<TrackSwitchBlockEntity> getSwitch(PonderScene scene) {
                BlockEntity blockEntity = scene.getWorld().m_7702_(switchPos);
                if (blockEntity instanceof TrackSwitchBlockEntity) {
                    TrackSwitchBlockEntity switchBE = (TrackSwitchBlockEntity)blockEntity;
                    return Optional.of(switchBE);
                }
                return Optional.empty();
            }

            public void reset(PonderScene scene) {
                super.reset(scene);
                this.getSwitch(scene).ifPresent(switchBE -> {
                    switchBE.ponderData = null;
                });
            }

            public void tick(PonderScene scene) {
                this.getSwitch(scene).ifPresent(switchBE -> {
                    switchBE.ponderData = data;
                });
            }
        });
    }

    private static void clearSwitch(SceneBuilder scene, final BlockPos switchPos) {
        scene.addInstruction(new PonderInstruction(){

            public boolean isComplete() {
                return true;
            }

            private Optional<TrackSwitchBlockEntity> getSwitch(PonderScene scene) {
                BlockEntity blockEntity = scene.getWorld().m_7702_(switchPos);
                if (blockEntity instanceof TrackSwitchBlockEntity) {
                    TrackSwitchBlockEntity switchBE = (TrackSwitchBlockEntity)blockEntity;
                    return Optional.of(switchBE);
                }
                return Optional.empty();
            }

            public void reset(PonderScene scene) {
                super.reset(scene);
                this.getSwitch(scene).ifPresent(switchBE -> {
                    switchBE.ponderData = null;
                });
            }

            public void tick(PonderScene scene) {
                this.getSwitch(scene).ifPresent(switchBE -> {
                    switchBE.ponderData = null;
                });
            }
        });
    }

    private static void setSwitchState(SceneBuilder scene, final BlockPos switchPos, final TrackSwitchBlock.SwitchState state) {
        scene.addInstruction(new PonderInstruction(){
            private TrackSwitchBlock.SwitchState prevState = TrackSwitchBlock.SwitchState.NORMAL;

            public boolean isComplete() {
                return true;
            }

            private Optional<TrackSwitchBlockEntity> getSwitch(PonderScene scene) {
                BlockEntity blockEntity = scene.getWorld().m_7702_(switchPos);
                if (blockEntity instanceof TrackSwitchBlockEntity) {
                    TrackSwitchBlockEntity switchBE = (TrackSwitchBlockEntity)blockEntity;
                    return Optional.of(switchBE);
                }
                return Optional.empty();
            }

            public void reset(PonderScene scene) {
                super.reset(scene);
                this.getSwitch(scene).ifPresent(switchBE -> switchBE.setStatePonder(this.prevState));
            }

            public void tick(PonderScene scene) {
                this.getSwitch(scene).ifPresent(switchBE -> {
                    this.prevState = switchBE.getState();
                    switchBE.setStatePonder(state);
                });
            }
        });
    }

    public static void coupling(SceneBuilder scene, SceneBuildingUtil util) {
        int i;
        scene.title("train_coupler", "Using a Coupler");
        scene.configureBasePlate(0, 0, 21);
        scene.scaleSceneView(0.45f);
        scene.showBasePlate();
        for (int i2 = 21; i2 >= 0; --i2) {
            scene.world.showSection(util.select.position(i2, 1, 10), Direction.DOWN);
            scene.idle(1);
        }
        BlockPos locoLeadingBogeyPos = new BlockPos(2, 2, 18);
        BlockPos locoTrailingBogeyPos = new BlockPos(5, 2, 18);
        BlockPos cargoBogeyPos = new BlockPos(17, 2, 18);
        Selection coupler = util.select.position(10, 1, 7);
        Selection redstoneDust = util.select.position(10, 1, 6);
        Selection button = util.select.position(10, 1, 5);
        Selection station = util.select.position(1, 1, 7);
        BlockPos couplerPad1 = new BlockPos(12, 1, 10);
        BlockPos couplerPad1Under = new BlockPos(12, 0, 10);
        BlockPos couplerPos = new BlockPos(10, 1, 7);
        BlockPos redstoneDustPos = new BlockPos(10, 1, 6);
        BlockPos buttonPos = new BlockPos(10, 1, 5);
        BlockPos stationPos = new BlockPos(1, 1, 7);
        Selection train1 = util.select.fromTo(0, 2, 20, 8, 6, 16);
        Selection train2 = util.select.fromTo(14, 2, 20, 20, 4, 16);
        Vec3 couplerPad1TopMarker = util.vector.topOf(couplerPad1Under).m_82520_(0.0, 0.1875, 0.0);
        Vec3 couplerTop = util.vector.topOf(couplerPos);
        Vec3 redstoneDustTop = util.vector.topOf(redstoneDustPos);
        Vec3 buttonTop = util.vector.topOf(buttonPos);
        Vec3 stationTop = util.vector.topOf(stationPos);
        AABB bb = new AABB(util.vector.topOf(couplerPad1Under), util.vector.topOf(couplerPad1Under)).m_82386_(0.0, 0.125, 0.0);
        scene.overlay.showControls(new InputWindowElement(couplerPad1TopMarker, Pointing.DOWN).rightClick().withItem(CRBlocks.TRACK_COUPLER.asStack()), 40);
        scene.idle(6);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, bb.m_82377_((double)0.45f, 0.0625, (double)0.45f), 100);
        scene.idle(10);
        scene.overlay.showText(70).pointAt(couplerPad1TopMarker).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text("Select a Train Track then place the Coupler nearby");
        scene.idle(60);
        scene.world.showSection(coupler, Direction.DOWN);
        scene.idle(15);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, new AABB(couplerPos), 20);
        scene.idle(25);
        scene.overlay.showText(100).pointAt(couplerTop).placeNearTarget().attachKeyFrame().text("The Train Coupler lets you couple and decouple trains without disassembling them");
        scene.idle(120);
        scene.overlay.showControls(new InputWindowElement(couplerTop, Pointing.DOWN).scroll().withWrench(), 60);
        scene.overlay.showScrollInput(couplerTop, Direction.DOWN, 60);
        scene.idle(5);
        scene.overlay.showText(70).pointAt(couplerTop).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text("By scrolling with a wrench you can change the gap between the couple/decouple pads");
        scene.idle(80);
        int delta = 0;
        for (i = 0; i < 11; ++i) {
            boolean back = i > 1 && i < 6;
            TrainScenes.movePlate(scene, util, couplerPos, new BlockPos(-3 - delta, 0, 3), i < 7 ? 6 : 2);
            delta += back ? -1 : 1;
        }
        scene.idle(30);
        scene.overlay.showControls(new InputWindowElement(couplerTop, Pointing.DOWN).rightClick().withWrench(), 60);
        scene.idle(5);
        scene.overlay.showText(70).pointAt(couplerTop).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text("By using a wrench you can cycle between coupling, decoupling, and both modes");
        scene.idle(80);
        for (i = 0; i < 3; ++i) {
            scene.world.modifyBlock(couplerPos, s -> (BlockState)s.m_61122_(TrackCouplerBlock.MODE), false);
            scene.idle(15);
        }
        scene.world.showSection(station, Direction.DOWN);
        scene.idle(5);
        scene.overlay.showText(70).pointAt(stationTop).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text("Stations can be used to help align trains for coupling");
        scene.idle(80);
        ElementLink trainElement1 = scene.world.showIndependentSection(train1, Direction.DOWN);
        ElementLink trainElement2 = scene.world.showIndependentSection(train2, Direction.DOWN);
        scene.world.moveSection(trainElement1, util.vector.of(20.0, 0.0, -8.0), 0);
        scene.world.moveSection(trainElement2, util.vector.of(15.0, 0.0, -8.0), 0);
        TrainScenes.coupleTrain(scene, cargoBogeyPos, 8.0, Direction.NORTH);
        scene.world.moveSection(trainElement1, util.vector.of(-20.0, 0.0, 0.0), 50);
        scene.world.moveSection(trainElement2, util.vector.of(-20.0, 0.0, 0.0), 50);
        scene.world.animateBogey(locoLeadingBogeyPos, 20.0f, 50);
        scene.world.animateBogey(locoTrailingBogeyPos, 20.0f, 50);
        scene.world.animateBogey(cargoBogeyPos, 20.0f, 50);
        scene.idle(50);
        scene.world.animateTrainStation(stationPos, true);
        scene.rotateCameraY(20.0f);
        scene.idle(10);
        scene.world.showSection(redstoneDust, Direction.DOWN);
        scene.idle(1);
        scene.world.showSection(button, Direction.DOWN);
        scene.idle(20);
        scene.overlay.showText(70).pointAt(buttonTop).placeNearTarget().colored(PonderPalette.RED).attachKeyFrame().text("By powering a coupler you can couple/decouple a properly aligned train");
        scene.idle(80);
        scene.world.modifyBlock(buttonPos, s -> (BlockState)s.m_61124_((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(true)), false);
        scene.world.modifyBlock(redstoneDustPos, s -> (BlockState)s.m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(15)), false);
        TrainScenes.decoupleTrain(scene, cargoBogeyPos);
        scene.idle(20);
        scene.world.modifyBlock(buttonPos, s -> (BlockState)s.m_61124_((Property)ButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)), false);
        scene.world.modifyBlock(redstoneDustPos, s -> (BlockState)s.m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(0)), false);
        scene.idle(5);
        scene.world.moveSection(trainElement1, util.vector.of(-40.0, 0.0, 0.0), 100);
        scene.world.animateBogey(locoLeadingBogeyPos, 40.0f, 100);
        scene.world.animateBogey(locoTrailingBogeyPos, 40.0f, 100);
        scene.world.animateTrainStation(stationPos, false);
        scene.idle(10);
        scene.rotateCameraY(-20.0f);
    }

    public static void movePlate(SceneBuilder scene, SceneBuildingUtil util, BlockPos couplerPos, BlockPos plate, int idleTicks) {
        scene.world.modifyBlockEntityNBT(util.select.position(couplerPos), TrackCouplerBlockEntity.class, nbt -> nbt.m_128365_("SecondaryTargetTrack", (Tag)NbtUtils.m_129224_((BlockPos)plate)));
        scene.idle(idleTicks);
    }

    public static void coupleTrain(SceneBuilder scene, BlockPos pos, double distance, Direction direction) {
        scene.addInstruction(PonderInstruction.simple(ponderScene -> {
            PonderWorld world = ponderScene.getWorld();
            world.m_141902_(pos, (BlockEntityType)AllBlockEntityTypes.BOGEY.get()).ifPresent(sbte -> {
                if (sbte instanceof IStandardBogeyTEVirtualCoupling) {
                    IStandardBogeyTEVirtualCoupling virtualCoupling = (IStandardBogeyTEVirtualCoupling)sbte;
                    virtualCoupling.setCouplingDistance(distance);
                    virtualCoupling.setCouplingDirection(direction);
                }
            });
        }));
    }

    public static void decoupleTrain(SceneBuilder scene, BlockPos pos) {
        scene.addInstruction(PonderInstruction.simple(ponderScene -> {
            PonderWorld world = ponderScene.getWorld();
            world.m_141902_(pos, (BlockEntityType)AllBlockEntityTypes.BOGEY.get()).ifPresent(sbte -> {
                if (sbte instanceof IStandardBogeyTEVirtualCoupling) {
                    IStandardBogeyTEVirtualCoupling virtualCoupling = (IStandardBogeyTEVirtualCoupling)sbte;
                    virtualCoupling.setCouplingDistance(-1.0);
                    virtualCoupling.setCouplingDirection(Direction.UP);
                }
            });
        }));
    }
}

