/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.mixin_interfaces.IFuelInventory;
import com.railwayteam.railways.util.FluidUtils;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.MountedFluidStorage;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MountedStorageManager.class}, remap=false)
public abstract class MixinMountedStorageManager
implements IFuelInventory {
    @Unique
    private CombinedTankWrapper railways$fluidFuelInventory;
    @Unique
    private Map<BlockPos, MountedFluidStorage> railways$fluidFuelStorage = new HashMap<BlockPos, MountedFluidStorage>();

    @Inject(method={"entityTick"}, at={@At(value="TAIL")})
    private void entityTick(AbstractContraptionEntity entity, CallbackInfo ci) {
        this.railways$fluidFuelStorage.forEach((pos, mfs) -> mfs.tick((Entity)entity, pos, entity.f_19853_.f_46443_));
    }

    @Inject(method={"addBlock"}, at={@At(value="TAIL")})
    private void addBlock(BlockPos localPos, BlockEntity be, CallbackInfo ci) {
        if (be != null && FluidUtils.canUseAsFuelStorage(be)) {
            this.railways$fluidFuelStorage.put(localPos, new MountedFluidStorage(be));
        }
    }

    @Inject(method={"read"}, at={@At(value="HEAD")})
    private void read(CompoundTag nbt, Map<BlockPos, BlockEntity> presentBlockEntities, boolean clientPacket, CallbackInfo ci) {
        this.railways$fluidFuelStorage.clear();
        NBTHelper.iterateCompoundList((ListTag)nbt.m_128437_("FluidFuelStorage", 10), c -> this.railways$fluidFuelStorage.put(NbtUtils.m_129239_((CompoundTag)c.m_128469_("Pos")), MountedFluidStorage.deserialize((CompoundTag)c.m_128469_("Data"))));
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    private void write(CompoundTag nbt, boolean clientPacket, CallbackInfo ci) {
        ListTag fluidFuelStorageNBT = new ListTag();
        for (BlockPos pos : this.railways$fluidFuelStorage.keySet()) {
            CompoundTag c = new CompoundTag();
            MountedFluidStorage mountedStorage = this.railways$fluidFuelStorage.get(pos);
            if (!mountedStorage.isValid()) continue;
            c.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            c.m_128365_("Data", (Tag)mountedStorage.serialize());
            fluidFuelStorageNBT.add((Object)c);
        }
        nbt.m_128365_("FluidFuelStorage", (Tag)fluidFuelStorageNBT);
    }

    @Inject(method={"removeStorageFromWorld"}, at={@At(value="TAIL")})
    public void removeStorageFromWorld(CallbackInfo ci) {
        this.railways$fluidFuelStorage.values().forEach(MountedFluidStorage::removeStorageFromWorld);
    }

    @Inject(method={"addStorageToWorld"}, at={@At(value="TAIL")})
    private void addStorageToWorld(StructureTemplate.StructureBlockInfo block, BlockEntity blockEntity, CallbackInfo ci) {
        MountedFluidStorage mountedStorage;
        if (this.railways$fluidFuelStorage.containsKey(block.f_74675_()) && (mountedStorage = this.railways$fluidFuelStorage.get(block.f_74675_())).isValid()) {
            mountedStorage.addStorageToWorld(blockEntity);
        }
    }

    @Override
    public void railways$setFuelFluids(CombinedTankWrapper combinedTankWrapper) {
        this.railways$fluidFuelInventory = combinedTankWrapper;
    }

    @Override
    public CombinedTankWrapper railways$getFuelFluids() {
        return this.railways$fluidFuelInventory;
    }

    @Override
    public void railways$setFluidFuelStorage(Map<BlockPos, MountedFluidStorage> storageMap) {
        this.railways$fluidFuelStorage = storageMap;
    }

    @Override
    public Map<BlockPos, MountedFluidStorage> railways$getFluidFuelStorage() {
        return this.railways$fluidFuelStorage;
    }
}

