/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.network.ClientboundSyncCapabilityPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class BackpackContainer
implements MenuProvider,
Nameable {
    public final ItemStack stack;
    public final Player player;
    public final byte screenID;

    public BackpackContainer(ItemStack stack, Player player, byte screenID) {
        this.stack = stack;
        this.player = player;
        this.screenID = screenID;
    }

    public Component m_7755_() {
        return Component.m_237115_((String)"screen.travelersbackpack.item");
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"screen.travelersbackpack.item");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (this.screenID == 2) {
            return new BackpackItemMenu(pContainerId, pPlayerInventory, CapabilityUtils.getBackpackWrapper(this.player));
        }
        return new BackpackItemMenu(pContainerId, pPlayerInventory, new BackpackWrapper(this.stack, this.screenID, pPlayer, (LevelAccessor)pPlayer.m_9236_()));
    }

    public static FriendlyByteBuf saveExtraData(FriendlyByteBuf buf, @Nullable Player target, ItemStack stack, byte screenID) {
        buf.writeByte((int)screenID);
        buf.writeInt(target == null ? -1 : target.m_19879_());
        return buf;
    }

    public static void openBackpack(ServerPlayer serverPlayerEntity, ItemStack stack, byte screenID) {
        if (!serverPlayerEntity.m_9236_().f_46443_) {
            NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)new BackpackContainer(stack, (Player)serverPlayerEntity, screenID), buf -> BackpackContainer.saveExtraData(buf, null, stack, screenID));
        }
    }

    public static void openAnotherPlayerBackpack(ServerPlayer opener, ServerPlayer targetPlayer, ItemStack stack, byte screenID) {
        if (!opener.m_9236_().f_46443_) {
            BackpackContainer.synchroniseToOpener(opener, targetPlayer);
            NetworkHooks.openScreen((ServerPlayer)opener, (MenuProvider)new BackpackContainer(stack, (Player)targetPlayer, screenID), buf -> BackpackContainer.saveExtraData(buf, (Player)targetPlayer, stack, screenID));
        }
    }

    public static void synchroniseToOpener(ServerPlayer opener, ServerPlayer target) {
        if (opener != null) {
            CapabilityUtils.getCapability((Player)target).ifPresent(cap -> PacketDistributorHelper.sendToPlayer(opener, new ClientboundSyncCapabilityPacket(target.m_19879_(), cap.getBackpack())));
        }
    }
}

