/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackWearable;
import com.tiviacz.travelersbackpack.commands.AccessCommand;
import com.tiviacz.travelersbackpack.commands.ClearCommand;
import com.tiviacz.travelersbackpack.commands.RestoreCommand;
import com.tiviacz.travelersbackpack.commands.UnpackCommand;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipe;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSendMessagePacket;
import com.tiviacz.travelersbackpack.network.ClientboundSyncCapabilityPacket;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.LogHelper;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.server.command.ConfigCommand;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NeoForgeEventHandler {
    public static final List<Supplier<Item>> UPGRADES = Arrays.asList(() -> (Item)ModItems.IRON_TIER_UPGRADE.get(), () -> (Item)ModItems.GOLD_TIER_UPGRADE.get(), () -> (Item)ModItems.DIAMOND_TIER_UPGRADE.get(), () -> (Item)ModItems.NETHERITE_TIER_UPGRADE.get());
    private static boolean checkAbilitiesForRemoval = true;
    private static long nextBackpackCountCheck = 0L;
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 100;

    @SubscribeEvent
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        Level level = event.getEntity().m_9236_();
        if (event.getNewSpawn() != null) {
            Block block = level.m_8055_(event.getNewSpawn()).m_60734_();
            if (!level.f_46443_ && block instanceof SleepingBagBlock && !event.isForced()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity backpack;
        BlockEntity list;
        BlockEntity standardBackpack;
        BackpackBlockEntity backpackBlockEntity;
        BlockEntity oldSleepingBag;
        BackpackBlockEntity blockEntity;
        BlockEntity context;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.rightClickUnequip.get()).booleanValue() && !TravelersBackpack.enableIntegration() && CapabilityUtils.isWearingBackpack(player) && !level.f_46443_ && player.m_6144_() && hand == InteractionHand.MAIN_HAND && player.m_21205_().m_41619_()) {
            TravelersBackpackItem item;
            Item item2;
            ItemStack backpackStack = CapabilityUtils.getWearingBackpack(player).m_41777_();
            context = new UseOnContext(level, player, hand, backpackStack, event.getHitVec());
            boolean quickPickupFlag = level.m_8055_(pos).m_60734_() instanceof TravelersBackpackBlock;
            if (!quickPickupFlag && (item2 = backpackStack.m_41720_()) instanceof TravelersBackpackItem && (item = (TravelersBackpackItem)item2).m_40576_(new BlockPlaceContext((UseOnContext)context)) == InteractionResult.m_19078_((boolean)level.f_46443_)) {
                player.m_21011_(hand, true);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.05f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
                CapabilityUtils.getCapability(player).ifPresent(data -> {
                    data.remove();
                    data.synchronise();
                });
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
        }
        if (player.m_6144_() && hand == InteractionHand.MAIN_HAND && player.m_21205_().m_204117_(ModTags.SLEEPING_BAGS) && (context = level.m_7702_(pos)) instanceof BackpackBlockEntity) {
            blockEntity = (BackpackBlockEntity)context;
            oldSleepingBag = blockEntity.getProperSleepingBag().m_60734_().m_5456_().m_7968_();
            blockEntity.getWrapper().setSleepingBagColor(ShapedBackpackRecipe.getProperColor(player.m_21205_().m_41720_()));
            if (!level.f_46443_) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_7494_().m_123342_(), (double)pos.m_123343_(), (ItemStack)oldSleepingBag);
                player.m_21205_().m_41774_(1);
            }
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (player.m_6144_() && hand == InteractionHand.MAIN_HAND && player.m_21205_().m_150930_(Items.f_42574_) && (oldSleepingBag = level.m_7702_(pos)) instanceof BackpackBlockEntity && !(backpackBlockEntity = (BackpackBlockEntity)oldSleepingBag).getWrapper().getBackpackStack().m_150930_(((TravelersBackpackItem)((Object)ModItems.STANDARD_TRAVELERS_BACKPACK.get())).m_5456_())) {
            standardBackpack = new ItemStack((ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get(), 1);
            backpackBlockEntity.toItemStack((ItemStack)standardBackpack);
            Direction direction = (Direction)level.m_8055_(pos).m_61143_((Property)TravelersBackpackBlock.FACING);
            if (!level.f_46443_ && level.m_46597_(pos, Blocks.f_50016_.m_49966_())) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)standardBackpack);
                backpackBlockEntity.removeSleepingBag(level, direction);
                level.m_5594_(null, backpackBlockEntity.m_58899_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_146852_(GameEvent.f_157781_, (Entity)player);
                player.m_21205_().m_41622_(1, (LivingEntity)player, consumer -> consumer.m_21190_(hand));
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (player.m_6144_() && player.m_21205_().m_41720_() == ModItems.BLANK_UPGRADE.get() && (standardBackpack = level.m_7702_(pos)) instanceof BackpackBlockEntity) {
            ItemStack stackInSlot;
            int i;
            blockEntity = (BackpackBlockEntity)standardBackpack;
            list = NonNullList.m_122779_();
            for (i = 0; i < blockEntity.getWrapper().getStorage().getSlots(); ++i) {
                stackInSlot = blockEntity.getWrapper().getStorage().getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                list.add((Object)stackInSlot);
            }
            for (i = 0; i < blockEntity.getWrapper().getTools().getSlots(); ++i) {
                stackInSlot = blockEntity.getWrapper().getTools().getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                list.add((Object)stackInSlot);
            }
            for (i = 0; i < blockEntity.getWrapper().getUpgrades().getSlots(); ++i) {
                stackInSlot = blockEntity.getWrapper().getUpgrades().getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                list.add((Object)stackInSlot);
            }
            int tier = NbtHelper.getOrDefault(blockEntity.getWrapper().getBackpackStack(), "Tier", 0);
            if (tier != 0) {
                list.addAll(NeoForgeEventHandler.getUpgrades(tier));
            }
            if (!blockEntity.getWrapper().getUnsortableSlots().isEmpty()) {
                blockEntity.getWrapper().setUnsortableSlots(List.of());
            }
            if (!blockEntity.getWrapper().getMemorySlots().isEmpty()) {
                blockEntity.getWrapper().setMemorySlots(List.of());
            }
            if (!level.f_46443_) {
                Containers.m_19010_((Level)level, (BlockPos)pos.m_7494_(), (NonNullList)list);
            }
            blockEntity.getWrapper().removeRenderInfo();
            ItemStack backpackCopy = blockEntity.getWrapper().getBackpackStack().m_41777_();
            NeoForgeEventHandler.initializeDefaultSize(backpackCopy);
            backpackCopy.m_41783_().m_128405_("Tier", Tiers.LEATHER.getOrdinal());
            backpackCopy.m_41783_().m_128473_("Inventory");
            backpackCopy.m_41783_().m_128473_("Upgrades");
            backpackCopy.m_41783_().m_128473_("ToolsInventory");
            blockEntity.removeWrapper();
            blockEntity.setBackpack(backpackCopy);
            blockEntity.getWrapper().saveHandler.run();
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.rightClickEquip.get()).booleanValue() && (list = level.m_7702_(pos)) instanceof BackpackBlockEntity) {
            backpackBlockEntity = (BackpackBlockEntity)list;
            if (player.m_6144_() && !CapabilityUtils.isWearingBackpack(player) && !TravelersBackpack.enableIntegration()) {
                if (player.m_21120_(hand).m_41720_() instanceof BlockItem) {
                    return;
                }
                backpack = new ItemStack((ItemLike)level.m_8055_(pos).m_60734_(), 1).m_41777_();
                backpackBlockEntity.toItemStack((ItemStack)backpack);
                Direction direction = (Direction)level.m_8055_(pos).m_61143_((Property)TravelersBackpackBlock.FACING);
                if (!level.f_46443_ && level.m_46597_(pos, Blocks.f_50016_.m_49966_())) {
                    CapabilityUtils.equipBackpack(player, (ItemStack)backpack);
                    backpackBlockEntity.removeSleepingBag(level, direction);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    return;
                }
            }
        }
        if ((backpack = level.m_7702_(pos)) instanceof BackpackBlockEntity) {
            backpackBlockEntity = (BackpackBlockEntity)backpack;
            if (player.m_6144_() && hand == InteractionHand.MAIN_HAND && player.m_21205_().m_41619_()) {
                backpack = new ItemStack((ItemLike)level.m_8055_(pos).m_60734_(), 1).m_41777_();
                backpackBlockEntity.toItemStack((ItemStack)backpack);
                Direction direction = (Direction)level.m_8055_(pos).m_61143_((Property)TravelersBackpackBlock.FACING);
                if (!level.f_46443_ && level.m_46597_(pos, Blocks.f_50016_.m_49966_())) {
                    player.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)backpack);
                    backpackBlockEntity.removeSleepingBag(level, direction);
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
            }
        }
    }

    public static NonNullList<ItemStack> getUpgrades(int tier) {
        NonNullList list = NonNullList.m_122779_();
        for (int i = 0; i < tier; ++i) {
            list.add((Object)UPGRADES.get(i).get().m_7968_());
        }
        return list;
    }

    public static void initializeDefaultSize(ItemStack stack) {
        Tiers.Tier tier = Tiers.LEATHER;
        NbtHelper.set(stack, "Tier", tier.getOrdinal());
        NbtHelper.set(stack, "StorageSlots", tier.getStorageSlots());
        NbtHelper.set(stack, "UpgradeSlots", tier.getUpgradeSlots());
        NbtHelper.set(stack, "ToolSlots", tier.getToolSlots());
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            TravelersBackpackWearable travelersBackpack = new TravelersBackpackWearable(player);
            event.addCapability(TravelersBackpackCapability.ID, TravelersBackpackCapability.createProvider(travelersBackpack));
        }
    }

    @SubscribeEvent
    public static void onEnderManAngerEvent(EnderManAngerEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.pumpkinAbility(event);
        }
    }

    @SubscribeEvent
    public static void blockBlazeProjectile(ProjectileImpactEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.blazeAbility(event);
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingChangeTargetEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.ghastAbility(event);
        }
    }

    @SubscribeEvent
    public static void onHit(AttackEntityEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.beeAbility(event);
        }
    }

    @SubscribeEvent
    public static void onExpPickup(PlayerXpEvent.PickupXp event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.ABILITIES.lapisAbility(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CapabilityUtils.isWearingBackpack(player = (Player)livingEntity) && ((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() && BackpackAbilities.creeperAbility(event)) {
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDrops(LivingDropsEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CapabilityUtils.isWearingBackpack(player = (Player)livingEntity)) {
            if (TravelersBackpack.enableIntegration()) {
                if (!player.m_9236_().f_46443_) {
                    BackpackManager.addBackpack((ServerPlayer)player, CapabilityUtils.getWearingBackpack(player));
                }
                return;
            }
            if (player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                return;
            }
            ItemStack stack = CapabilityUtils.getWearingBackpack(player);
            if (BackpackDeathHelper.onPlayerDrops(player.m_9236_(), player, stack)) {
                if (player.m_9236_().f_46443_) {
                    return;
                }
                ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                itemEntity.m_32060_();
                PacketDistributorHelper.sendToPlayer((ServerPlayer)player, new ClientboundSendMessagePacket(true, player.m_20183_()));
                LogHelper.info("There's no space for backpack. Dropping backpack item at X: " + player.m_20183_().m_123341_() + " Y: " + player.m_20186_() + " Z: " + player.m_20183_().m_123343_(), new Object[0]);
                event.getDrops().add(itemEntity);
                CapabilityUtils.getCapability(player).ifPresent(attachment -> {
                    attachment.remove();
                    attachment.synchronise();
                });
            }
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().m_6095_()) && event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof TravelersBackpackItem) {
            if (!(event.getSource().m_7639_() instanceof Player)) {
                return;
            }
            ItemEntity itemEntity = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), event.getEntity().m_6844_(EquipmentSlot.CHEST));
            event.getDrops().add(itemEntity);
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        CapabilityUtils.getCapability(oldPlayer).ifPresent(oldTravelersBackpack -> CapabilityUtils.getCapability(event.getEntity()).ifPresent(newTravelersBackpack -> newTravelersBackpack.equipBackpack(oldTravelersBackpack.getBackpack())));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerRespawnEvent event) {
        CapabilityUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CapabilityUtils.synchronise(player);
        }
    }

    @SubscribeEvent
    public static void finalizeSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.world.spawnEntitiesWithBackpack.get()).booleanValue() && event.getEntity().m_6844_(EquipmentSlot.CHEST).m_41619_() && Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().m_6095_()) && (double)event.getLevel().m_213780_().m_188501_() < (Double)TravelersBackpackConfig.SERVER.world.chance.get()) {
            boolean isNether = event.getEntity().m_6095_() == EntityType.f_20511_ || event.getEntity().m_6095_() == EntityType.f_20497_;
            RandomSource rand = event.getLevel().m_213780_();
            ItemStack backpack = isNether ? ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.get(rand.m_216332_(0, ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.size() - 1)).m_7968_() : ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.get(rand.m_216332_(0, ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.size() - 1)).m_7968_();
            NbtHelper.set(backpack, "SleepingBagColor", DyeColor.values()[rand.m_216332_(0, DyeColor.values().length - 1)].m_41060_());
            boolean flag = false;
            if (rand.m_188501_() > 0.5f) {
                NbtHelper.set(backpack, "StarterUpgrades", List.of(((TanksUpgradeItem)((Object)ModItems.TANKS_UPGRADE.get())).m_7968_()));
                flag = true;
            }
            if (rand.m_188501_() > 0.25f) {
                NbtHelper.set(backpack, "Color", rand.m_188502_());
            }
            if (flag) {
                NbtHelper.set(backpack, "RenderInfo", TanksUpgradeItem.writeToRenderData());
            } else {
                NbtHelper.set(backpack, "RenderInfo", RenderInfo.EMPTY);
            }
            event.getEntity().m_8061_(EquipmentSlot.CHEST, backpack);
        }
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer target = (ServerPlayer)entity;
            if (!target.m_9236_().f_46443_) {
                CapabilityUtils.getCapability((Player)target).ifPresent(data -> PacketDistributorHelper.sendToPlayer((ServerPlayer)event.getEntity(), new ClientboundSyncCapabilityPacket(target.m_19879_(), data.getBackpack())));
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (CapabilityUtils.isWearingBackpack(event.player)) {
            BackpackWrapper.tick(CapabilityUtils.getWearingBackpack(event.player), event.player, false);
        }
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(event.player)) && !checkAbilitiesForRemoval && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
            checkAbilitiesForRemoval = true;
        }
        if (!(!checkAbilitiesForRemoval || event.player.m_9236_().f_46443_ || CapabilityUtils.isWearingBackpack(event.player) && ((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue())) {
            BackpackAbilities.ABILITIES.armorAbilityRemovals(event.player);
            checkAbilitiesForRemoval = false;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!((Boolean)TravelersBackpackConfig.SERVER.slownessDebuff.tooManyBackpacksSlowness.get()).booleanValue() || nextBackpackCountCheck > event.level.m_46467_()) {
            return;
        }
        nextBackpackCountCheck = event.level.m_46467_() + 100L;
        event.level.m_6907_().forEach(player -> {
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            AtomicInteger numberOfBackpacks = NeoForgeEventHandler.checkBackpacksForSlowness(player);
            if (numberOfBackpacks.get() == 0) {
                return;
            }
            int maxNumberOfBackpacks = (Integer)TravelersBackpackConfig.SERVER.slownessDebuff.maxNumberOfBackpacks.get();
            if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * (Double)TravelersBackpackConfig.SERVER.slownessDebuff.slownessPerExcessedBackpack.get()));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, numberOfSlownessLevels - 1, false, false));
            }
        });
    }

    public static AtomicInteger checkBackpacksForSlowness(Player player) {
        AtomicInteger atomic = new AtomicInteger(0);
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (!(((ItemStack)player.m_150109_().f_35974_.get(i)).m_41720_() instanceof TravelersBackpackItem)) continue;
            atomic.incrementAndGet();
        }
        if (((ItemStack)player.m_150109_().f_35976_.get(0)).m_41720_() instanceof TravelersBackpackItem) {
            atomic.incrementAndGet();
        }
        return atomic;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        new AccessCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new RestoreCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClearCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new UnpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void addVillagerTrade(VillagerTradesEvent event) {
        if (((Boolean)TravelersBackpackConfig.COMMON.enableVillagerTrade.get()).booleanValue() && event.getType() == VillagerProfession.f_35594_) {
            ((List)event.getTrades().get(3)).add((trader, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, random.m_188503_(64) + 48), new ItemStack((ItemLike)((TravelersBackpackItem)((Object)((Object)ModItems.VILLAGER_TRAVELERS_BACKPACK.get()))).m_5456_(), 1), 1, 50, 0.5f));
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        ItemEntity itemEntity = event.getItem();
        if (itemEntity.m_32055_().m_41619_() || itemEntity.f_31986_ > 0) {
            return;
        }
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (CapabilityUtils.isWearingBackpack(player)) {
            ItemStack remainingStack;
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapper(player);
            if (wrapper.getUpgradeManager().pickupUpgrade.isPresent() && wrapper.getUpgradeManager().pickupUpgrade.get().canPickup(itemEntity.m_32055_()) && (remainingStack = ItemHandlerHelper.insertItemStacked((IItemHandler)new StorageAccessWrapper(wrapper, wrapper.getStorage()), (ItemStack)itemEntity.m_32055_(), (boolean)false)) != itemEntity.m_32055_()) {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 1.4f + 2.0f);
                itemEntity.m_32045_(remainingStack);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }
}

