/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup.registration;

import igentuman.nc.content.fuel.FuelManager;
import igentuman.nc.content.materials.Materials;
import igentuman.nc.item.ItemFuel;
import igentuman.nc.setup.registration.Registries;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public class FissionFuel {
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties();
    public static HashMap<List<String>, RegistryObject<Item>> NC_FUEL = new HashMap();
    public static HashMap<List<String>, RegistryObject<Item>> NC_DEPLETED_FUEL = new HashMap();
    public static HashMap<String, RegistryObject<Item>> NC_ISOTOPES = new HashMap();

    public static void init() {
        FissionFuel.registerFuel();
        FissionFuel.registerIsotopes();
    }

    public static RegistryObject<Item> fuel(String name, String type, String subType) {
        return Registries.ITEMS.register("fuel_" + name + "_" + type.replace("-", "_") + subType, () -> new ItemFuel(ITEM_PROPERTIES, name, type, subType));
    }

    public static RegistryObject<Item> depletedFuel(String name, String type, String subType) {
        return Registries.ITEMS.register("depleted_fuel_" + name + "_" + type.replace("-", "_") + subType, () -> new Item(ITEM_PROPERTIES));
    }

    private static void registerFuel() {
        for (String name : FuelManager.all().keySet()) {
            for (String subType : FuelManager.all().get(name).keySet()) {
                NC_FUEL.put(List.of("fuel", name, subType, ""), FissionFuel.fuel(name, subType, ""));
                NC_FUEL.put(List.of("fuel", name, subType, "ox"), FissionFuel.fuel(name, subType, "_ox"));
                NC_FUEL.put(List.of("fuel", name, subType, "ni"), FissionFuel.fuel(name, subType, "_ni"));
                NC_FUEL.put(List.of("fuel", name, subType, "za"), FissionFuel.fuel(name, subType, "_za"));
                NC_FUEL.put(List.of("fuel", name, subType, "tr"), FissionFuel.fuel(name, subType, "_tr"));
                NC_DEPLETED_FUEL.put(List.of("depleted", name, subType, ""), FissionFuel.depletedFuel(name, subType, ""));
                NC_DEPLETED_FUEL.put(List.of("depleted", name, subType, "ox"), FissionFuel.depletedFuel(name, subType, "_ox"));
                NC_DEPLETED_FUEL.put(List.of("depleted", name, subType, "ni"), FissionFuel.depletedFuel(name, subType, "_ni"));
                NC_DEPLETED_FUEL.put(List.of("depleted", name, subType, "za"), FissionFuel.depletedFuel(name, subType, "_za"));
                NC_DEPLETED_FUEL.put(List.of("depleted", name, subType, "tr"), FissionFuel.depletedFuel(name, subType, "_tr"));
            }
        }
    }

    public static void registerIsotopes() {
        for (String name : Materials.isotopes()) {
            for (String type : new String[]{"", "_za", "_ox", "_ni"}) {
                NC_ISOTOPES.put(name + type, (RegistryObject<Item>)Registries.ITEMS.register(name.replace("/", "_") + type, () -> new Item(ITEM_PROPERTIES)));
            }
        }
    }
}

