/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.type;

import igentuman.nc.compat.GlobalVars;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.InputIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.util.annotation.NothingNullByDefault;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

@NothingNullByDefault
public abstract class NcRecipe
extends AbstractRecipe {
    public final double rarityModifier;

    public NcRecipe(ResourceLocation id, ItemStackIngredient[] inputItems, ItemStackIngredient[] outputItems, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double radiationModifier, double rarityModifier) {
        super(id);
        this.inputItems = inputItems;
        this.outputItems = outputItems;
        this.inputFluids = inputFluids;
        this.outputFluids = outputFluids;
        this.timeModifier = timeModifier;
        this.powerModifier = powerModifier;
        this.radiationModifier = radiationModifier;
        this.rarityModifier = rarityModifier;
        GlobalVars.CATALYSTS.put(this.codeId, List.of(this.m_8042_()));
        GlobalVars.RECIPE_CLASSES.put(this.codeId, this.getClass());
    }

    public NcRecipe(ResourceLocation id, ItemStackIngredient[] inputItems, ItemStackIngredient[] outputItems, double timeModifier, double powerModifier, double radiationModifier, double rarityModifier) {
        this(id, inputItems, outputItems, new FluidStackIngredient[0], new FluidStackIngredient[0], timeModifier, powerModifier, radiationModifier, rarityModifier);
    }

    public NcRecipe(ResourceLocation id, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double radiationModifier, double rarityModifier) {
        this(id, new ItemStackIngredient[0], new ItemStackIngredient[0], inputFluids, outputFluids, timeModifier, powerModifier, radiationModifier, rarityModifier);
    }

    public static ItemStackIngredient getBarrier() {
        return IngredientCreatorAccess.item().from(new ItemStack((ItemLike)Items.f_42127_));
    }

    protected FluidStackIngredient getEmptyFluid() {
        return (FluidStackIngredient)IngredientCreatorAccess.fluid().from(FluidStack.EMPTY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.inputItems.length);
        for (ItemStackIngredient itemStackIngredient : this.inputItems) {
            void var5_5;
            if (itemStackIngredient == null || itemStackIngredient.getRepresentations().isEmpty()) {
                ItemStackIngredient itemStackIngredient2 = NcRecipe.getBarrier();
            }
            var5_5.write(buffer);
        }
        buffer.writeInt(this.outputItems.length);
        for (ItemStackIngredient itemStackIngredient : this.outputItems) {
            void var5_11;
            if (itemStackIngredient == null || itemStackIngredient.getRepresentations().isEmpty()) {
                ItemStackIngredient itemStackIngredient3 = NcRecipe.getBarrier();
            }
            var5_11.write(buffer);
        }
        buffer.writeInt(this.inputFluids.length);
        for (InputIngredient<ItemStack> inputIngredient : this.inputFluids) {
            void var5_15;
            if (inputIngredient == null) {
                FluidStackIngredient fluidStackIngredient = this.getEmptyFluid();
            }
            var5_15.write(buffer);
        }
        buffer.writeInt(this.outputFluids.length);
        for (InputIngredient<ItemStack> inputIngredient : this.outputFluids) {
            void var5_19;
            if (inputIngredient == null) {
                FluidStackIngredient fluidStackIngredient = this.getEmptyFluid();
            }
            var5_19.write(buffer);
        }
        buffer.writeDouble(this.timeModifier);
        buffer.writeDouble(this.powerModifier);
        buffer.writeDouble(this.radiationModifier);
    }
}

