/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation.data;

import igentuman.nc.handler.config.RadiationConfig;
import igentuman.nc.radiation.data.IWorldRadiationCapability;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class WorldRadiation
implements IWorldRadiationCapability {
    private final double decaySpeed;
    private final double spreadGate;
    public HashMap<Long, Long> chunkRadiation;
    public HashMap<Long, Long> updatedChunks;
    public HashMap<Long, Long> newChunks;
    public Level level;

    public WorldRadiation() {
        this.decaySpeed = (double)((Integer)RadiationConfig.RADIATION_CONFIG.DECAY_SPEED.get()).intValue() / 10000.0;
        this.spreadGate = ((Integer)RadiationConfig.RADIATION_CONFIG.SPREAD_GATE.get()).intValue();
        this.chunkRadiation = new HashMap();
        this.updatedChunks = new HashMap();
        this.newChunks = new HashMap();
    }

    public static WorldRadiation deserialize(CompoundTag radiation) {
        WorldRadiation worldRadiation = new WorldRadiation();
        worldRadiation.deserializeNBT(radiation);
        return worldRadiation;
    }

    @Override
    public int getChunkRadiation(int chunkX, int chunkZ) {
        long id = WorldRadiation.pack(chunkX, chunkZ);
        int radiation = this.naturalRadiation(chunkX, chunkZ);
        if (this.chunkRadiation.containsKey(id)) {
            radiation += WorldRadiation.unpackX(this.chunkRadiation.get(id));
        }
        return radiation;
    }

    public void refresh(Level level) {
        Long[] ids;
        this.level = level;
        this.chunkRadiation.putAll(this.newChunks);
        this.updatedChunks.clear();
        this.newChunks.clear();
        Long[] longArray = ids = this.chunkRadiation.keySet().toArray(new Long[0]);
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long id = longArray[i];
            this.updateChunkRadiation(id);
        }
    }

    @Override
    public void updateChunkRadiation(int x, int z) {
        long id = WorldRadiation.pack(x, z);
        this.updateChunkRadiation(id);
    }

    @Override
    public void updateChunkRadiation(long id) {
        boolean toSpread;
        if (this.updatedChunks.containsKey(id) || !this.chunkRadiation.containsKey(id)) {
            return;
        }
        int x = WorldRadiation.unpackX(id);
        int z = WorldRadiation.unpackZ(id);
        if (!this.level.m_7726_().m_5563_(x, z)) {
            return;
        }
        int radiation = WorldRadiation.unpackX(this.chunkRadiation.get(id));
        int timestamp = WorldRadiation.unpackZ(this.chunkRadiation.get(id));
        int curTimestamp = (int)(this.getServerTime() / 20L);
        int radiationChange = (int)((double)(curTimestamp - timestamp) * this.decaySpeed);
        if ((radiation -= radiationChange) < 100) {
            this.chunkRadiation.remove(id);
            this.updatedChunks.put(id, WorldRadiation.pack(0, curTimestamp));
            return;
        }
        boolean bl = toSpread = (double)(radiation = Math.min(radiation, 5000000)) > this.spreadGate;
        if (toSpread) {
            radiation = (int)(0.99 * (double)radiation);
        }
        long radiationData = WorldRadiation.pack(radiation, curTimestamp);
        this.chunkRadiation.replace(id, radiationData);
        this.updatedChunks.put(id, radiationData);
        if (toSpread) {
            this.spreadAround(x, z, radiation);
        }
    }

    public int addRadiation(Level level, double radiation, int x, int z) {
        this.level = level;
        long id = WorldRadiation.pack(x, z);
        int curTimestamp = (int)(this.getServerTime() / 20L);
        int newRadiation = (int)(radiation * 1000000.0);
        if (!((Boolean)RadiationConfig.RADIATION_CONFIG.ENABLED.get()).booleanValue()) {
            return 0;
        }
        if (this.chunkRadiation.containsKey(id)) {
            int curRadiation = WorldRadiation.unpackX(this.chunkRadiation.get(id));
            if (curRadiation > newRadiation) {
                newRadiation /= 10;
            }
            newRadiation = curRadiation + newRadiation;
            this.chunkRadiation.replace(id, WorldRadiation.pack(newRadiation, curTimestamp));
        }
        if (this.newChunks.containsKey(id)) {
            this.newChunks.replace(id, WorldRadiation.pack(newRadiation, curTimestamp));
        } else {
            this.newChunks.put(id, WorldRadiation.pack(newRadiation, curTimestamp));
        }
        return newRadiation;
    }

    private long getServerTime() {
        return this.level.m_46467_();
    }

    private void spreadAround(int chunkX, int chunkZ, int radiation) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                long id = WorldRadiation.pack(chunkX + i, chunkZ + j);
                if (this.updatedChunks.containsKey(id)) continue;
                if (this.chunkRadiation.containsKey(id)) {
                    int curRadiation = WorldRadiation.unpackX(this.chunkRadiation.get(id));
                    int curTimestamp = WorldRadiation.unpackZ(this.chunkRadiation.get(id));
                    if ((double)curRadiation > (double)radiation * 0.5) continue;
                    int newRadiation = (int)(((double)curRadiation + (double)radiation * (Double)RadiationConfig.RADIATION_CONFIG.SPREAD_MULTIPLIER.get() / 5.0) / 2.0);
                    this.chunkRadiation.replace(id, WorldRadiation.pack(newRadiation, curTimestamp));
                } else {
                    int curTimestamp = (int)(this.getServerTime() / 20L);
                    this.chunkRadiation.put(id, WorldRadiation.pack((int)((double)radiation * (Double)RadiationConfig.RADIATION_CONFIG.SPREAD_MULTIPLIER.get()), curTimestamp));
                }
                if (this.updatedChunks.containsKey(id)) {
                    this.updatedChunks.replace(id, this.chunkRadiation.get(id));
                    continue;
                }
                this.updatedChunks.put(id, this.chunkRadiation.get(id));
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag radiationTag = new CompoundTag();
        for (long key : this.chunkRadiation.keySet()) {
            radiationTag.m_128356_(String.valueOf(key), this.chunkRadiation.get(key).longValue());
        }
        tag.m_128365_("radiation", (Tag)radiationTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag radiationTag = nbt.m_128469_("radiation");
        for (String key : radiationTag.m_128431_()) {
            this.chunkRadiation.put(Long.parseLong(key), radiationTag.m_128454_(key));
        }
    }

    public static long pack(int x, int z) {
        return ChunkPos.m_45589_((int)x, (int)z);
    }

    public static int unpackX(long packed) {
        return ChunkPos.m_45592_((long)packed);
    }

    public static int unpackZ(long packed) {
        return ChunkPos.m_45602_((long)packed);
    }

    public int naturalRadiation(int chunkX, int chunkZ) {
        int radiation = (Integer)RadiationConfig.RADIATION_CONFIG.NATURAL_RADIATION.get();
        if (this.level == null) {
            return radiation;
        }
        String biomeId = ((ResourceKey)this.level.m_204166_(new BlockPos(chunkX * 16, 0, chunkZ * 16)).m_203543_().get()).m_135782_().toString();
        radiation += RadiationConfig.RADIATION_CONFIG.biomeRadiation(biomeId);
        return radiation += RadiationConfig.RADIATION_CONFIG.dimensionRadiation(this.level.m_46472_().m_135782_().toString());
    }
}

