/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.radiation;

import igentuman.nc.content.fuel.FuelManager;
import igentuman.nc.content.materials.Materials;
import igentuman.nc.radiation.ItemRadiation;
import igentuman.nc.setup.registration.FissionFuel;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidRadiation {
    protected static HashMap<Fluid, Double> radiationMap = new HashMap();
    protected static boolean initialized = false;

    public static HashMap<Fluid, Double> get() {
        return radiationMap;
    }

    public static void init() {
        if (!radiationMap.isEmpty()) {
            return;
        }
        for (String name : Materials.isotopes()) {
            for (String type : List.of("", "_ox", "_ni", "_za", "_tr")) {
                FluidRadiation.add(name + type, (double)Materials.isotopes.get(name));
            }
        }
        for (String name : FuelManager.all().keySet()) {
            for (String subType : FuelManager.all().get(name).keySet()) {
                for (String type : List.of("", "ox", "ni", "za", "tr")) {
                    int isotope1Cnt = 1;
                    int isotope2Cnt = 8;
                    if (subType.substring(0, 1).equalsIgnoreCase("h")) {
                        isotope1Cnt = 3;
                        isotope2Cnt = 6;
                    }
                    Item isotope1 = FluidRadiation.getIsotope(name, String.valueOf(FuelManager.all().get((Object)name).get((Object)subType).getDefault().isotopes[0]), type);
                    Item isotope2 = FluidRadiation.getIsotope(name, String.valueOf(FuelManager.all().get((Object)name).get((Object)subType).getDefault().isotopes[1]), type);
                    double radiation = ItemRadiation.byItem(isotope1) * (double)isotope1Cnt + ItemRadiation.byItem(isotope2) * (double)isotope2Cnt;
                    String key = "fuel_" + name + "_" + subType + type;
                    FluidRadiation.add(key.replace("-", "_"), radiation / 2.0);
                }
            }
        }
    }

    public static Item getIsotope(String name, String id, String type) {
        if (!((String)type).isEmpty()) {
            type = "_" + (String)type;
        }
        if (!FissionFuel.NC_ISOTOPES.containsKey(name + "/" + id + (String)type)) {
            for (String isotope : FissionFuel.NC_ISOTOPES.keySet()) {
                if (!isotope.contains(id)) continue;
                return (Item)FissionFuel.NC_ISOTOPES.get(isotope).get();
            }
        }
        return (Item)FissionFuel.NC_ISOTOPES.get(name + "/" + id + (String)type).get();
    }

    public static void add(String item, double radiation) {
        Fluid toAdd = FluidRadiation.getFluidByName(item);
        if (toAdd.equals(FluidStack.EMPTY.getFluid())) {
            return;
        }
        radiationMap.put(toAdd, radiation);
    }

    public static void add(Fluid item, double radiation) {
        radiationMap.put(item, radiation);
    }

    protected static Fluid getFluidByName(String name) {
        if (!((String)name).contains(":")) {
            name = "nuclearcraft:" + (String)name;
        }
        ResourceLocation itemKey = new ResourceLocation(((String)name).replace("/", "_"));
        return (Fluid)ForgeRegistries.FLUIDS.getValue(itemKey);
    }

    public static double byFluid(Fluid item) {
        if (!initialized) {
            FluidRadiation.init();
            initialized = true;
        }
        if (radiationMap.containsKey(item)) {
            return radiationMap.get(item);
        }
        return 0.0;
    }
}

