/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import igentuman.nc.setup.registration.WorldGeneration;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class StructureCommand {
    public static void register(CommandDispatcher<CommandSourceStack> command) {
        command.register((LiteralArgumentBuilder)Commands.m_82127_((String)"nc_build").then(Commands.m_82129_((String)"structure", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            builder.suggest("fission_reactor");
            builder.suggest("fusion_reactor");
            return builder.buildFuture();
        }).executes(StructureCommand::executeCommand)));
    }

    private static int executeCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String structure;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        switch (structure = StringArgumentType.getString(context, (String)"structure")) {
            case "fission_reactor": {
                StructureCommand.placeFissionReactor(player);
                break;
            }
            case "fusion_reactor": {
                StructureCommand.placeFusionReactor(player);
                break;
            }
            default: {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid structure: " + structure)));
                return 0;
            }
        }
        return 1;
    }

    private static void placeFissionReactor(ServerPlayer player) {
        double rayTraceRange = 30.0;
        HitResult hitResult = player.m_19907_(rayTraceRange, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.m_82425_().m_7918_(-3, 1, -3);
            WorldGeneration.StructurePlacer.placeStructure((ServerLevel)player.m_9236_(), blockPos, "fission_reactor");
            player.m_213846_((Component)Component.m_237113_((String)"Placing fission reactor!"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"No block targeted!"));
        }
    }

    private static void placeFusionReactor(ServerPlayer player) {
        double rayTraceRange = 30.0;
        HitResult hitResult = player.m_19907_(rayTraceRange, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.m_82425_().m_7918_(-5, 3, -5);
            WorldGeneration.StructurePlacer.placeStructure((ServerLevel)player.m_9236_(), blockPos, "fusion_reactor");
            player.m_213846_((Component)Component.m_237113_((String)"Placing fusion reactor!"));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"No block targeted!"));
        }
    }
}

