/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.energy;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.energy.NCEnergy;
import igentuman.nc.block.entity.energy.RTGBE;
import igentuman.nc.handler.config.CommonConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class RTGs {
    private static HashMap<String, RTGPrefab> all = new HashMap();
    private static HashMap<String, RTGPrefab> registered = new HashMap();

    public static HashMap<String, RTGPrefab> all() {
        if (all.isEmpty()) {
            all.put("uranium_rtg", new RTGPrefab("uranium_rtg", 100, 560).setBlockEntity((BlockEntityType.BlockEntitySupplier<? extends NCEnergy>)((BlockEntityType.BlockEntitySupplier)RTGBE::new)));
            all.put("americium_rtg", new RTGPrefab("americium_rtg", 400, 57800).setBlockEntity((BlockEntityType.BlockEntitySupplier<? extends NCEnergy>)((BlockEntityType.BlockEntitySupplier)RTGBE::new)));
            all.put("plutonium_rtg", new RTGPrefab("plutonium_rtg", 1200, 200000).setBlockEntity((BlockEntityType.BlockEntitySupplier<? extends NCEnergy>)((BlockEntityType.BlockEntitySupplier)RTGBE::new)));
            all.put("californium_rtg", new RTGPrefab("californium_rtg", 4000, 1900000).setBlockEntity((BlockEntityType.BlockEntitySupplier<? extends NCEnergy>)((BlockEntityType.BlockEntitySupplier)RTGBE::new)));
        }
        return all;
    }

    public static HashMap<String, RTGPrefab> registered() {
        if (registered.isEmpty()) {
            for (String name : RTGs.all().keySet()) {
                if (!RTGs.all().get(name).config().isRegistered()) continue;
                registered.put(name, RTGs.all().get(name));
            }
        }
        return registered;
    }

    public static List<Boolean> initialRegistered() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (String name : RTGs.all().keySet()) {
            tmp.add(true);
        }
        return tmp;
    }

    public static List<Integer> initialPower() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (String name : RTGs.all().keySet()) {
            tmp.add(RTGs.all().get(name).getGeneration());
        }
        return tmp;
    }

    public static List<Integer> initialRadiation() {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (String name : RTGs.all().keySet()) {
            tmp.add(RTGs.all().get(name).getRadiation());
        }
        return tmp;
    }

    public static class RTGPrefab {
        private boolean registered = true;
        private boolean initialized = false;
        private final String name;
        protected int generation = 0;
        protected int radiation = 0;
        private BlockEntityType.BlockEntitySupplier<? extends NCEnergy> blockEntity;

        public RTGPrefab(String name, int generation, int radiation) {
            this.generation = generation;
            this.radiation = radiation;
            this.name = name;
        }

        public int getGeneration() {
            return this.generation;
        }

        public RTGPrefab setGeneration(int generation) {
            this.generation = generation;
            return this;
        }

        public RTGPrefab config() {
            if (!this.initialized) {
                try {
                    int id = RTGs.all().keySet().stream().toList().indexOf(this.name);
                    this.registered = (Boolean)((List)CommonConfig.ENERGY_GENERATION.REGISTER_RTG.get()).get(id);
                    this.generation = (Integer)((List)CommonConfig.ENERGY_GENERATION.RTG_GENERATION.get()).get(id);
                    this.radiation = (Integer)((List)CommonConfig.ENERGY_GENERATION.RTG_RADIATION.get()).get(id);
                    this.initialized = true;
                }
                catch (Exception e) {
                    NuclearCraft.LOGGER.error("Error while loading config for " + this.name + "!");
                }
            }
            return this;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public BlockEntityType.BlockEntitySupplier<? extends NCEnergy> getBlockEntity() {
            return this.blockEntity;
        }

        public RTGPrefab setBlockEntity(BlockEntityType.BlockEntitySupplier<? extends NCEnergy> blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        public int getRadiation() {
            return this.radiation;
        }

        public int getActualGeneration() {
            return (int)((double)this.config().generation * (Double)CommonConfig.ENERGY_GENERATION.GENERATION_MULTIPLIER.get());
        }
    }
}

