/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.oc2;

import igentuman.nc.block.entity.fission.FissionControllerBE;
import java.util.Collection;
import java.util.Collections;
import li.cil.oc2r.api.bus.device.Device;
import li.cil.oc2r.api.bus.device.object.Callback;
import li.cil.oc2r.api.bus.device.object.NamedDevice;
import li.cil.oc2r.api.bus.device.object.ObjectDevice;
import li.cil.oc2r.api.bus.device.rpc.RPCDevice;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.NotNull;

public class NCFissionReactorDevice {
    public static final Capability<Device> DEVICE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Device>(){});

    public static RPCDevice createDevice(FissionControllerBE<?> blockEntity) {
        return new ObjectDevice((Object)new NCFissionReactorDeviceRecord(blockEntity));
    }

    public record NCFissionReactorDeviceRecord(FissionControllerBE<?> reactor) implements NamedDevice
    {
        @Callback
        public final String getName() {
            return this.reactor.getName();
        }

        @Callback
        public final boolean hasRecipe() {
            return this.reactor.hasRecipe();
        }

        @Callback
        public final boolean isSteamMode() {
            return this.reactor.isSteamMode;
        }

        @Callback
        public final double getSteamRate() {
            return this.reactor.getSteamRate();
        }

        @Callback
        public final int getDepletionProgress() {
            return (int)(this.reactor.getDepletionProgress() * 100.0);
        }

        @Callback
        public final double getMaxHeatCapacity() {
            return this.reactor.getMaxHeat();
        }

        @Callback
        public final void enableReactor() {
            this.reactor.disableForceShutdown();
        }

        @Callback
        public final void disableReactor() {
            this.reactor.forceShutdown();
        }

        @Callback
        public final int getEnergyPerTick() {
            return this.reactor.energyPerTick;
        }

        @Callback
        public final void setModerationLevel(int level) {
            this.reactor.adjustModerationLevel(level);
        }

        @Callback
        public final int getEnergyStored() {
            return this.reactor.energyStorage.getEnergyStored();
        }

        @Callback
        public final double getHeatMultiplier() {
            return this.reactor.heatMultiplier;
        }

        @Callback
        public final int getModeratorsCount() {
            return this.reactor.moderatorsCount;
        }

        @Callback
        public final int getHeatSinksCount() {
            return this.reactor.heatSinksCount;
        }

        @Callback
        public final int getFuelCellsCount() {
            return this.reactor.fuelCellsCount;
        }

        @Callback
        public final int getCooling() {
            return (int)this.reactor.coolingPerTick();
        }

        @Callback
        public final int getHeat() {
            return (int)this.reactor.heatPerTick();
        }

        @Callback
        public final int getHeatStored() {
            return (int)this.reactor.heat;
        }

        @Callback
        public final void voidFuel() {
            this.reactor.voidFuel();
        }

        @Callback
        public final Object[] getFuelInSlot() {
            return this.reactor.getFuel();
        }

        @NotNull
        public Collection<String> getDeviceTypeNames() {
            return Collections.singletonList(this.getName());
        }
    }
}

