/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.cc;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import igentuman.nc.block.entity.fusion.FusionCoreBE;
import javax.annotation.Nonnull;

public class NCFusionReactorPeripheral
implements IPeripheral {
    private final FusionCoreBE<?> reactor;

    public NCFusionReactorPeripheral(FusionCoreBE<?> processorBE) {
        this.reactor = processorBE;
    }

    @Nonnull
    public String getType() {
        return "nc_fusion_reactor_core";
    }

    public boolean equals(IPeripheral other) {
        return this == other || other instanceof NCFusionReactorPeripheral && ((NCFusionReactorPeripheral)other).reactor == this.reactor;
    }

    @LuaFunction
    public final String getName() {
        return this.reactor.getName();
    }

    @LuaFunction
    public final boolean hasRecipe() {
        return this.reactor.hasRecipe();
    }

    @LuaFunction
    public final double getMaxHeatCapacity() {
        return this.reactor.getMaxHeat();
    }

    @LuaFunction
    public final void enableReactor() {
        this.reactor.disableForceShutdown();
    }

    @LuaFunction
    public final void disableReactor() {
        this.reactor.forceShutdown();
    }

    @LuaFunction
    public final int getEnergyPerTick() {
        return this.reactor.energyPerTick;
    }

    @LuaFunction
    public final int setRFAmplification(int amplification) {
        this.reactor.rfAmplificationRatio = Math.min(100, Math.max(amplification, 1));
        return this.reactor.rfAmplificationRatio;
    }

    @LuaFunction
    public final int getEnergyStored() {
        return this.reactor.energyStorage.getEnergyStored();
    }

    @LuaFunction
    public final double getPlasmaStability() {
        return this.reactor.getControlPartsEfficiency();
    }

    @LuaFunction
    public final int getHeatStored() {
        return (int)this.reactor.reactorHeat;
    }

    @LuaFunction
    public final void voidFuel() {
        this.reactor.voidFuel();
    }
}

