/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.kugelblitz;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.client.gui.IProgressScreen;
import igentuman.nc.client.gui.IVerticalBarScreen;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.element.bar.ProgressBar;
import igentuman.nc.client.gui.element.bar.VerticalBar;
import igentuman.nc.client.gui.element.button.Button;
import igentuman.nc.client.gui.element.button.Checkbox;
import igentuman.nc.client.gui.element.fluid.FluidTankRenderer;
import igentuman.nc.container.ChamberTerminalContainer;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ChamberTerminalScreen
extends AbstractContainerScreen<ChamberTerminalContainer>
implements IProgressScreen,
IVerticalBarScreen {
    protected final ResourceLocation GUI = new ResourceLocation("nuclearcraft", "textures/gui/kugelblitz/controller.png");
    protected int relX;
    protected int relY;
    private int xCenter;
    private FluidTankRenderer coolantTank;
    private FluidTankRenderer steamTank;
    public List<NCGuiElement> widgets = new ArrayList<NCGuiElement>();
    public Checkbox checkboxCasing;
    public Checkbox checkboxInterior;
    private VerticalBar energyBar;
    private Button.ReactorMode modeBtn;
    public Component casingTootip = Component.m_237119_();
    public Component interiorTootip = Component.m_237119_();

    public ChamberTerminalContainer container() {
        return (ChamberTerminalContainer)this.f_97732_;
    }

    public ChamberTerminalScreen(ChamberTerminalContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 176;
        this.f_97727_ = 176;
    }

    protected void updateRelativeCords() {
        this.relX = (this.f_96543_ - this.f_97726_) / 2;
        this.relY = (this.f_96544_ - this.f_97727_) / 2;
        NCGuiElement.RELATIVE_X = this.relX;
        NCGuiElement.RELATIVE_Y = this.relY;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_6375_(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_7856_() {
        super.m_7856_();
        Minecraft mc = Minecraft.m_91087_();
        this.updateRelativeCords();
        this.widgets.clear();
        this.checkboxCasing = new Checkbox(this.f_97726_ - 19, 80, this, this.isCasingValid());
        this.checkboxInterior = new Checkbox(this.f_97726_ - 32, 80, this, this.isInteriorValid());
        this.energyBar = new VerticalBar.Energy(17, 16, (IVerticalBarScreen)this, this.container().getMaxEnergy());
        this.widgets.add(new ProgressBar(74, 35, this, 7));
        this.modeBtn = new Button.ReactorMode(150, 54, this, ((ChamberTerminalContainer)this.f_97732_).getPosition());
        this.widgets.add(this.modeBtn);
    }

    protected FluidTank getFluidTank(int i) {
        return ((ChamberTerminalContainer)this.f_97732_).getFluidTank(i);
    }

    private boolean isInteriorValid() {
        return this.container().isInteriorValid();
    }

    private boolean isCasingValid() {
        return this.container().isCasingValid();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.xCenter = this.getGuiLeft() - this.f_97726_ / 2;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    private void renderWidgets(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        for (NCGuiElement widget : this.widgets) {
            widget.draw(graphics, mouseX, mouseY, partialTicks);
        }
        this.checkboxCasing.setChecked(this.isCasingValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isCasingValid()) {
            this.checkboxCasing.setTooltipKey("multiblock.casing.complete");
        } else {
            this.checkboxCasing.setTooltipKey("multiblock.casing.incomplete");
        }
        this.checkboxCasing.addTooltip(this.casingTootip);
        this.checkboxInterior.setChecked(this.isInteriorValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isInteriorValid()) {
            this.checkboxInterior.setTooltipKey("multiblock.interior.complete");
        } else {
            this.checkboxInterior.setTooltipKey("multiblock.interior.incomplete");
        }
        this.checkboxInterior.addTooltip(this.interiorTootip);
        if (this.isInteriorValid()) {
            // empty if block
        }
        this.energyBar.draw(graphics, mouseX, mouseY, partialTicks);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280653_(this.f_96547_, ((ChamberTerminalContainer)this.f_97732_).getTitle(), this.f_97726_ / 2, this.f_97729_, 0xFFFFFF);
        this.casingTootip = this.isCasingValid() ? TextUtils.applyFormat((Component)Component.m_237110_((String)"reactor.size", (Object[])new Object[]{this.getMultiblockHeight(), this.getMultiblockWidth(), this.getMultiblockDepth()}), ChatFormatting.GOLD) : TextUtils.applyFormat((Component)Component.m_237110_((String)this.getValidationResultKey(), (Object[])new Object[]{this.getValidationResultData()}), ChatFormatting.RED);
        if (this.isCasingValid()) {
            if (this.isInteriorValid()) {
                if (this.container().hasRecipe() && !this.container().getEfficiency().equals("NaN")) {
                    graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"fission_reactor.efficiency", (Object[])new Object[]{this.container().getEfficiency()}), 35, 82, 0x8AFF8A);
                }
            } else {
                this.interiorTootip = TextUtils.applyFormat((Component)Component.m_237110_((String)this.getValidationResultKey(), (Object[])new Object[]{this.getValidationResultData()}), ChatFormatting.RED);
            }
        }
        this.renderTooltips(graphics, mouseX - this.relX, mouseY - this.relY);
    }

    private Object getValidationResultData() {
        return this.container().getValidationResultData().m_123344_();
    }

    private String getValidationResultKey() {
        return this.container().getValidationResultKey();
    }

    private int getMultiblockHeight() {
        return this.container().getHeight();
    }

    private int getMultiblockWidth() {
        return this.container().getWidth();
    }

    private int getMultiblockDepth() {
        return this.container().getDepth();
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        this.updateRelativeCords();
        graphics.m_280218_(this.GUI, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        this.renderWidgets(graphics, partialTicks, mouseX, mouseY);
    }

    private void renderTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_5953_(pMouseX, pMouseY)) continue;
            graphics.m_280677_(this.f_96547_, widget.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxCasing.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxCasing.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxInterior.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxInterior.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        this.energyBar.clearTooltips();
        this.energyBar.addTooltip((Component)Component.m_237110_((String)"reactor.forge_energy_per_tick", (Object[])new Object[]{this.container().energyPerTick()}));
        if (this.energyBar.m_5953_(pMouseX, pMouseY + 10)) {
            graphics.m_280677_(this.f_96547_, this.energyBar.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
    }

    @Override
    public double getProgress() {
        return 0.0;
    }

    @Override
    public double getEnergy() {
        return this.container().getEnergy();
    }

    @Override
    public double getHeat() {
        return 0.0;
    }

    @Override
    public double getCoolant() {
        return 0.0;
    }

    @Override
    public double getHotCoolant() {
        return 0.0;
    }
}

