/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.fusion;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.fusion.FusionBE;
import igentuman.nc.block.entity.fusion.FusionCoreProxyBE;
import igentuman.nc.block.fission.FissionControllerBlock;
import igentuman.nc.block.fusion.FusionCoreBlock;
import igentuman.nc.client.particle.FusionBeamParticleData;
import igentuman.nc.client.sound.SoundHandler;
import igentuman.nc.compat.cc.NCFusionReactorPeripheral;
import igentuman.nc.compat.oc2.NCFusionReactorDevice;
import igentuman.nc.handler.config.FusionConfig;
import igentuman.nc.handler.event.client.BlockOverlayHandler;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.NcFluidTank;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.fusion.FusionReactor;
import igentuman.nc.multiblock.fusion.FusionReactorMultiblock;
import igentuman.nc.radiation.data.RadiationManager;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.RecipeInfo;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.util.CustomEnergyStorage;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.NCBlockPos;
import igentuman.nc.util.annotation.NBTField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FusionCoreBE<RECIPE extends Recipe>
extends FusionBE {
    @NBTField
    public byte analogSignal = 0;
    @NBTField
    public byte redstoneMode = (byte)12;
    @NBTField
    public double reactorHeat = 0.0;
    @NBTField
    public boolean isCasingValid = false;
    @NBTField
    public int size = 0;
    @NBTField
    public int energyPerTick = 0;
    @NBTField
    public double efficiency = 0.0;
    @NBTField
    public boolean powered = false;
    @NBTField
    public int inputRedstoneSignal = 0;
    @NBTField
    public int currentRfAmplification = 0;
    @NBTField
    protected boolean forceShutdown = false;
    @NBTField
    public double magneticFieldStrength = 0.0;
    @NBTField
    public int magnetsPower = 0;
    @NBTField
    public int maxMagnetsTemp = 0;
    @NBTField
    public int rfAmplification = 0;
    @NBTField
    public int rfAmplifiersPower = 0;
    @NBTField
    public int minRFAmplifiersTemp = 0;
    @NBTField
    public int rfAmplificationRatio = 0;
    @NBTField
    public int amplificationAdjustment = 50;
    @NBTField
    public int functionalBlocksCharge = 0;
    @NBTField
    public long plasmaTemperature = 0L;
    public long chargeAmount = 0L;
    @NBTField
    protected int rfEfficiency = 0;
    @NBTField
    protected int magnetsEfficiency = 0;
    @NBTField
    protected double lastKnownOptimalTemp = 1000000.0;
    @NBTField
    protected boolean isInternalValid = false;
    protected int updateSpan = 20;
    protected List<FusionCoolantRecipe> coolantRecipes;
    public final SidedContentHandler contentHandler;
    public final CustomEnergyStorage energyStorage = this.createEnergy();
    protected final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    public BlockPos errorBlockPos = BlockPos.f_121853_;
    public ValidationResult validationResult = ValidationResult.INCOMPLETE;
    public RecipeInfo<RECIPE> recipeInfo = new RecipeInfo();
    public boolean controllerEnabled = false;
    public RECIPE recipe;
    public HashMap<String, RECIPE> cachedRecipes = new HashMap();
    protected boolean initialized = false;
    protected int reValidateCounter = 40;
    protected boolean refreshCacheFlag;
    protected List<FluidStack> allowedInputs;
    protected FusionCoreProxyBE[] proxyBES;
    protected LazyOptional<NCFusionReactorPeripheral> peripheralCap;
    protected double lastHeadDeviationMult = 1.0;
    protected double radiationAggregated = 0.0;
    protected long prevAmplification = 0L;
    protected FusionCoolantRecipe coolantRecipe;

    public void toggleRedstoneMode() {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode > 13) {
            this.redstoneMode = (byte)11;
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public List<FusionCoolantRecipe> getCoolantRecipes() {
        if (this.coolantRecipes == null) {
            this.coolantRecipes = NcRecipeType.ALL_RECIPES.get("fusion_coolant").getRecipeType().getRecipes(this.m_58904_());
        }
        return this.coolantRecipes;
    }

    public FluidTank getFluidTank(int i) {
        return (FluidTank)this.contentHandler.fluidCapability.tanks.get(i);
    }

    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(2048000000, 100000000, 100000000){

            @Override
            protected void onEnergyChanged() {
                FusionCoreBE.this.m_6596_();
            }
        };
    }

    public FusionCoreBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, FusionCoreBE.getName(pBlockState));
        this.multiblock = new FusionReactorMultiblock(this);
        this.contentHandler = new SidedContentHandler(0, 0, 3, 5, 10, 50);
        this.contentHandler.setBlockEntity(this);
        this.contentHandler.fluidCapability.setGlobalMode(0, SlotModePair.SlotMode.INPUT);
        this.contentHandler.fluidCapability.setGlobalMode(1, SlotModePair.SlotMode.INPUT);
        this.contentHandler.fluidCapability.setGlobalMode(2, SlotModePair.SlotMode.INPUT);
        this.contentHandler.fluidCapability.setGlobalMode(3, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler.fluidCapability.setGlobalMode(4, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler.fluidCapability.setGlobalMode(5, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler.fluidCapability.setGlobalMode(6, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler.fluidCapability.setGlobalMode(7, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler.setAllowedInputFluids(0, this::getAllowedInputFluids);
        this.contentHandler.setAllowedInputFluids(1, this::getAllowedInputFluids);
        this.contentHandler.setAllowedInputFluids(2, this::getAllowedCoolants);
        this.contentHandler.setAllowedInputFluids(7, this::getAllowedCoolantsOutput);
        ((NcFluidTank)((Object)this.contentHandler.fluidCapability.tanks.get(2))).setCapacity(100000);
        ((NcFluidTank)((Object)this.contentHandler.fluidCapability.tanks.get(7))).setCapacity(100000);
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new NCFusionReactorPeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.contentHandler.getFluidCapability(side);
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        if (ModUtil.isMekanismLoadeed()) {
            if (cap == Capabilities.GAS_HANDLER) {
                if (this.contentHandler.hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.contentHandler.gasConverter(side));
                }
                return LazyOptional.empty();
            }
            if (cap == Capabilities.SLURRY_HANDLER) {
                if (this.contentHandler.hasFluidCapability(side)) {
                    return LazyOptional.of(() -> this.contentHandler.getSlurryConverter(side));
                }
                return LazyOptional.empty();
            }
        }
        if (ModUtil.isOC2Loaded() && cap == NCFusionReactorDevice.DEVICE_CAPABILITY) {
            return this.getOCDevice(cap, side);
        }
        if (ModUtil.isCcLoaded() && cap == dan200.computercraft.shared.Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public <T> LazyOptional<T> getOCDevice(Capability<T> cap, Direction side) {
        return LazyOptional.of(() -> NCFusionReactorDevice.createDevice(this)).cast();
    }

    public void updateAnalogSignal() {
        switch (this.redstoneMode) {
            case 11: {
                this.analogSignal = (byte)((double)this.energyStorage.getEnergyStored() * 15.0 / (double)this.energyStorage.getMaxEnergyStored());
                break;
            }
            case 12: {
                this.analogSignal = (byte)(this.reactorHeat * 15.0 / this.getMaxHeat());
                break;
            }
            case 13: {
                this.analogSignal = (byte)(this.efficiency * 15.0);
            }
        }
    }

    public void onLoad() {
        this.initialized = false;
    }

    public double getMaxHeat() {
        return Math.max(this.minRFAmplifiersTemp * 2, this.maxMagnetsTemp * 2);
    }

    public void handleValidation() {
        boolean wasFormed = this.multiblock().isFormed();
        boolean wasPowered = this.powered;
        this.isCasingValid = this.multiblock().isOuterValid();
        this.isInternalValid = this.multiblock().isInnerValid();
        if (!wasFormed) {
            ++this.reValidateCounter;
            if (this.reValidateCounter < 40) {
                return;
            }
            this.reValidateCounter = 0;
            this.multiblock().validate();
            this.powered = false;
        }
        this.changed = wasPowered != this.powered || wasFormed != this.multiblock().isFormed();
        this.trackChanges(this.updateCharacteristics());
        this.size = this.multiblock().isFormed() ? this.multiblock.width() : 0;
        boolean bl = this.refreshCacheFlag = !this.multiblock().isFormed();
        if (this.multiblock().isFormed() != wasFormed) {
            ((NcFluidTank)((Object)this.contentHandler.fluidCapability.tanks.get(2))).setCapacity(50000 * this.size);
            ((NcFluidTank)((Object)this.contentHandler.fluidCapability.tanks.get(7))).setCapacity(50000 * this.size);
        }
    }

    protected void periodicalUpdate() {
        --this.updateSpan;
        if (this.updateSpan < 0) {
            this.updateSpan = 20;
            this.changed = true;
            this.m_6596_();
        }
    }

    @Override
    public void tickClient() {
        BlockOverlayHandler.removeFusionReactor(this.m_58899_());
        if (!this.isCasingValid) {
            this.stopSound();
            return;
        }
        if (this.playSoundCooldown > 0) {
            --this.playSoundCooldown;
            return;
        }
        if (this.functionalBlocksCharge < 100 && this.functionalBlocksCharge > 0) {
            this.playChargingSound();
            return;
        }
        if (this.isReady()) {
            if (this.energyPerTick > 0 && this.plasmaTemperature > 0L) {
                this.playRunningSound();
                return;
            }
            this.playReadySound();
        } else {
            this.stopSound();
        }
    }

    protected void sendBeamData(FusionBeamParticleData data, BlockPos from) {
        Object object;
        Vec3 vec = Vec3.m_82512_((Vec3i)from);
        if (!this.m_58904_().m_5776_() && (object = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)object;
            for (ServerPlayer player : serverWorld.m_6907_()) {
                serverWorld.m_8624_(player, (ParticleOptions)data, true, vec.f_82479_, vec.f_82480_, vec.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void renderBeam() {
        NCBlockPos pos = new NCBlockPos((Vec3i)this.m_58899_().m_7494_());
        int beamLength = this.size * 2 + 4;
        this.sendBeamData(new FusionBeamParticleData(Direction.EAST, beamLength, 0.35f), pos.revert().relative(Direction.NORTH, this.size + 2).relative(Direction.WEST, this.size + 2));
        this.sendBeamData(new FusionBeamParticleData(Direction.EAST, beamLength, 0.35f), pos.revert().relative(Direction.SOUTH, this.size + 2).relative(Direction.WEST, this.size + 2));
        this.sendBeamData(new FusionBeamParticleData(Direction.SOUTH, beamLength, 0.35f), pos.revert().relative(Direction.EAST, this.size + 2).relative(Direction.NORTH, this.size + 2));
        this.sendBeamData(new FusionBeamParticleData(Direction.SOUTH, beamLength, 0.35f), pos.revert().relative(Direction.WEST, this.size + 2).relative(Direction.NORTH, this.size + 2));
    }

    protected void playReadySound() {
        if (this.m_58901_() || this.currentSound != null && !this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FUSION_READY.get()).m_11660_())) {
            SoundHandler.stopTileSound(this.m_58899_());
            this.currentSound = null;
        }
        if (this.currentSound == null || !Minecraft.m_91087_().m_91106_().m_120403_(this.currentSound)) {
            if (this.currentSound != null && this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FUSION_READY.get()).m_11660_())) {
                return;
            }
            this.playSoundCooldown = 20;
            this.currentSound = SoundHandler.startTileSound((SoundEvent)NCSounds.FUSION_READY.get(), SoundSource.BLOCKS, 0.8f, this.f_58857_.m_213780_(), this.m_58899_());
        }
    }

    protected boolean isReady() {
        return this.isCasingValid && this.rfAmplifiersPower > 0 && this.magnetsPower > 0 && this.hasCoolant() && this.hasRecipe() && this.functionalBlocksCharge > 99;
    }

    protected void playRunningSound() {
        if (this.m_58901_() || this.currentSound != null && !this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FUSION_RUNNING.get()).m_11660_())) {
            SoundHandler.stopTileSound(this.m_58899_());
            this.currentSound = null;
        }
        if (this.currentSound == null || !Minecraft.m_91087_().m_91106_().m_120403_(this.currentSound)) {
            if (this.currentSound != null && this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FUSION_RUNNING.get()).m_11660_())) {
                return;
            }
            this.playSoundCooldown = 20;
            this.currentSound = SoundHandler.startTileSound((SoundEvent)NCSounds.FUSION_RUNNING.get(), SoundSource.BLOCKS, 0.5f, this.f_58857_.m_213780_(), this.m_58899_());
        }
    }

    @Override
    public void tickServer() {
        this.tickProxyBlocks();
        this.changed = false;
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        if (!this.initialized) {
            this.initialized = true;
            FusionCoreBlock block = (FusionCoreBlock)this.m_58900_().m_60734_();
            block.placeProxyBlocks(this.m_58900_(), this.f_58857_, this.f_58858_, this);
        }
        super.tickServer();
        this.handleValidation();
        this.periodicalUpdate();
        this.simulateReaction();
        this.sendOutPower();
        this.handleMeltdown();
        if (this.refreshCacheFlag || this.changed) {
            if (this.f_58857_.m_46467_() % 10L == 0L) {
                this.updateAnalogSignal();
            }
            try {
                assert (this.f_58857_ != null);
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)), 3);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.controllerEnabled = false;
        this.inputRedstoneSignal = 0;
    }

    private void tickProxyBlocks() {
        for (FusionCoreProxyBE proxy : this.getProxies()) {
            if (proxy == null) continue;
            proxy.forceTickServer(this);
        }
    }

    protected List<FluidStack> getAllowedCoolantsOutput() {
        ArrayList<FluidStack> allowedCoolants = new ArrayList<FluidStack>();
        for (FusionCoolantRecipe recipe : this.getCoolantRecipes()) {
            allowedCoolants.addAll(recipe.getOutputFluids(0));
        }
        return allowedCoolants;
    }

    public double getHeatDeviationMultiplier() {
        double mEff = (this.magnetsEfficiency() - 50.0) / 100.0;
        double rEff = (this.rfEfficiency() - 50.0) / 100.0;
        double plasmaStability = (1.0 + this.getControlPartsEfficiency()) / 2.0;
        double minMult = 0.2 * plasmaStability + (mEff + rEff) / 2.0;
        double maxMult = 1.7 * this.getControlPartsEfficiency() - (mEff + rEff) / 2.0;
        double rand = (new Random().nextDouble() + 4.0) / 5.0;
        this.lastHeadDeviationMult = (this.lastHeadDeviationMult + rand * (maxMult - minMult) + minMult) / 2.0;
        return this.lastHeadDeviationMult;
    }

    protected double rfEfficiency() {
        return (double)this.rfEfficiency * Math.min((double)this.minRFAmplifiersTemp / ((this.reactorHeat + (double)this.minRFAmplifiersTemp) / 2.0), 1.0);
    }

    protected double magnetsEfficiency() {
        return (double)this.magnetsEfficiency * Math.min((double)this.maxMagnetsTemp / ((this.reactorHeat + (double)this.maxMagnetsTemp) / 2.0), 1.0);
    }

    public double getOptimalTemperature() {
        if (this.hasRecipe() && ((Recipe)this.recipeInfo.recipe()).getOptimalTemperature() > 0.0) {
            this.lastKnownOptimalTemp = ((Recipe)this.recipeInfo.recipe()).getOptimalTemperature() * 1000000.0;
        }
        return this.lastKnownOptimalTemp;
    }

    public double minimalMagneticField() {
        return (Double)FusionConfig.FUSION_CONFIG.MINIMAL_MAGNETIC_FIELD.get() * ((double)this.plasmaTemperature / this.getOptimalTemperature()) * (double)this.size;
    }

    public double overallMagneticField() {
        return this.magneticFieldStrength / (double)this.size;
    }

    public double getControlPartsEfficiency() {
        return Math.min(1.9, Math.max(0.1, 2.0 / (this.magnetsEfficiency() / 100.0 * (this.minimalMagneticField() / this.overallMagneticField()))));
    }

    public double getPlasmaStability() {
        return (this.getControlPartsEfficiency() / 1.9 + this.calculateEfficiency() * 2.0) / 3.0;
    }

    protected List<FluidStack> getAllowedCoolants() {
        ArrayList<FluidStack> allowedCoolants = new ArrayList<FluidStack>();
        for (FusionCoolantRecipe recipe : this.getCoolantRecipes()) {
            allowedCoolants.addAll(recipe.getInputFluids(0));
        }
        return allowedCoolants;
    }

    protected void sendOutPower() {
        for (FusionCoreProxyBE proxy : this.getProxies()) {
            if (proxy == null) continue;
            proxy.sendOutEnergy();
        }
        BlockEntity be = Objects.requireNonNull(this.m_58904_()).m_7702_(this.m_58899_().m_121945_(Direction.DOWN));
        if (be instanceof BlockEntity && !(be instanceof FusionBE)) {
            IEnergyStorage r = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, Direction.UP).orElse(null);
            if (r == null) {
                return;
            }
            if (r.canReceive()) {
                int recieved = r.receiveEnergy(this.energyStorage.getEnergyStored() - this.rfAmplifiersPower - this.magnetsPower, false);
                this.energyStorage.setEnergy(this.energyStorage.getEnergyStored() - recieved);
            }
        }
    }

    protected FusionCoreProxyBE[] getProxies() {
        if (this.proxyBES == null) {
            this.proxyBES = new FusionCoreProxyBE[18];
            int i = 0;
            for (int y = 0; y < 3; y += 2) {
                for (int x = -1; x < 2; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        BlockEntity be = Objects.requireNonNull(this.m_58904_()).m_7702_(this.m_58899_().m_7918_(x, y, z));
                        if (!(be instanceof FusionCoreProxyBE)) continue;
                        this.proxyBES[i] = (FusionCoreProxyBE)be;
                        ++i;
                    }
                }
            }
        }
        return this.proxyBES;
    }

    public List<FluidStack> getAllowedInputFluids() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<FluidStack>();
            for (NcRecipe ncRecipe : NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_())) {
                for (FluidStackIngredient ingredient : ncRecipe.getInputFluids()) {
                    this.allowedInputs.addAll(ingredient.getRepresentations());
                }
            }
        }
        return this.allowedInputs;
    }

    protected void simulateReaction() {
        if (!this.multiblock().isFormed()) {
            return;
        }
        this.controllerEnabled = (this.hasRedstoneSignal() || this.controllerEnabled) && this.multiblock().isReadyToProcess();
        this.controllerEnabled = !this.forceShutdown && this.controllerEnabled;
        this.updateCharge();
        boolean bl = this.controllerEnabled = this.functionalBlocksCharge == 100 && this.controllerEnabled;
        if (this.controllerEnabled) {
            this.powered = this.processReaction();
            this.trackChanges(this.powered);
        } else {
            this.powered = false;
            if (this.plasmaTemperature > 0L) {
                this.plasmaTemperature = (long)Math.max(0.0f, (float)this.plasmaTemperature / 1.2f - 10000.0f);
                this.changed = true;
            }
        }
        if (!this.hasRecipe()) {
            this.updateRecipe();
            this.trackChanges(this.hasRecipe());
        }
        this.trackChanges(this.coolDown());
    }

    public long getTargetCharge() {
        return (long)(this.rfAmplifiersPower + this.magnetsPower) * 7L;
    }

    protected void updateCharge() {
        if (this.getTargetCharge() == 0L) {
            return;
        }
        if (this.chargeAmount < this.getTargetCharge()) {
            this.chargeAmount += (long)this.energyStorage.extractEnergy((this.rfAmplifiersPower + this.magnetsPower) / 2, false);
            this.changed = true;
        }
        this.functionalBlocksCharge = (int)Math.min(this.chargeAmount * 100L / this.getTargetCharge(), 100L);
    }

    protected void playChargingSound() {
        if (this.m_58901_() || this.currentSound != null && !this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FUSION_CHARGING.get()).m_11660_())) {
            SoundHandler.stopTileSound(this.m_58899_());
            this.currentSound = null;
        }
        if (this.currentSound == null || !Minecraft.m_91087_().m_91106_().m_120403_(this.currentSound)) {
            if (this.currentSound != null && this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.FUSION_CHARGING.get()).m_11660_())) {
                return;
            }
            this.playSoundCooldown = 20;
            this.currentSound = SoundHandler.startTileSound((SoundEvent)NCSounds.FUSION_CHARGING.get(), SoundSource.BLOCKS, 0.5f, this.f_58857_.m_213780_(), this.m_58899_());
        }
    }

    protected boolean updateCharacteristics() {
        boolean hasChanges = this.magneticFieldStrength != this.multiblock().magneticFieldStrength || this.rfEfficiency != this.multiblock().rfEfficiency || this.magnetsEfficiency != this.multiblock().magnetsEfficiency || this.maxMagnetsTemp != this.multiblock().maxMagnetsTemp || (double)this.rfAmplification != (double)this.multiblock().rfAmplification * this.rfAmplifierRatio() || (double)this.rfAmplifiersPower != (double)this.multiblock().rfAmplifiersPower * this.rfAmplifierRatio() || this.minRFAmplifiersTemp != this.multiblock().maxRFAmplifiersTemp;
        this.rfEfficiency = this.multiblock().rfEfficiency;
        this.magnetsEfficiency = this.multiblock().magnetsEfficiency;
        this.magneticFieldStrength = this.multiblock().magneticFieldStrength;
        this.magnetsPower = this.multiblock().magnetsPower;
        this.maxMagnetsTemp = this.multiblock().maxMagnetsTemp;
        this.rfAmplification = (int)((double)this.multiblock().rfAmplification * this.rfAmplifierRatio());
        this.rfAmplifiersPower = (int)((double)this.multiblock().rfAmplifiersPower * this.rfAmplifierRatio());
        this.minRFAmplifiersTemp = this.multiblock().maxRFAmplifiersTemp;
        if (hasChanges) {
            this.currentRfAmplification = this.rfAmplification;
        }
        return hasChanges;
    }

    protected double rfAmplifierRatio() {
        return Math.max(0.0, Math.min((double)this.rfAmplificationRatio / 100.0 * (double)this.amplificationAdjustment / 100.0, 1.0));
    }

    protected void coolantCoolDown() {
        if (this.hasCoolant() && this.reactorHeat > this.coolantRecipe.getCoolingRate()) {
            int coolantNeeded = (int)(this.reactorHeat / this.coolantRecipe.getCoolingRate());
            int coolantPerOp = this.coolantRecipe.getInputFluids()[0].getAmount();
            int availableCoolant = ((NcFluidTank)((Object)this.contentHandler.fluidCapability.tanks.get(2))).getFluidAmount();
            int possibleOps = availableCoolant / coolantPerOp;
            int actualOps = Math.min(possibleOps, coolantNeeded * coolantPerOp);
            this.changeReactorHeat(-(this.coolantRecipe.getCoolingRate() / (double)this.size) * (double)actualOps);
            this.extractCoolant(actualOps);
        }
    }

    protected void changeReactorHeat(double amount) {
        this.reactorHeat += amount;
        this.reactorHeat = Math.max(0.0, this.reactorHeat);
    }

    protected boolean coolDown() {
        double wasHeat = this.reactorHeat;
        this.changeReactorHeat(-1000 * this.size);
        this.coolantCoolDown();
        return wasHeat != this.reactorHeat;
    }

    protected void extractCoolant(int ops) {
        ((NcFluidTank)((Object)this.contentHandler.fluidCapability.tanks.get(2))).drain(this.coolantRecipe.getInputFluids()[0].getAmount() * ops, IFluidHandler.FluidAction.EXECUTE);
        FluidStack output = this.coolantRecipe.getOutputFluids().get(0).copy();
        output.setAmount(output.getAmount() * ops);
        ((NcFluidTank)((Object)this.contentHandler.fluidCapability.tanks.get(7))).fill(output, IFluidHandler.FluidAction.EXECUTE);
    }

    protected boolean processReaction() {
        if (this.recipeInfo.recipe != null && this.recipeInfo.isCompleted() && this.contentHandler.fluidCapability.getFluidInSlot(0).equals((Object)FluidStack.EMPTY)) {
            this.recipeInfo.clear();
        }
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (this.hasRecipe()) {
            return this.process();
        }
        return false;
    }

    protected boolean process() {
        this.recipeInfo.process(this.efficiency);
        if (this.recipeInfo.radiation != 1.0) {
            this.radiationAggregated += this.recipeInfo.radiation / 5000.0;
            if (this.radiationAggregated > 100.0) {
                RadiationManager.get(this.m_58904_()).addRadiation(this.m_58904_(), this.radiationAggregated, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
                this.radiationAggregated = 0.0;
            }
        }
        if (!this.recipeInfo.isCompleted()) {
            this.simulateHeatExchange();
            if (this.energyPerTick > 0) {
                this.renderBeam();
                this.energyStorage.addEnergy(this.energyPerTick);
            }
        }
        this.handleRecipeOutput();
        this.efficiency = this.calculateEfficiency();
        return true;
    }

    protected double calculateEfficiency() {
        double temperatureEfficiency = (double)this.plasmaTemperature / this.getOptimalTemperature();
        if ((double)this.plasmaTemperature > this.getOptimalTemperature()) {
            temperatureEfficiency = this.getOptimalTemperature() / (double)this.plasmaTemperature + 0.1;
        }
        return temperatureEfficiency;
    }

    protected void changePlasmaTemperature(long amount) {
        this.plasmaTemperature += amount;
        this.plasmaTemperature = Math.max(0L, this.plasmaTemperature);
    }

    protected void simulateHeatExchange() {
        this.amplifyPlasma();
        this.plasmaToEnergyExchange();
        this.heatLossExchange();
    }

    protected void heatLossExchange() {
        double sizeFactor = Math.log(Math.pow(this.size + 2, 2.0)) / 100.0;
        this.changePlasmaTemperature((long)(-((double)this.plasmaTemperature / Math.pow(this.getControlPartsEfficiency(), 2.0) * sizeFactor)));
        this.changeReactorHeat((double)Math.min(this.plasmaTemperature, 100000000L) / ((double)(10000 * this.size) * this.getControlPartsEfficiency()));
    }

    protected void plasmaToEnergyExchange() {
        double optimalTemp = this.getOptimalTemperature();
        double sizeFactor = Math.log(Math.pow(this.size + 1, 8.0)) / 8.0;
        this.energyPerTick = (double)this.plasmaTemperature < optimalTemp ? (int)((double)this.plasmaTemperature / optimalTemp * ((Recipe)this.recipeInfo.recipe()).getEnergy()) : (int)(optimalTemp / (double)this.plasmaTemperature * ((Recipe)this.recipeInfo.recipe()).getEnergy());
        this.changePlasmaTemperature(-((long)((double)this.plasmaTemperature / (150.0 * (double)this.energyPerTick / ((Recipe)this.recipeInfo.recipe()).getEnergy()))));
        this.energyPerTick = (int)((double)this.energyPerTick * this.calculateEfficiency() * (double)this.size * sizeFactor * (Double)FusionConfig.FUSION_CONFIG.PLASMA_TO_ENERGY_CONVERTION.get());
        if (this.plasmaTemperature < 1000000L) {
            this.energyPerTick = 0;
        }
        this.energyPerTick = (int)((double)this.energyPerTick * this.getControlPartsEfficiency());
    }

    protected void amplifyPlasma() {
        double sizeFactor = Math.log(Math.pow(this.size + 1, 5.0)) / 10.0;
        double pRatio = Math.log(this.getOptimalTemperature() / 1.5E8);
        double plasmaHeatScale = (pRatio - Math.sqrt(pRatio) + 5.0) / 7.0;
        double amplificationVolume = (double)this.rfAmplification * sizeFactor;
        double amplification = amplificationVolume * plasmaHeatScale * this.rfAmplifierRatio() * this.getHeatDeviationMultiplier() * (Double)FusionConfig.FUSION_CONFIG.RF_AMPLIFICATION_MULTIPLIER.get();
        this.prevAmplification += (long)(amplification / 1000.0);
        this.prevAmplification = (long)Math.min((double)this.prevAmplification, amplification);
        this.changePlasmaTemperature(this.prevAmplification);
    }

    protected void handleRecipeOutput() {
        if (this.hasRecipe() && this.recipeInfo.isCompleted()) {
            if (this.recipe == null) {
                this.recipe = (Recipe)this.recipeInfo.recipe();
            }
            if (((AbstractRecipe)this.recipe).handleOutputs(this.contentHandler)) {
                this.recipeInfo.clear();
                if (this.contentHandler.fluidCapability.getFluidInSlot(0).isEmpty()) {
                    this.recipe = null;
                }
            } else {
                this.recipeInfo.stuck = true;
            }
            this.m_6596_();
        }
    }

    protected void updateRecipe() {
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.recipeInfo.setRecipe(this.recipe);
            this.recipeInfo.ticks = (int)(((Recipe)this.recipeInfo.recipe()).getTimeModifier() * 10.0);
            this.recipeInfo.energy = ((Recipe)this.recipeInfo.recipe).getEnergy();
            this.recipeInfo.heat = ((Recipe)this.recipeInfo.recipe()).getHeat();
            this.recipeInfo.radiation = ((Recipe)this.recipeInfo.recipe()).getRadiation();
            this.recipeInfo.be = this;
            ((AbstractRecipe)this.recipe).consumeInputs(this.contentHandler);
        }
    }

    protected void addToCache(RECIPE recipe) {
        String key = this.contentHandler.getCacheKey();
        if (this.cachedRecipes.containsKey(key)) {
            this.cachedRecipes.replace(key, recipe);
        } else {
            this.cachedRecipes.put(key, recipe);
        }
    }

    public RECIPE getRecipe() {
        if (this.contentHandler.fluidCapability.getFluidInSlot(0).isEmpty() || this.contentHandler.fluidCapability.getFluidInSlot(0).isEmpty()) {
            return null;
        }
        RECIPE cachedRecipe = this.getCachedRecipe();
        if (cachedRecipe != null) {
            return cachedRecipe;
        }
        if (!NcRecipeType.ALL_RECIPES.containsKey(this.getName())) {
            return null;
        }
        for (AbstractRecipe abstractRecipe : NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_())) {
            if (!abstractRecipe.test(this.contentHandler)) continue;
            this.addToCache((Recipe)abstractRecipe);
            return (RECIPE)((Recipe)abstractRecipe);
        }
        return null;
    }

    public RECIPE getCachedRecipe() {
        String key = this.contentHandler.getCacheKey();
        if (this.cachedRecipes.containsKey(key) && ((Recipe)this.cachedRecipes.get(key)).test(this.contentHandler)) {
            return (RECIPE)((Recipe)this.cachedRecipes.get(key));
        }
        return null;
    }

    public boolean recipeIsStuck() {
        return this.recipeInfo.isStuck();
    }

    protected void handleMeltdown() {
        if (!this.isCasingValid) {
            return;
        }
        if (this.reactorHeat > this.getMaxHeat() && this.plasmaTemperature > 1000L) {
            this.meltDown();
            this.plasmaTemperature = (long)((double)this.plasmaTemperature / 5.0);
            this.reactorHeat /= 2.0;
        }
    }

    private void meltDown() {
        double explosionRadius = (Double)FusionConfig.FUSION_CONFIG.EXPLOSION_RADIUS.get();
        if (explosionRadius > 0.0) {
            BlockPos blockPos = this.m_58899_();
        }
    }

    public boolean hasRedstoneSignal() {
        return this.inputRedstoneSignal > 0;
    }

    public boolean hasRecipe() {
        return this.recipeInfo.recipe() != null;
    }

    public void forceShutdown() {
        this.forceShutdown = true;
    }

    public void disableForceShutdown() {
        this.forceShutdown = false;
    }

    public void voidFuel() {
        ((NcFluidTank)((Object)this.contentHandler.fluidCapability.tanks.get(0))).setFluid(FluidStack.EMPTY);
        ((NcFluidTank)((Object)this.contentHandler.fluidCapability.tanks.get(1))).setFluid(FluidStack.EMPTY);
        this.contentHandler.clearHolded();
    }

    @Override
    public void handleSliderUpdate(int buttonId, int ratio) {
        if (buttonId == 0) {
            this.amplificationAdjustment = Math.min(100, Math.max(ratio, 1));
            this.changed = this.updateCharacteristics();
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        }
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.readTagData(infoTag);
            if (infoTag.m_128441_("recipeInfo")) {
                this.recipeInfo.deserializeNBT((Tag)infoTag.m_128469_("recipeInfo"));
            }
            if (!this.isCasingValid || !this.isInternalValid) {
                if (tag.m_128441_("erroredBlock")) {
                    this.errorBlockPos = BlockPos.m_122022_((long)infoTag.m_128454_("erroredBlock"));
                }
                this.validationResult = ValidationResult.byId(infoTag.m_128451_("validationId"));
            } else {
                this.validationResult = ValidationResult.VALID;
            }
        }
        if (tag.m_128441_("Content")) {
            this.contentHandler.deserializeNBT((Tag)tag.m_128469_("Content"));
        }
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        tag.m_128365_("Content", this.contentHandler.serializeNBT());
        infoTag.m_128365_("recipeInfo", this.recipeInfo.serializeNBT());
        infoTag.m_128405_("validationId", this.validationResult.id);
        if (this.errorBlockPos instanceof BlockPos) {
            infoTag.m_128356_("erroredBlock", this.errorBlockPos.m_121878_());
        }
        this.saveTagData(infoTag);
        tag.m_128365_("Info", (Tag)infoTag);
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            if (infoTag.m_128441_("recipeInfo")) {
                this.recipeInfo.deserializeNBT((Tag)infoTag.m_128469_("recipeInfo"));
            }
            this.energyStorage.setEnergy(infoTag.m_128451_("energy"));
            this.readTagData(infoTag);
            if (!this.isCasingValid || !this.isInternalValid) {
                this.errorBlockPos = BlockPos.m_122022_((long)infoTag.m_128454_("erroredBlock"));
                this.validationResult = ValidationResult.byId(infoTag.m_128451_("validationId"));
            } else {
                this.validationResult = ValidationResult.VALID;
            }
            if (tag.m_128441_("Content")) {
                this.contentHandler.deserializeNBT((Tag)tag.m_128469_("Content"));
            }
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Info", (Tag)infoTag);
        infoTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        this.saveTagData(infoTag);
        infoTag.m_128365_("recipeInfo", this.recipeInfo.serializeNBT());
        infoTag.m_128405_("validationId", this.validationResult.id);
        if (this.errorBlockPos != null) {
            infoTag.m_128356_("erroredBlock", this.errorBlockPos.m_121878_());
        }
        tag.m_128365_("Content", this.contentHandler.serializeNBT());
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        int oldEnergy = this.energyStorage.getEnergyStored();
        CompoundTag tag = pkt.m_131708_();
        this.handleUpdateTag(tag);
        if (oldEnergy != this.energyStorage.getEnergyStored()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public void invalidateCache() {
        super.invalidateCache();
        this.isCasingValid = false;
        this.isInternalValid = false;
    }

    public boolean hasCoolant() {
        FluidStack coolant = this.contentHandler.fluidCapability.getFluidInSlot(2);
        if (coolant.isEmpty()) {
            this.coolantRecipe = null;
            return false;
        }
        if (this.coolantRecipe == null) {
            for (FusionCoolantRecipe recipe : this.getCoolantRecipes()) {
                if (!recipe.getInputFluids()[0].test(coolant)) continue;
                this.coolantRecipe = recipe;
                return true;
            }
        } else if (!this.coolantRecipe.getInputFluids()[0].test(coolant)) {
            this.coolantRecipe = null;
            return false;
        }
        return this.coolantRecipe instanceof FusionCoolantRecipe;
    }

    public boolean hasEnoughEnergy() {
        return this.energyStorage.getEnergyStored() > this.rfAmplifiersPower + this.magnetsPower;
    }

    public boolean isRunning() {
        return this.powered && this.energyPerTick > 0 && this.plasmaTemperature > 0L && this.efficiency > 0.0;
    }

    public static class SignalSource {
        public static final byte ENERGY = 11;
        public static final byte HEAT = 12;
        public static final byte EFFICIENCY = 13;
    }

    public static class FusionCoolantRecipe
    extends NcRecipe {
        protected double coolingRate;

        public FusionCoolantRecipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double temperature, double powerModifier, double radiation, double rar) {
            super(id, input, output, inputFluids, outputFluids, temperature, powerModifier, radiation, rar);
            this.coolingRate = temperature;
        }

        @Override
        @NotNull
        public String m_6076_() {
            return "fusion_coolant";
        }

        @Override
        public String getCodeId() {
            return "fusion_coolant";
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)FusionReactor.FUSION_BLOCKS.get("fusion_core").get());
        }

        public double getCoolingRate() {
            return Math.max(this.rarityModifier, 1.0);
        }
    }

    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double radiation, double temperature) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, radiation, temperature);
        }

        @Override
        @NotNull
        public String m_6076_() {
            return ((Block)FusionReactor.FUSION_BLOCKS.get(this.codeId).get()).m_49954_().getString();
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)FusionReactor.FUSION_BLOCKS.get(this.codeId).get());
        }

        @Override
        public double getEnergy() {
            return this.powerModifier;
        }

        public double getHeat() {
            return this.powerModifier;
        }

        @Override
        public double getRadiation() {
            return this.radiationModifier;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            super.write(buffer);
            buffer.writeDouble(this.getOptimalTemperature());
        }

        public double getOptimalTemperature() {
            return this.rarityModifier;
        }

        @Override
        public String getCodeId() {
            return "fusion_core";
        }
    }
}

