/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.CachedMap;
import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.inventory.ScreenBase;
import de.maxhenkel.corpse.entities.DummyPlayer;
import de.maxhenkel.corpse.gui.DeathHistoryContainer;
import de.maxhenkel.corpse.net.MessageShowCorpseInventory;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class DeathHistoryScreen
extends ScreenBase<AbstractContainerMenu> {
    private static final ResourceLocation DEATH_HISTORY_GUI_TEXTURE = new ResourceLocation("corpse", "textures/gui/gui_death_history.png");
    private final CachedMap<Death, DummyPlayer> players = new CachedMap(10000L);
    private Button previous;
    private Button next;
    private List<Death> deaths;
    private int index;
    private int hSplit;
    private static boolean errorShown;

    public DeathHistoryScreen(List<Death> deaths) {
        super(DEATH_HISTORY_GUI_TEXTURE, new DeathHistoryContainer(), Minecraft.m_91087_().f_91074_.m_150109_(), (Component)Component.m_237115_((String)"gui.death_history.corpse.title"));
        this.deaths = deaths;
        this.index = 0;
        this.f_97726_ = 248;
        this.f_97727_ = 166;
        this.hSplit = this.f_97726_ / 2;
    }

    protected void m_7856_() {
        super.m_7856_();
        int padding = 7;
        int buttonWidth = 50;
        int buttonHeight = 20;
        this.previous = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.corpse.previous"), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = 0;
            }
        }).m_252987_(this.f_97735_ + padding, this.f_97736_ + this.f_97727_ - buttonHeight - padding, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.corpse.show_items"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageShowCorpseInventory(this.getCurrentDeath().getPlayerUUID(), this.getCurrentDeath().getId()))).m_252987_(this.f_97735_ + (this.f_97726_ - buttonWidth) / 2, this.f_97736_ + this.f_97727_ - buttonHeight - padding, buttonWidth, buttonHeight).m_253136_());
        this.next = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"button.corpse.next"), button -> {
            ++this.index;
            if (this.index >= this.deaths.size()) {
                this.index = this.deaths.size() - 1;
            }
        }).m_252987_(this.f_97735_ + this.f_97726_ - buttonWidth - padding, this.f_97736_ + this.f_97727_ - buttonHeight - padding, buttonWidth, buttonHeight).m_253136_());
    }

    public boolean m_6375_(double x, double y, int clickType) {
        if (x >= (double)(this.f_97735_ + 7) && x <= (double)(this.f_97735_ + this.hSplit) && y >= (double)(this.f_97736_ + 70)) {
            Objects.requireNonNull(this.f_96547_);
            if (y <= (double)(this.f_97736_ + 100 + 9)) {
                BlockPos pos = this.getCurrentDeath().getBlockPos();
                MutableComponent teleport = ComponentUtils.m_130748_((Component)Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()})).m_130938_(style -> style.m_131157_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in " + this.getCurrentDeath().getDimension() + " run tp @s " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip"))));
                this.f_96541_.f_91074_.m_213846_((Component)Component.m_237110_((String)"chat.corpse.teleport_death_location", (Object[])new Object[]{teleport}));
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.f_96541_.m_91152_(null);
            }
        }
        return super.m_6375_(x, y, clickType);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        Death death = this.getCurrentDeath();
        MutableComponent title = Component.m_237115_((String)"gui.corpse.death_history.title").m_130940_(ChatFormatting.BLACK);
        int titleWidth = this.f_96547_.m_92895_(title.getString());
        guiGraphics.m_280649_(this.f_96547_, title.m_7532_(), (this.f_97726_ - titleWidth) / 2, 7, 0, false);
        MutableComponent date = Component.m_237113_((String)DeathHistoryScreen.getDate(death.getTimestamp()).getString()).m_130940_(ChatFormatting.DARK_GRAY);
        int dateWidth = this.f_96547_.m_92852_((FormattedText)date);
        guiGraphics.m_280649_(this.f_96547_, date.m_7532_(), (this.f_97726_ - dateWidth) / 2, 20, 0, false);
        this.drawLeft(guiGraphics, Component.m_237115_((String)"gui.corpse.death_history.name").m_7220_((Component)Component.m_237113_((String)":")).m_130940_(ChatFormatting.DARK_GRAY), 40);
        this.drawRight(guiGraphics, Component.m_237113_((String)death.getPlayerName()).m_130940_(ChatFormatting.GRAY), 40);
        MutableComponent dimension = Component.m_237115_((String)"gui.corpse.death_history.dimension").m_7220_((Component)Component.m_237113_((String)":")).m_130940_(ChatFormatting.DARK_GRAY);
        this.drawLeft(guiGraphics, dimension, 55);
        String dimensionName = death.getDimension().split(":")[1];
        boolean shortened = false;
        int dimWidth = this.f_96547_.m_92852_((FormattedText)dimension);
        while (dimWidth + this.f_96547_.m_92895_(dimensionName + (shortened ? "..." : "")) >= this.hSplit - 7) {
            dimensionName = dimensionName.substring(0, dimensionName.length() - 1);
            shortened = true;
        }
        this.drawRight(guiGraphics, Component.m_237115_((String)(dimensionName + (shortened ? "..." : ""))).m_130940_(ChatFormatting.GRAY), 55);
        this.drawLeft(guiGraphics, Component.m_237115_((String)"gui.corpse.death_history.location").m_7220_((Component)Component.m_237113_((String)":")).m_130940_(ChatFormatting.DARK_GRAY), 70);
        this.drawRight(guiGraphics, Component.m_237113_((String)(Math.round(death.getPosX()) + " X")).m_130940_(ChatFormatting.GRAY), 70);
        this.drawRight(guiGraphics, Component.m_237113_((String)(Math.round(death.getPosY()) + " Y")).m_130940_(ChatFormatting.GRAY), 85);
        this.drawRight(guiGraphics, Component.m_237113_((String)(Math.round(death.getPosZ()) + " Z")).m_130940_(ChatFormatting.GRAY), 100);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DummyPlayer dummyPlayer = this.players.get(death, () -> new DummyPlayer(this.f_96541_.f_91073_, new GameProfile(death.getPlayerUUID(), death.getPlayerName()), death.getEquipment(), death.getModel()));
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)((int)((double)this.f_97726_ * 0.75)), (int)(this.f_97727_ / 2 + 30), (int)40, (float)((int)((double)this.f_97735_ + (double)this.f_97726_ * 0.75) - mouseX), (float)(this.f_97727_ / 2 - mouseY), (LivingEntity)dummyPlayer);
        if (mouseX >= this.f_97735_ + 7 && mouseX <= this.f_97735_ + this.hSplit && mouseY >= this.f_97736_ + 70) {
            Objects.requireNonNull(this.f_96547_);
            if (mouseY <= this.f_97736_ + 100 + 9) {
                guiGraphics.m_280245_(this.f_96547_, Collections.singletonList(Component.m_237115_((String)"tooltip.corpse.teleport").m_7532_()), mouseX - this.f_97735_, mouseY - this.f_97736_);
                return;
            }
        }
        if (mouseX < this.f_97735_ + 7) return;
        if (mouseX > this.f_97735_ + this.hSplit) return;
        if (mouseY < this.f_97736_ + 55) return;
        Objects.requireNonNull(this.f_96547_);
        if (mouseY > this.f_97736_ + 55 + 9) return;
        guiGraphics.m_280245_(this.f_96547_, (List)Lists.newArrayList((Object[])new FormattedCharSequence[]{Component.m_237115_((String)"gui.corpse.death_history.dimension").m_7532_(), Component.m_237113_((String)death.getDimension()).m_130940_(ChatFormatting.GRAY).m_7532_()}), mouseX - this.f_97735_, mouseY - this.f_97736_);
    }

    public static Component getDate(long timestamp) {
        SimpleDateFormat dateFormat;
        try {
            dateFormat = new SimpleDateFormat(Component.m_237115_((String)"gui.corpse.death_history.date_format").getString());
        }
        catch (Exception e) {
            if (!errorShown) {
                Main.LOGGER.error("Failed to create date format. This indicates a broken translation: 'gui.corpse.death_history.date_format' translated to {}", (Object)Component.m_237115_((String)"gui.corpse.death_history.date_format").getString());
                errorShown = true;
            }
            dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
        return Component.m_237113_((String)dateFormat.format(new Date(timestamp)));
    }

    protected void m_181908_() {
        super.m_181908_();
        this.previous.f_93623_ = this.index > 0;
        this.next.f_93623_ = this.index < this.deaths.size() - 1;
    }

    public void drawLeft(GuiGraphics guiGraphics, MutableComponent text, int height) {
        guiGraphics.m_280649_(this.f_96547_, text.m_7532_(), 7, height, 0, false);
    }

    public void drawRight(GuiGraphics guiGraphics, MutableComponent text, int height) {
        int strWidth = this.f_96547_.m_92852_((FormattedText)text);
        guiGraphics.m_280649_(this.f_96547_, text.m_7532_(), this.hSplit - strWidth, height, 0, false);
    }

    public Death getCurrentDeath() {
        return this.deaths.get(this.index);
    }
}

