/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.povstalec.sgjourney.common.world.features.configuration.SpireConfiguration;

public class SpireFeature
extends Feature<SpireConfiguration> {
    public SpireFeature(Codec<SpireConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SpireConfiguration> context) {
        SpireConfiguration config = (SpireConfiguration)context.m_159778_();
        BlockPos blockpos = context.m_159777_();
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        while (!worldgenlevel.m_8055_(blockpos).m_60713_(config.fillingProvider.m_213972_(randomsource, blockpos).m_60734_()) && blockpos.m_123342_() > worldgenlevel.m_141937_() + 2) {
            blockpos = blockpos.m_7495_();
        }
        if (worldgenlevel.m_46859_(blockpos) || !worldgenlevel.m_8055_(blockpos).m_204336_(config.canProtrudeThrough)) {
            return false;
        }
        int spireLevels = randomsource.m_216332_(15, 25);
        int totalHeight = 0;
        for (int spireLevel = 0; spireLevel < spireLevels; ++spireLevel) {
            int currentCenterX = randomsource.m_216332_(-2, 2);
            int currentCenterZ = randomsource.m_216332_(-2, 2);
            int xDeformation = randomsource.m_216332_(-2, 2);
            int zDeformation = randomsource.m_216332_(-2, 2);
            int ySize = randomsource.m_216332_(4, 6);
            int levelRadius = 10 + spireLevels % 5 - spireLevel / 3;
            int xRadius = levelRadius + xDeformation;
            int zRadius = levelRadius + zDeformation;
            for (int y = 0; y <= ySize; ++y) {
                xRadius = this.adjustRadius(xRadius, ySize, y);
                zRadius = this.adjustRadius(zRadius, ySize, y);
                for (int x = -xRadius; x <= xRadius; ++x) {
                    for (int z = -zRadius; z <= zRadius; ++z) {
                        double zScale;
                        double xScale = Math.pow((double)(x - currentCenterX) / (double)xRadius, 2.0);
                        if (!(xScale + (zScale = Math.pow((double)(z - currentCenterZ) / (double)zRadius, 2.0)) < 1.0)) continue;
                        int chance = randomsource.m_216332_(1, 100);
                        if (chance > 5) {
                            this.setOre(worldgenlevel, blockpos, x, y, z, totalHeight, config, randomsource);
                            continue;
                        }
                        this.setFilling(worldgenlevel, blockpos, x, y, z, spireLevel, totalHeight, config, randomsource);
                    }
                }
            }
            totalHeight += ySize;
        }
        return true;
    }

    private void setOre(WorldGenLevel worldgenlevel, BlockPos blockpos, int x, int y, int z, int totalHeight, SpireConfiguration config, RandomSource randomsource) {
        this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_7918_(x, y + totalHeight, z), config.fillingProvider.m_213972_(randomsource, blockpos));
    }

    private void setFilling(WorldGenLevel worldgenlevel, BlockPos blockpos, int x, int y, int z, int spireLevel, int totalHeight, SpireConfiguration config, RandomSource randomsource) {
        int chance = randomsource.m_216332_(1, 100);
        if (chance - spireLevel < 7) {
            this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_7918_(x, y + totalHeight, z), Blocks.f_50062_.m_49966_());
        } else if (chance - spireLevel >= 7 && chance - spireLevel < 10) {
            this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_7918_(x, y + totalHeight, z), Blocks.f_50122_.m_49966_());
        } else {
            this.m_5974_((LevelWriter)worldgenlevel, blockpos.m_7918_(x, y + totalHeight, z), config.fillingPlacements.m_213972_(randomsource, blockpos));
        }
    }

    private int adjustRadius(int radius, int ySize, int y) {
        if (y == 0) {
            return radius + 2;
        }
        if (y == ySize) {
            return radius - 2;
        }
        if (y == 1) {
            return radius + 1;
        }
        if (y == ySize - 1) {
            return radius - 1;
        }
        return radius;
    }
}

