/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.advancements.WormholeTravelCriterion;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingPart;
import net.povstalec.sgjourney.common.config.CommonIrisConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.init.StatisticsInit;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.stargate.Stargate;

public class Wormhole
implements ITeleporter {
    private static final String EVENT_DECONSTRUCTING_ENTITY = "stargate_deconstructing_entity";
    private static final String EVENT_RECONSTRUCTING_ENTITY = "stargate_reconstructing_entity";
    private static final String EVENT_IRIS_THUD = "iris_thud";
    public static final double MIN_SPEED = 0.4;
    protected Map<Integer, Vec3> entityLocations = new HashMap<Integer, Vec3>();
    protected List<Entity> localEntities = new ArrayList<Entity>();
    protected boolean used = false;

    public boolean hasCandidates() {
        return this.localEntities.isEmpty();
    }

    public boolean findCandidates(Level level, Vec3 centerPos, Direction direction) {
        AABB localBox = new AABB(centerPos.f_82479_ - 2.5, centerPos.f_82480_ - 2.5, centerPos.f_82481_ - 2.5, centerPos.f_82479_ + 2.5, centerPos.f_82480_ + 2.5, centerPos.f_82481_ + 2.5);
        this.localEntities = level.m_45976_(Entity.class, localBox);
        if (this.localEntities.isEmpty()) {
            return false;
        }
        Stream entityStream = this.localEntities.stream();
        Iterator iterator = entityStream.iterator();
        while (iterator.hasNext()) {
            if (((Entity)iterator.next()).m_6095_().m_204039_(TagInit.Entities.WORMHOLE_IGNORES)) continue;
            return true;
        }
        return false;
    }

    public boolean wormholeEntities(AbstractStargateEntity initialStargate, AbstractStargateEntity targetStargate, Stargate.WormholeTravel twoWayWormhole) {
        this.used = false;
        Direction direction = initialStargate.getDirection();
        Direction orientationDirection = Orientation.getEffectiveDirection(direction, initialStargate.getOrientation());
        HashMap<Integer, Vec3> entityLocations = new HashMap<Integer, Vec3>();
        for (Entity traveler : this.localEntities) {
            if (!traveler.m_6095_().m_204039_(TagInit.Entities.WORMHOLE_CANNOT_TELEPORT) && this.entityLocations.containsKey(traveler.m_19879_())) {
                double axisMomentum;
                double travelerPos;
                double previousTravelerPos;
                int unitDistance;
                double previousX = this.entityLocations.get(traveler.m_19879_()).m_7096_();
                double previousY = this.entityLocations.get(traveler.m_19879_()).m_7098_();
                double previousZ = this.entityLocations.get(traveler.m_19879_()).m_7094_();
                Vec3 momentum = new Vec3(traveler.m_20185_() - previousX, traveler.m_20186_() - previousY, traveler.m_20189_() - previousZ);
                if (orientationDirection == null) {
                    return this.used;
                }
                if (orientationDirection.m_122434_() == Direction.Axis.X) {
                    unitDistance = initialStargate.getCenterPos().m_123341_() - initialStargate.getCenterPos().m_121945_(orientationDirection).m_123341_();
                    previousTravelerPos = (double)initialStargate.getCenterPos().m_123341_() + 0.5 - previousX;
                    travelerPos = (double)initialStargate.getCenterPos().m_123341_() + 0.5 - traveler.m_20185_();
                    axisMomentum = momentum.m_7096_();
                    if (Math.abs(momentum.m_7096_()) < 0.4) {
                        momentum = new Vec3(this.reverseIfNeeded(unitDistance < 0, 0.4), momentum.m_7098_(), momentum.m_7094_());
                    }
                } else if (orientationDirection.m_122434_() == Direction.Axis.Z) {
                    unitDistance = initialStargate.getCenterPos().m_123343_() - initialStargate.getCenterPos().m_121945_(orientationDirection).m_123343_();
                    previousTravelerPos = (double)initialStargate.getCenterPos().m_123343_() + 0.5 - previousZ;
                    travelerPos = (double)initialStargate.getCenterPos().m_123343_() + 0.5 - traveler.m_20189_();
                    axisMomentum = momentum.m_7094_();
                    if (Math.abs(momentum.m_7094_()) < 0.4) {
                        momentum = new Vec3(momentum.m_7096_(), momentum.m_7098_(), this.reverseIfNeeded(unitDistance < 0, 0.4));
                    }
                } else {
                    unitDistance = initialStargate.getCenterPos().m_123342_() - initialStargate.getCenterPos().m_121945_(orientationDirection).m_123342_();
                    previousTravelerPos = (double)initialStargate.getCenterPos().m_123342_() + initialStargate.getGateAddition() - previousY;
                    travelerPos = (double)initialStargate.getCenterPos().m_123342_() + initialStargate.getGateAddition() - traveler.m_20186_();
                    axisMomentum = momentum.m_7098_();
                    if (Math.abs(momentum.m_7098_()) < 0.4) {
                        momentum = new Vec3(momentum.m_7096_(), this.reverseIfNeeded(unitDistance < 0, 0.4), momentum.m_7094_());
                    }
                }
                if (this.shouldWormhole(initialStargate, traveler, unitDistance, previousTravelerPos, travelerPos, axisMomentum)) {
                    this.doWormhole(initialStargate, targetStargate, traveler, momentum, twoWayWormhole);
                    continue;
                }
                entityLocations.put(traveler.m_19879_(), new Vec3(traveler.m_20185_(), traveler.m_20186_(), traveler.m_20189_()));
                continue;
            }
            entityLocations.put(traveler.m_19879_(), new Vec3(traveler.m_20185_(), traveler.m_20186_(), traveler.m_20189_()));
        }
        this.entityLocations = entityLocations;
        return this.used;
    }

    public boolean shouldWormhole(AbstractStargateEntity initialStargate, Entity traveler, int unitDistance, double previousTravelerPos, double travelerPos, double axisMomentum) {
        Vec3 travelerVector;
        Vec3 centerVector = initialStargate.getCenter();
        if (centerVector.m_82554_(travelerVector = traveler.m_20191_().m_82399_()) > 2.5) {
            return false;
        }
        previousTravelerPos = this.reverseIfNeeded(unitDistance > 0, previousTravelerPos);
        travelerPos = this.reverseIfNeeded(unitDistance > 0, travelerPos);
        axisMomentum = this.reverseIfNeeded(unitDistance > 0, axisMomentum);
        return previousTravelerPos < 0.0 && travelerPos >= 0.0 && axisMomentum < 0.0;
    }

    public double reverseIfNeeded(boolean shouldReverse, double number) {
        return shouldReverse ? -number : number;
    }

    public boolean handleShielding(AbstractStargateEntity targetStargate, Vec3 destinationPos, Vec3 motionVec, Entity traveler) {
        if (targetStargate.isIrisClosed()) {
            return false;
        }
        EntityDimensions dimension = traveler.m_6972_(traveler.m_20089_());
        Vec3 travelerCenter = dimension.m_20393_(destinationPos).m_82399_();
        Vec3 fromVec = travelerCenter.m_82546_(motionVec);
        Vec3 toVec = travelerCenter.m_82549_(motionVec);
        Level targetLevel = targetStargate.m_58904_();
        BlockPos pos = targetStargate.m_58899_();
        BlockState state = targetLevel.m_8055_(targetStargate.m_58899_());
        Block block = state.m_60734_();
        if (block instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            for (ShieldingPart part : stargateBlock.getShieldingParts()) {
                BlockPos shieldingPos = part.getShieldingPos(pos, (Direction)state.m_61143_((Property)AbstractStargateBlock.FACING), (Orientation)((Object)state.m_61143_(AbstractStargateBlock.ORIENTATION)));
                BlockState shieldingState = targetLevel.m_8055_(shieldingPos);
                if (!(shieldingState.m_60734_() instanceof AbstractShieldingBlock) || shieldingState.m_60812_((BlockGetter)targetLevel, shieldingPos).m_83220_(fromVec, toVec, shieldingPos) == null) continue;
                return false;
            }
        }
        return true;
    }

    public void doWormhole(AbstractStargateEntity initialStargate, AbstractStargateEntity targetStargate, Entity traveler, Vec3 momentum, Stargate.WormholeTravel twoWayWormhole) {
        Player player;
        Level level = traveler.m_9236_();
        Wormhole.playWormholeSound(level, traveler);
        if (level.m_5776_()) {
            return;
        }
        if (twoWayWormhole == Stargate.WormholeTravel.ENABLED || traveler instanceof Player && (player = (Player)traveler).m_7500_() && twoWayWormhole == Stargate.WormholeTravel.CREATIVE_ONLY) {
            ServerLevel destinationlevel = (ServerLevel)targetStargate.m_58904_();
            if (destinationlevel == null) {
                StargateJourney.LOGGER.error("Can't teleport Entity because Dimension is null");
                return;
            }
            if (targetStargate != null) {
                ServerPlayer player2;
                Vec3 motionVec;
                boolean blocked;
                Direction initialDirection = initialStargate.getDirection();
                Orientation initialOrientation = initialStargate.getOrientation();
                Direction destinationDirection = targetStargate.getDirection();
                Orientation destinationOrientation = targetStargate.getOrientation();
                double initialYAddition = initialStargate.getGateAddition();
                double destinationYAddition = targetStargate.getGateAddition();
                Vec3 relativePos = CoordinateHelper.Relative.preserveRelative(initialDirection, initialOrientation, destinationDirection, destinationOrientation, new Vec3(traveler.m_20185_() - ((double)initialStargate.getCenterPos().m_123341_() + 0.5), traveler.m_20186_() - ((double)initialStargate.getCenterPos().m_123342_() + initialYAddition), traveler.m_20189_() - ((double)initialStargate.getCenterPos().m_123343_() + 0.5)));
                Vec3 destinationPos = new Vec3((double)targetStargate.getCenterPos().m_123341_() + 0.5 + relativePos.m_7096_(), (double)targetStargate.getCenterPos().m_123342_() + destinationYAddition + relativePos.m_7098_(), (double)targetStargate.getCenterPos().m_123343_() + 0.5 + relativePos.m_7094_());
                boolean bl = blocked = !this.handleShielding(targetStargate, destinationPos, motionVec = CoordinateHelper.Relative.preserveRelative(initialDirection, initialOrientation, destinationDirection, destinationOrientation, momentum), traveler);
                if (blocked) {
                    if (traveler instanceof ServerPlayer && (player2 = (ServerPlayer)traveler).m_7500_()) {
                        if (!((Boolean)CommonIrisConfig.creative_ignores_iris.get()).booleanValue()) {
                            player2.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.stargate.error.iris").m_130940_(ChatFormatting.DARK_RED), true);
                            return;
                        }
                    } else {
                        if (traveler instanceof ServerPlayer) {
                            ServerPlayer player3 = (ServerPlayer)traveler;
                            player3.m_36220_((ResourceLocation)StatisticsInit.TIMES_SMASHED_AGAINST_IRIS.get());
                        }
                        traveler.m_6074_();
                        targetStargate.playIrisThudSound();
                        targetStargate.decreaseIrisDurability();
                        this.irisThudEvent(targetStargate, traveler);
                        return;
                    }
                }
                if (traveler instanceof ServerPlayer) {
                    player2 = (ServerPlayer)traveler;
                    this.deconstructEvent(initialStargate, (Entity)player2, false);
                    player2.m_8999_(destinationlevel, destinationPos.m_7096_(), destinationPos.m_7098_(), destinationPos.m_7094_(), CoordinateHelper.Relative.preserveYRot(initialDirection, destinationDirection, player2.m_146908_()), player2.m_146909_());
                    player2.m_20256_(CoordinateHelper.Relative.preserveRelative(initialDirection, initialOrientation, destinationDirection, destinationOrientation, momentum));
                    player2.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(traveler));
                    Wormhole.playWormholeSound(level, (Entity)player2);
                    this.reconstructEvent(targetStargate, (Entity)player2);
                    Level initialLevel = initialStargate.m_58904_();
                    ResourceLocation initialDimension = initialLevel.m_46472_().m_135782_();
                    Level targetLevel = targetStargate.m_58904_();
                    ResourceLocation targetDimension = targetLevel.m_46472_().m_135782_();
                    long distanceTraveled = (int)Math.round(DimensionType.m_63908_((DimensionType)initialLevel.m_6042_(), (DimensionType)targetLevel.m_6042_()) * Math.sqrt(initialStargate.getCenterPos().m_123331_((Vec3i)targetStargate.getCenterPos())));
                    player2.m_36220_((ResourceLocation)StatisticsInit.TIMES_USED_WORMHOLE.get());
                    player2.m_36222_((ResourceLocation)StatisticsInit.DISTANCE_TRAVELED_BY_STARGATE.get(), (int)distanceTraveled * 100);
                    WormholeTravelCriterion.INSTANCE.trigger(player2, initialDimension, targetDimension, distanceTraveled);
                } else {
                    this.deconstructEvent(initialStargate, traveler, false);
                    Entity newTraveler = traveler;
                    if ((ServerLevel)level != destinationlevel) {
                        newTraveler = traveler.changeDimension(destinationlevel, (ITeleporter)this);
                    }
                    newTraveler.m_7678_(destinationPos.m_7096_(), destinationPos.m_7098_(), destinationPos.m_7094_(), CoordinateHelper.Relative.preserveYRot(initialDirection, destinationDirection, traveler.m_146908_()), traveler.m_146909_());
                    newTraveler.m_20256_(CoordinateHelper.Relative.preserveRelative(initialDirection, initialOrientation, destinationDirection, destinationOrientation, momentum));
                    Wormhole.playWormholeSound(level, newTraveler);
                    this.reconstructEvent(targetStargate, newTraveler);
                }
                this.used = true;
            }
        } else if (((Boolean)CommonStargateConfig.reverse_wormhole_kills.get()).booleanValue()) {
            if (traveler.m_6084_()) {
                ServerPlayer player4;
                if (traveler instanceof ServerPlayer && (player4 = (ServerPlayer)traveler).m_7500_()) {
                    player4.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.stargate.error.one_way_wormhole").m_130940_(ChatFormatting.DARK_RED), true);
                } else {
                    if (traveler instanceof ServerPlayer) {
                        ServerPlayer player5 = (ServerPlayer)traveler;
                        player5.m_36220_((ResourceLocation)StatisticsInit.TIMES_KILLED_BY_WORMHOLE.get());
                    }
                    traveler.m_6074_();
                    this.deconstructEvent(initialStargate, traveler, true);
                }
            }
        } else if (traveler instanceof ServerPlayer) {
            ServerPlayer player6 = (ServerPlayer)traveler;
            player6.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.stargate.error.one_way_wormhole").m_130940_(ChatFormatting.DARK_RED), true);
        }
    }

    private void irisThudEvent(AbstractStargateEntity targetStargate, Entity traveler) {
        String string;
        String travelerType = EntityType.m_20613_((EntityType)traveler.m_6095_()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.m_36316_().getName();
        } else {
            string = traveler.m_7755_().getString();
        }
        String displayName = string;
        String uuid = traveler.m_20148_().toString();
        targetStargate.updateInterfaceBlocks(EVENT_IRIS_THUD, travelerType, displayName, uuid);
    }

    private void deconstructEvent(AbstractStargateEntity initialStargate, Entity traveler, boolean disintegrated) {
        String string;
        String travelerType = EntityType.m_20613_((EntityType)traveler.m_6095_()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.m_36316_().getName();
        } else {
            string = traveler.m_7755_().getString();
        }
        String displayName = string;
        String uuid = traveler.m_20148_().toString();
        initialStargate.updateInterfaceBlocks(EVENT_DECONSTRUCTING_ENTITY, travelerType, displayName, uuid, disintegrated);
    }

    private void reconstructEvent(AbstractStargateEntity targetStargate, Entity traveler) {
        String string;
        String travelerType = EntityType.m_20613_((EntityType)traveler.m_6095_()).toString();
        if (traveler instanceof Player) {
            Player player = (Player)traveler;
            string = player.m_36316_().getName();
        } else {
            string = traveler.m_7755_().getString();
        }
        String displayName = string;
        String uuid = traveler.m_20148_().toString();
        targetStargate.updateInterfaceBlocks(EVENT_RECONSTRUCTING_ENTITY, travelerType, displayName, uuid);
    }

    private static void playWormholeSound(Level level, Entity traveler) {
        level.m_5594_((Player)null, traveler.m_20183_(), (SoundEvent)SoundInit.WORMHOLE_ENTER.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
    }
}

