/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.config.CommonIrisConfig;

public abstract class StargateIrisItem
extends Item {
    public static final ResourceLocation COPPER_IRIS = new ResourceLocation("sgjourney", "textures/entity/stargate/iris/copper_iris.png");
    public static final ResourceLocation IRON_IRIS = new ResourceLocation("sgjourney", "textures/entity/stargate/iris/iron_iris.png");
    public static final ResourceLocation GOLD_IRIS = new ResourceLocation("sgjourney", "textures/entity/stargate/iris/golden_iris.png");
    public static final ResourceLocation DIAMOND_IRIS = new ResourceLocation("sgjourney", "textures/entity/stargate/iris/diamond_iris.png");
    public static final ResourceLocation NETHERITE_IRIS = new ResourceLocation("sgjourney", "textures/entity/stargate/iris/netherite_iris.png");
    public static final ResourceLocation NAQUADAH_ALLOY_IRIS = new ResourceLocation("sgjourney", "textures/entity/stargate/iris/naquadah_alloy_iris.png");
    public static final ResourceLocation TRINIUM_IRIS = new ResourceLocation("sgjourney", "textures/entity/stargate/iris/trinium_iris.png");
    public static final ResourceLocation BRONZE_IRIS = new ResourceLocation("sgjourney", "textures/entity/stargate/iris/bronze_iris.png");
    public static final ResourceLocation STEEL_IRIS = new ResourceLocation("sgjourney", "textures/entity/stargate/iris/steel_iris.png");
    public static final String DURABILITY = "durability";
    public static final String TEXTURE = "texture";
    private ResourceLocation irisTexture;

    public StargateIrisItem(Item.Properties properties, ResourceLocation irisTexture) {
        super(properties);
        this.irisTexture = irisTexture;
    }

    public ResourceLocation getIrisTexture() {
        return this.irisTexture;
    }

    public abstract int getMaxDurability();

    public static boolean hasCustomTexture(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(TEXTURE);
    }

    @Nullable
    public static ResourceLocation getIrisTexture(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof StargateIrisItem) {
            StargateIrisItem irisItem = (StargateIrisItem)item;
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_(TEXTURE)) {
                String texture = tag.m_128461_(TEXTURE);
                if (ResourceLocation.m_135830_((String)texture)) {
                    return new ResourceLocation(texture);
                }
            } else {
                return irisItem.getIrisTexture();
            }
        }
        return null;
    }

    public static int getDurability(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof StargateIrisItem) {
            StargateIrisItem irisItem = (StargateIrisItem)item;
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_(DURABILITY)) {
                tag.m_128405_(DURABILITY, irisItem.getMaxDurability());
            }
            int durability = tag.m_128451_(DURABILITY);
            return durability;
        }
        return 0;
    }

    public static boolean decreaseDurability(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof StargateIrisItem) {
            StargateIrisItem irisItem = (StargateIrisItem)item;
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_(DURABILITY)) {
                tag.m_128405_(DURABILITY, irisItem.getMaxDurability());
            }
            int durability = tag.m_128451_(DURABILITY);
            tag.m_128405_(DURABILITY, --durability);
            if (durability >= 1) {
                return true;
            }
        }
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return StargateIrisItem.getDurability(stack) < this.getMaxDurability();
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)StargateIrisItem.getDurability(stack) / (float)this.getMaxDurability());
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)StargateIrisItem.getDurability(stack) / (float)this.getMaxDurability());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (stack.m_41782_() && isAdvanced.m_7050_()) {
            int durability = StargateIrisItem.getDurability(stack);
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.iris.durability").m_7220_((Component)Component.m_237113_((String)(": " + durability + " / " + this.getMaxDurability()))));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static class Steel
    extends StargateIrisItem {
        public Steel(Item.Properties properties) {
            super(properties, STEEL_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.steel_iris_durability.get();
        }
    }

    public static class Bronze
    extends StargateIrisItem {
        public Bronze(Item.Properties properties) {
            super(properties, BRONZE_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.bronze_iris_durability.get();
        }
    }

    public static class Trinium
    extends StargateIrisItem {
        public Trinium(Item.Properties properties) {
            super(properties, TRINIUM_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.trinium_iris_durability.get();
        }
    }

    public static class NaquadahAlloy
    extends StargateIrisItem {
        public NaquadahAlloy(Item.Properties properties) {
            super(properties, NAQUADAH_ALLOY_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.naquadah_alloy_iris_durability.get();
        }
    }

    public static class Netherite
    extends StargateIrisItem {
        public Netherite(Item.Properties properties) {
            super(properties, NETHERITE_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.netherite_iris_durability.get();
        }
    }

    public static class Diamond
    extends StargateIrisItem {
        public Diamond(Item.Properties properties) {
            super(properties, DIAMOND_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.diamond_iris_durability.get();
        }
    }

    public static class Gold
    extends StargateIrisItem {
        public Gold(Item.Properties properties) {
            super(properties, GOLD_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.gold_iris_durability.get();
        }
    }

    public static class Iron
    extends StargateIrisItem {
        public Iron(Item.Properties properties) {
            super(properties, IRON_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.iron_iris_durability.get();
        }
    }

    public static class Copper
    extends StargateIrisItem {
        public Copper(Item.Properties properties) {
            super(properties, COPPER_IRIS);
        }

        @Override
        public int getMaxDurability() {
            return (Integer)CommonIrisConfig.copper_iris_durability.get();
        }
    }
}

