/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.CommonTransmissionConfig;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundGDOOpenScreenPacket;
import net.povstalec.sgjourney.common.stargate.ITransmissionReceiver;

public class GDOItem
extends Item {
    public static final String IDC = "idc";
    public static final String FREQUENCY = "frequency";

    public GDOItem(Item.Properties properties) {
        super(properties);
    }

    public static void sendTransmission(Level level, Player player, ItemStack stack) {
        int roundedRadius = (int)Math.ceil(GDOItem.transmissionRadius() / 16.0f);
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = level.m_46865_(player.m_20097_().m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity blockEntity = level.m_7702_(pos);
                    if (blockEntity instanceof ITransmissionReceiver) {
                        ITransmissionReceiver receiver = (ITransmissionReceiver)blockEntity;
                        receiver.receiveTransmission(0, GDOItem.getFrequency(stack), GDOItem.getTransmissionMessage(stack));
                    }
                });
            }
        }
    }

    private static double distance2(BlockPos pos, BlockPos targetPos) {
        int x = Math.abs(targetPos.m_123341_() - pos.m_123341_());
        int y = Math.abs(targetPos.m_123342_() - pos.m_123342_());
        int z = Math.abs(targetPos.m_123343_() - pos.m_123343_());
        return x * x + y * y + z * z;
    }

    private static void checkShieldingState(Level level, Player player) {
        int roundedRadius = (int)Math.ceil(GDOItem.transmissionRadius() / 16.0f);
        BlockPos playerPos = player.m_20097_().m_7494_();
        ArrayList stargates = new ArrayList();
        for (int x = -roundedRadius; x <= roundedRadius; ++x) {
            for (int z = -roundedRadius; z <= roundedRadius; ++z) {
                ChunkAccess chunk = level.m_46865_(player.m_20097_().m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    AbstractStargateEntity stargate;
                    BlockEntity patt3080$temp = level.m_7702_(pos);
                    if (patt3080$temp instanceof AbstractStargateEntity && GDOItem.distance2(playerPos, (stargate = (AbstractStargateEntity)patt3080$temp).m_58899_()) <= (double)GDOItem.transmissionRadius2()) {
                        stargates.add(stargate);
                    }
                });
            }
        }
        if (stargates.size() == 0) {
            player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.gdo.error.no_nearby_stargate").m_130940_(ChatFormatting.RED), true);
            return;
        }
        stargates.sort((stargateA, stargateB) -> Double.valueOf(GDOItem.distance2(playerPos, stargateA.m_58899_())).compareTo(GDOItem.distance2(playerPos, stargateB.m_58899_())));
        AbstractStargateEntity stargate = (AbstractStargateEntity)stargates.get(0);
        if (!stargate.isConnected()) {
            player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.gdo.error.stargate_not_connected").m_130940_(ChatFormatting.RED), true);
            return;
        }
        int shieldingProgress = Math.round(stargate.checkConnectionShieldingState());
        ChatFormatting formatting = shieldingProgress == 0 ? ChatFormatting.DARK_GREEN : (shieldingProgress < 10 ? ChatFormatting.GREEN : (shieldingProgress < 50 ? ChatFormatting.YELLOW : (shieldingProgress < 70 ? ChatFormatting.GOLD : (shieldingProgress < 90 ? ChatFormatting.RED : ChatFormatting.DARK_RED))));
        player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.gdo.shielded").m_7220_((Component)Component.m_237113_((String)(": " + shieldingProgress + "%"))).m_130940_(formatting), true);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (level.m_5776_()) {
            return super.m_7203_(level, player, usedHand);
        }
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6144_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientboundGDOOpenScreenPacket(player.m_20148_(), usedHand == InteractionHand.MAIN_HAND, GDOItem.getTransmissionMessage(stack), GDOItem.getFrequency(stack)));
            return super.m_7203_(level, player, usedHand);
        }
        GDOItem.checkShieldingState(level, player);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int frequency = 0;
        String idc = "";
        if (stack.m_41782_() && isAdvanced.m_7050_()) {
            frequency = GDOItem.getFrequency(stack);
            idc = GDOItem.getTransmissionMessage(stack);
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.gdo.frequency").m_7220_((Component)Component.m_237113_((String)(": " + frequency))).m_130940_(ChatFormatting.YELLOW));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.gdo.idc").m_7220_((Component)Component.m_237113_((String)(": " + idc))).m_130940_(ChatFormatting.AQUA));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.gdo.description.check").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.gdo.description.gui").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static float transmissionRadius() {
        return ((Integer)CommonTransmissionConfig.max_gdo_transmission_distance.get()).intValue();
    }

    public static float transmissionRadius2() {
        return GDOItem.transmissionRadius() * GDOItem.transmissionRadius();
    }

    public static String getTransmissionMessage(ItemStack stack) {
        if (stack.m_41720_() instanceof GDOItem && stack.m_41783_() != null && stack.m_41783_().m_128441_(IDC)) {
            return stack.m_41783_().m_128461_(IDC);
        }
        return "";
    }

    public static int getFrequency(ItemStack stack) {
        if (stack.m_41720_() instanceof GDOItem && stack.m_41783_() != null && stack.m_41783_().m_128441_(FREQUENCY)) {
            return stack.m_41783_().m_128451_(FREQUENCY);
        }
        return 0;
    }

    public static void setFrequencyAndIDC(ItemStack stack, int frequency, String idc) {
        if (stack.m_41720_() instanceof GDOItem) {
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_(FREQUENCY, frequency);
            tag.m_128359_(IDC, idc);
        }
    }
}

