/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.stargate.Transporter;

public final class TransporterNetwork
extends SavedData {
    private static final String FILE_NAME = "sgjourney-transporter_network";
    private static final String DIMENSIONS = "Dimensions";
    private static final String CONNECTIONS = "Connections";
    private static final String VERSION = "Version";
    private static final int updateVersion = 1;
    private MinecraftServer server;
    private Map<String, Dimension> dimensions = new HashMap<String, Dimension>();
    private int version = 0;

    public final int getVersion() {
        return this.version;
    }

    private final void updateVersion() {
        this.version = 1;
    }

    public final void updateNetwork(MinecraftServer server) {
        if (this.getVersion() == 1) {
            StargateJourney.LOGGER.info("Transporter Network is up to date (Version: " + this.version + ")");
            return;
        }
        StargateJourney.LOGGER.info("Detected an incompatible Transporter Network version (Version: " + this.getVersion() + ") - updating to version 1");
        this.reloadNetwork(server, false);
    }

    public final void reloadNetwork(MinecraftServer server, boolean updateInterfaces) {
        this.eraseNetwork();
        StargateJourney.LOGGER.info("Transporter Network erased");
        this.addTransporters();
        StargateJourney.LOGGER.info("Transporters added");
        this.updateVersion();
        StargateJourney.LOGGER.info("Version updated");
        this.m_77762_();
    }

    public final void eraseNetwork() {
        this.dimensions.clear();
        this.m_77762_();
    }

    private final void addTransporters() {
        HashMap<UUID, Transporter> transporters = BlockEntityList.get(this.server).getTransporters();
        transporters.entrySet().stream().forEach(transporterInfo -> {
            Transporter transporter = (Transporter)transporterInfo.getValue();
            BlockEntity blockentity = this.server.m_129880_(transporter.getDimension()).m_7702_(transporter.getBlockPos());
            if (blockentity instanceof AbstractTransporterEntity) {
                AbstractTransporterEntity transporterEntity = (AbstractTransporterEntity)blockentity;
                if (transporterEntity.getID() != null && transporterEntity.getID().equals(transporter.getID())) {
                    this.addTransporterToDimension(transporter.getDimension(), transporter);
                } else {
                    BlockEntityList.get(this.server).removeTransporter(transporter.getID());
                    this.addTransporter(transporterEntity);
                }
            } else {
                BlockEntityList.get(this.server).removeTransporter(transporter.getID());
            }
        });
    }

    public final void addTransporter(AbstractTransporterEntity transporterEntity) {
        Optional<Transporter> transporterOptional = BlockEntityList.get(this.server).addTransporter(transporterEntity);
        if (transporterOptional.isPresent()) {
            Transporter transporter = transporterOptional.get();
            if (transporterEntity.getID() != null && transporterEntity.getID().equals(transporter.getID())) {
                this.addTransporterToDimension(transporter.getDimension(), transporter);
            }
        }
        this.m_77762_();
    }

    public final void removeTransporter(Level level, UUID id) {
        Optional<Transporter> transporter = this.getTransporter(id);
        if (transporter.isPresent()) {
            this.removeTransporterFromDimension((ResourceKey<Level>)level.m_46472_(), transporter.get());
        }
        BlockEntityList.get(level).removeTransporter(id);
        StargateJourney.LOGGER.info("Removed " + id.toString() + " from Transporter Network");
        this.m_77762_();
    }

    public final Optional<Transporter> getTransporter(UUID id) {
        Transporter transporter = BlockEntityList.get(this.server).getTransporters().get(id);
        if (transporter != null) {
            return Optional.of(transporter);
        }
        return Optional.empty();
    }

    public final void addTransporterToDimension(ResourceKey<Level> dimensionKey, Transporter transporter) {
        String dimensionString = dimensionKey.m_135782_().toString();
        if (!this.dimensions.containsKey(dimensionString)) {
            this.dimensions.put(dimensionString, new Dimension(dimensionKey));
        }
        this.dimensions.get(dimensionString).addTransporter(transporter);
    }

    public final void removeTransporterFromDimension(ResourceKey<Level> dimensionKey, Transporter transporter) {
        String dimensionString = dimensionKey.m_135782_().toString();
        if (this.dimensions.containsKey(dimensionString)) {
            this.dimensions.get(dimensionString).removeTransporter(transporter);
        }
    }

    public final Optional<List<Transporter>> getTransportersFromDimension(ResourceKey<Level> dimensionKey) {
        if (this.dimensions.containsKey(dimensionKey.m_135782_().toString())) {
            Dimension dimension = this.dimensions.get(dimensionKey.m_135782_().toString());
            return Optional.of(dimension.getTransporters());
        }
        return Optional.empty();
    }

    public final void printDimensions() {
        System.out.println("[Dimensions - Transporters]");
        this.dimensions.entrySet().stream().forEach(dimensionEntry -> ((Dimension)dimensionEntry.getValue()).printDimension());
    }

    private final CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(VERSION, this.version);
        tag.m_128365_(DIMENSIONS, (Tag)this.serializeDimensions());
        tag.m_128365_(CONNECTIONS, (Tag)this.serializeConnections());
        return tag;
    }

    private final CompoundTag serializeDimensions() {
        CompoundTag dimensionsTag = new CompoundTag();
        this.dimensions.forEach((dimensionString, dimension) -> dimensionsTag.m_128365_(dimensionString, (Tag)dimension.serialize()));
        return dimensionsTag;
    }

    private final CompoundTag serializeConnections() {
        CompoundTag connectionsTag = new CompoundTag();
        return connectionsTag;
    }

    private final void deserialize(CompoundTag tag) {
        this.version = tag.m_128451_(VERSION);
        this.deserializeDimensions(tag.m_128469_(DIMENSIONS));
        this.deserializeConnections(tag.m_128469_(CONNECTIONS));
    }

    private final void deserializeDimensions(CompoundTag tag) {
        tag.m_128431_().forEach(dimensionString -> this.dimensions.put((String)dimensionString, Dimension.deserialize(this.server, tag.m_128469_(dimensionString))));
    }

    private final void deserializeConnections(CompoundTag tag) {
    }

    public TransporterNetwork(MinecraftServer server) {
        this.server = server;
    }

    public static TransporterNetwork create(MinecraftServer server) {
        return new TransporterNetwork(server);
    }

    public static TransporterNetwork load(MinecraftServer server, CompoundTag tag) {
        TransporterNetwork data = TransporterNetwork.create(server);
        data.server = server;
        data.deserialize(tag);
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.serialize();
        return tag;
    }

    @Nonnull
    public static TransporterNetwork get(Level level) {
        if (level.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return TransporterNetwork.get(level.m_7654_());
    }

    @Nonnull
    public static TransporterNetwork get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (TransporterNetwork)storage.m_164861_(tag -> TransporterNetwork.load(server, tag), () -> TransporterNetwork.create(server), FILE_NAME);
    }

    private static class Dimension {
        private static final String DIMENSION = "Dimension";
        private static final String TRANSPORTERS = "Transporters";
        private final ResourceKey<Level> dimension;
        private List<Transporter> transporters = new ArrayList<Transporter>();

        private Dimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
        }

        private Dimension(ResourceKey<Level> dimension, List<Transporter> transporters) {
            this.dimension = dimension;
            this.transporters = transporters;
        }

        public void addTransporter(Transporter transporter) {
            if (this.transporters.contains(transporter)) {
                return;
            }
            this.transporters.add(transporter);
        }

        public void removeTransporter(Transporter transporter) {
            if (this.transporters.contains(transporter)) {
                this.transporters.remove(transporter);
            }
        }

        public List<Transporter> getTransporters() {
            return new ArrayList<Transporter>(this.transporters);
        }

        public void printDimension() {
            System.out.println("- [" + this.dimension.m_135782_().toString() + "]");
            this.transporters.stream().forEach(transporter -> System.out.println("--- " + transporter.toString()));
        }

        public CompoundTag serialize() {
            CompoundTag dimensionTag = new CompoundTag();
            dimensionTag.m_128359_(DIMENSION, this.dimension.m_135782_().toString());
            CompoundTag transportersTag = new CompoundTag();
            this.transporters.stream().forEach(transporter -> transportersTag.m_128359_(transporter.getID().toString(), transporter.getID().toString()));
            dimensionTag.m_128365_(TRANSPORTERS, (Tag)transportersTag);
            return dimensionTag;
        }

        public static Dimension deserialize(MinecraftServer server, CompoundTag dimensionTag) {
            ResourceKey<Level> dimension = Conversion.stringToDimension(dimensionTag.m_128461_(DIMENSION));
            ArrayList<Transporter> transporters = new ArrayList<Transporter>();
            dimensionTag.m_128469_(TRANSPORTERS).m_128431_().forEach(transporterID -> {
                Optional<Transporter> transporter = BlockEntityList.get(server).getTransporter(UUID.fromString(transporterID));
                if (transporter.isPresent()) {
                    transporters.add(transporter.get());
                }
            });
            return new Dimension(dimension, transporters);
        }
    }
}

