/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.energy.EnergyStorage;

public abstract class SGJourneyEnergy
extends EnergyStorage {
    protected long energy = 0L;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;

    public SGJourneyEnergy(long capacity, long maxReceive, long maxExtract) {
        super(SGJourneyEnergy.getRegularEnergy(capacity), SGJourneyEnergy.getRegularEnergy(maxReceive), SGJourneyEnergy.getRegularEnergy(maxExtract));
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return (int)this.receiveLongEnergy(maxReceive, simulate);
    }

    public long receiveLongEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        if (energyReceived != 0L) {
            this.onEnergyChanged(energyReceived, simulate);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return (int)this.extractLongEnergy(maxExtract, simulate);
    }

    public long extractLongEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        if (energyExtracted != 0L) {
            this.onEnergyChanged(energyExtracted, simulate);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return SGJourneyEnergy.getRegularEnergy(this.getTrueEnergyStored());
    }

    public long getTrueEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return SGJourneyEnergy.getRegularEnergy(this.getTrueMaxEnergyStored());
    }

    public long getTrueMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0L;
    }

    public boolean canReceive() {
        return this.maxReceive > 0L && this.energy < this.capacity;
    }

    public boolean canReceive(long receivedEnergy) {
        return this.energy + receivedEnergy <= this.capacity;
    }

    public long setEnergy(long energy) {
        this.energy = energy;
        return energy;
    }

    public abstract void onEnergyChanged(long var1, boolean var3);

    public long maxReceive() {
        return this.maxReceive;
    }

    public long maxExtract() {
        return this.maxExtract;
    }

    public Tag serializeNBT() {
        return LongTag.m_128882_((long)this.energy);
    }

    public void deserializeNBT(Tag nbt) {
        if (!(nbt instanceof LongTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        LongTag longTag = (LongTag)nbt;
        this.setEnergy(longTag.m_7046_());
    }

    public static int getRegularEnergy(long energy) {
        return energy > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)energy;
    }
}

