/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.CCTweakedCompatibility;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundPegasusStargateUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Stargate;
import org.jetbrains.annotations.NotNull;

public class PegasusStargateEntity
extends AbstractStargateEntity {
    public static final String ADDRESS_BUFFER = "AddressBuffer";
    public static final String SYMBOL_BUFFER = "SymbolBuffer";
    public static final String CURRENT_SYMBOL = "CurrentSymbol";
    public static final String DYNAMC_SYMBOLS = "DynamicSymbols";
    private final ResourceLocation backVariant = new ResourceLocation("sgjourney", "pegasus/pegasus_back_chevron");
    public int currentSymbol = 0;
    public Address addressBuffer = new Address(true);
    public int symbolBuffer = 0;
    private boolean passedOver = false;
    protected boolean dynamicSymbols = true;

    public PegasusStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.PEGASUS_STARGATE.get(), new ResourceLocation("sgjourney", "pegasus/pegasus"), pos, state, Stargate.Gen.GEN_3, 3);
        this.setOpenSoundLead(13);
        this.symbolBounds = 47;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isPointOfOriginValid(this.m_58904_())) {
            this.setPointOfOriginFromDimension((ResourceKey<Level>)this.m_58904_().m_46472_());
        }
        if (!this.areSymbolsValid(this.m_58904_())) {
            this.setSymbolsFromDimension((ResourceKey<Level>)this.m_58904_().m_46472_());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.addressBuffer.fromArray(tag.m_128465_(ADDRESS_BUFFER));
        this.symbolBuffer = tag.m_128451_(SYMBOL_BUFFER);
        this.currentSymbol = tag.m_128451_(CURRENT_SYMBOL);
        this.dynamicSymbols = tag.m_128471_(DYNAMC_SYMBOLS);
        if (!this.dynamicSymbols) {
            this.pointOfOrigin = tag.m_128461_("PointOfOrigin");
            this.symbols = tag.m_128461_("Symbols");
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128385_(ADDRESS_BUFFER, this.addressBuffer.toArray());
        tag.m_128405_(SYMBOL_BUFFER, this.symbolBuffer);
        tag.m_128405_(CURRENT_SYMBOL, this.currentSymbol);
        tag.m_128379_(DYNAMC_SYMBOLS, this.dynamicSymbols);
        if (!this.dynamicSymbols) {
            tag.m_128359_("PointOfOrigin", this.pointOfOrigin);
            tag.m_128359_("Symbols", this.symbols);
        }
    }

    @Override
    public ResourceLocation defaultVariant() {
        return ClientStargateConfig.pegasus_stargate_back_lights_up.get() ? this.backVariant : super.defaultVariant();
    }

    @Override
    public void updateDHD() {
        if (this.hasDHD()) {
            ((AbstractDHDEntity)((Object)this.dhd.get())).updateDHD(!this.isConnected() || this.isConnected() && this.isDialingOut() ? this.addressBuffer : new Address(), this.addressBuffer.hasPointOfOrigin() || this.isConnected());
        }
    }

    public void dynamicSymbols(boolean dynamicSymbols) {
        this.dynamicSymbols = dynamicSymbols;
        this.m_6596_();
    }

    public boolean useDynamicSymbols() {
        return this.dynamicSymbols;
    }

    @Override
    public Stargate.Feedback engageSymbol(int symbol) {
        if (this.f_58857_.m_5776_()) {
            return Stargate.Feedback.NONE;
        }
        if (this.isSymbolOutOfBounds(symbol)) {
            return Stargate.Feedback.SYMBOL_OUT_OF_BOUNDS;
        }
        if (this.isConnected()) {
            if (symbol == 0) {
                return this.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_DISCONNECT, true);
            }
            return this.setRecentFeedback(Stargate.Feedback.ENCODE_WHEN_CONNECTED);
        }
        if (this.addressBuffer.containsSymbol(symbol)) {
            return this.setRecentFeedback(Stargate.Feedback.SYMBOL_IN_ADDRESS);
        }
        if (this.addressBuffer.getLength() == this.getAddress().getLength() && !this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(this.f_58858_, false));
        }
        this.addressBuffer.addSymbol(symbol);
        return this.setRecentFeedback(Stargate.Feedback.SYMBOL_ENCODED);
    }

    @Override
    protected Stargate.Feedback lockPrimaryChevron() {
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(this.f_58858_, true));
        }
        return super.lockPrimaryChevron();
    }

    @Override
    public Stargate.Feedback encodeChevron(int symbol, boolean incoming, boolean encode) {
        ++this.symbolBuffer;
        this.passedOver = false;
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(this.f_58858_, true));
        }
        Stargate.Feedback feedback = super.encodeChevron(symbol, incoming, encode);
        if (this.addressBuffer.getLength() > this.getAddress().getLength() && !this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(this.f_58858_, false));
        }
        return this.setRecentFeedback(feedback);
    }

    public int getChevronPosition(int chevron) {
        if (chevron < 0 || chevron > 8) {
            return 0;
        }
        return 4 * this.getEngagedChevrons()[chevron - 1];
    }

    public int getCurrentSymbol() {
        return this.currentSymbol;
    }

    private void animateSpin() {
        if (!this.isConnected() && this.addressBuffer.getLength() > this.symbolBuffer) {
            int symbol = this.addressBuffer.getSymbol(this.symbolBuffer);
            if (symbol == 0) {
                if (this.currentSymbol == this.getChevronPosition(9)) {
                    this.lockPrimaryChevron();
                } else {
                    this.symbolWork();
                }
            } else if (this.currentSymbol == this.getChevronPosition(this.symbolBuffer + 1)) {
                if (this.symbolBuffer % 2 != 0 && !this.passedOver) {
                    this.passedOver = true;
                    this.symbolWork();
                } else {
                    this.encodeChevron(symbol, false, false);
                }
            } else {
                this.symbolWork();
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PegasusStargateEntity stargate) {
        if (level.m_5776_()) {
            return;
        }
        stargate.animateSpin();
        AbstractStargateEntity.tick(level, pos, state, stargate);
        stargate.updateClient();
    }

    @Override
    public void updateClient() {
        super.updateClient();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundPegasusStargateUpdatePacket(this.f_58858_, this.symbolBuffer, this.addressBuffer.toArray(), this.currentSymbol));
    }

    private void symbolWork() {
        this.currentSymbol = this.symbolBuffer % 2 == 0 ? --this.currentSymbol : ++this.currentSymbol;
        if (this.currentSymbol > 35) {
            this.currentSymbol = 0;
        } else if (this.currentSymbol < 0) {
            this.currentSymbol = 35;
        }
    }

    @Override
    protected void resetAddress(boolean updateInterfaces) {
        this.currentSymbol = 0;
        this.symbolBuffer = 0;
        this.addressBuffer.reset();
        super.resetAddress(updateInterfaces);
    }

    @Override
    public void playRotationSound() {
        this.stopRotationSound();
        this.spinSound.playSound();
    }

    @Override
    public void stopRotationSound() {
        this.spinSound.stopSound();
    }

    @Override
    public Stargate.ChevronLockSpeed getChevronLockSpeed() {
        return (Stargate.ChevronLockSpeed)((Object)CommonStargateConfig.pegasus_chevron_lock_speed.get());
    }

    @Override
    public void registerInterfaceMethods(StargatePeripheralWrapper wrapper) {
        CCTweakedCompatibility.registerPegasusStargateMethods(wrapper);
    }

    @Override
    public void doWhileDialed(int openTime, Stargate.ChevronLockSpeed chevronLockSpeed) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.currentSymbol >= 36) {
            return;
        }
        this.currentSymbol = openTime / chevronLockSpeed.getMultiplier();
        this.updateClient();
    }
}

