/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.blocks.CartoucheBlock;
import net.povstalec.sgjourney.common.data.Universe;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.packets.ClientboundCartoucheUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.AddressTable;
import org.jetbrains.annotations.NotNull;

public abstract class CartoucheEntity
extends BlockEntity {
    private static final String EMPTY = StargateJourney.EMPTY;
    public static final String ADDRESS_TABLE = "AddressTable";
    public static final String DIMENSION = "Dimension";
    public static final String SYMBOLS = "Symbols";
    public static final String ADDRESS = "Address";
    private String addressTable = EMPTY;
    private String dimension;
    private String symbols;
    private Address address = new Address();

    public CartoucheEntity(BlockEntityType<?> cartouche, BlockPos pos, BlockState state) {
        super(cartouche, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.addressTable != null && !this.addressTable.equals(EMPTY)) {
            this.setDimensionFromAddressTable();
        } else if (this.dimension == null) {
            this.setDimensionFromLevel(this.f_58857_);
        }
        if (this.symbols == null) {
            this.setSymbols(this.f_58857_);
        }
        if (this.address.isEmpty()) {
            this.setAddressFromDimension();
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ADDRESS_TABLE)) {
            this.addressTable = tag.m_128461_(ADDRESS_TABLE);
        }
        if (tag.m_128441_(DIMENSION)) {
            this.dimension = tag.m_128461_(DIMENSION);
        }
        if (tag.m_128441_(SYMBOLS)) {
            this.symbols = tag.m_128461_(SYMBOLS);
        }
        if (tag.m_128441_(ADDRESS)) {
            this.address.fromArray(tag.m_128465_(ADDRESS));
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        if (this.addressTable != null) {
            tag.m_128359_(ADDRESS_TABLE, this.addressTable);
        }
        if (this.dimension != null) {
            tag.m_128359_(DIMENSION, this.dimension);
        }
        if (this.symbols != null) {
            tag.m_128359_(SYMBOLS, this.symbols);
        }
        if (!this.address.isFromDimension()) {
            tag.m_128385_(ADDRESS, this.address.toArray());
        }
        super.m_183515_(tag);
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)(this.m_58899_().m_123341_() - 1), (double)this.m_58899_().m_123342_(), (double)(this.m_58899_().m_123343_() - 1), (double)(this.m_58899_().m_123341_() + 2), (double)(this.m_58899_().m_123342_() + 2), (double)(this.m_58899_().m_123343_() + 2));
    }

    public void setDimensionFromLevel(Level level) {
        if (level.m_5776_()) {
            return;
        }
        this.dimension = level.m_46472_().m_135782_().toString();
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public void setDimensionFromAddressTable() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        AddressTable addressTable = AddressTable.getAddressTable(this.f_58857_, ResourceLocation.m_135820_((String)this.addressTable));
        Optional<ResourceKey<Level>> dimension = AddressTable.getRandomDimension(this.f_58857_, addressTable);
        if (dimension.isPresent()) {
            this.dimension = dimension.get().m_135782_().toString();
        }
        this.addressTable = EMPTY;
    }

    public void setAddressFromDimension() {
        this.address.fromDimension((ServerLevel)this.f_58857_, Conversion.stringToDimension(this.dimension));
    }

    public void setSymbols(Level level) {
        if (level.m_5776_()) {
            return;
        }
        this.symbols = Universe.get(level).getSymbols((ResourceKey<Level>)level.m_46472_()).m_135782_().toString();
    }

    public void setSymbols(String symbols) {
        this.symbols = symbols;
    }

    public String getSymbols() {
        return this.symbols;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    protected void updateClient() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        int[] address = this.addressTable.equals(EMPTY) ? this.address.toArray() : new int[]{};
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundCartoucheUpdatePacket(this.f_58858_, this.symbols, address));
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (state.m_61143_(CartoucheBlock.HALF) == DoubleBlockHalf.LOWER) {
            this.updateClient();
        }
    }

    public static class RedSandstone
    extends CartoucheEntity {
        public RedSandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.RED_SANDSTONE_CARTOUCHE.get(), pos, state);
        }
    }

    public static class Sandstone
    extends CartoucheEntity {
        public Sandstone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.SANDSTONE_CARTOUCHE.get(), pos, state);
        }
    }

    public static class Stone
    extends CartoucheEntity {
        public Stone(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.STONE_CARTOUCHE.get(), pos, state);
        }
    }
}

