/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.qol;

import com.railwayteam.railways.content.buffer.TrackBufferBlockEntity;
import com.railwayteam.railways.content.coupling.coupler.SecondaryTrackTargetingBehaviour;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.utility.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableInt;

@OnlyIn(value=Dist.CLIENT)
public class TrackEdgePointHighlighter {
    private static final ArrayList<HolderSet> HOLDERS = new ArrayList();

    public static void clientTick(Minecraft mc) {
        BlockHitResult blockHit;
        BlockPos pos;
        BlockEntity be;
        HitResult hitResult;
        LocalPlayer player = mc.f_91074_;
        if (player == null || !EntityUtils.isHoldingItem((Player)player, item -> item instanceof WrenchItem)) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        if (level != null && (hitResult = mc.f_91077_) instanceof BlockHitResult && !TrackEdgePointHighlighter.showOutlinesFrom(be = level.m_7702_(pos = (blockHit = (BlockHitResult)hitResult).m_82425_()), pos, 0)) {
            TrackBlockOutline.BezierPointSelection bezier;
            BlockState state = level.m_8055_(pos);
            Vec3 lookAngle = player.m_20154_();
            TrackGraphLocation loc = null;
            Block block = state.m_60734_();
            if (block instanceof ITrackBlock) {
                ITrackBlock track = (ITrackBlock)block;
                loc = TrackGraphHelper.getGraphLocationAt((Level)level, (BlockPos)pos, (Direction.AxisDirection)((Direction.AxisDirection)track.getNearestTrackAxis((BlockGetter)level, pos, state, lookAngle).getSecond()), (Vec3)((Vec3)track.getTrackAxes((BlockGetter)level, pos, state).get(0)));
            }
            if (loc == null && (bezier = TrackBlockOutline.result) != null) {
                loc = TrackGraphHelper.getBezierGraphLocationAt((Level)level, (BlockPos)bezier.blockEntity().m_58899_(), (Direction.AxisDirection)(lookAngle.m_82526_(bezier.direction()) < 0.0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE), (BezierTrackPointLocation)bezier.loc());
            }
            if (loc != null) {
                TrackGraph graph = loc.graph;
                TrackNode node1 = graph.locateNode((TrackNodeLocation)loc.edge.getFirst());
                TrackNode node2 = graph.locateNode((TrackNodeLocation)loc.edge.getSecond());
                TrackEdge edge = (TrackEdge)graph.getConnectionsFrom(node1).get(node2);
                if (edge == null) {
                    return;
                }
                TrackGraphLocation finalLoc = loc;
                edge.getEdgeData().getPoints().stream().sorted((a, b) -> {
                    double distA = Math.abs(a.getLocationOn(edge) - finalLoc.position);
                    double distB = Math.abs(b.getLocationOn(edge) - finalLoc.position);
                    return Double.compare(distA, distB);
                }).filter(point -> Math.abs(point.getLocationOn(edge) - finalLoc.position) <= 0.5).limit(1L).forEach(point -> {
                    SingleBlockEntityEdgePoint single;
                    if (point instanceof SingleBlockEntityEdgePoint && (single = (SingleBlockEntityEdgePoint)point).getBlockEntityPos() != null) {
                        TrackEdgePointHighlighter.showOutlinesFrom(mc.f_91073_.m_7702_(single.getBlockEntityPos()), single.getBlockEntityPos(), 0);
                    } else if (point instanceof SignalBoundary) {
                        SignalBoundary signal = (SignalBoundary)point;
                        MutableInt index = new MutableInt(0);
                        signal.blockEntities.forEach(positions -> positions.keySet().forEach(pos2 -> {
                            if (pos2 != null) {
                                TrackEdgePointHighlighter.showOutlinesFrom(mc.f_91073_.m_7702_(pos2), pos2, index.getAndAdd(1));
                            }
                        }));
                    }
                });
            }
        }
    }

    private static boolean showOutlinesFrom(BlockEntity be, BlockPos pos, int index) {
        HolderSet holder;
        if (be instanceof TrackBufferBlockEntity) {
            return false;
        }
        if (HOLDERS.size() <= index) {
            holder = new HolderSet();
            HOLDERS.add(holder);
        } else {
            holder = HOLDERS.get(index);
        }
        TrackTargetingBehaviour trackTarget1 = (TrackTargetingBehaviour)TrackTargetingBehaviour.get((BlockEntity)be, (BehaviourType)TrackTargetingBehaviour.TYPE);
        if (trackTarget1 != null) {
            AABB aa = new AABB(pos).m_82400_(0.03125);
            CreateClient.OUTLINER.chaseAABB(holder.BLOCK_BOX, aa).colored(Color.SPRING_GREEN).lineWidth(0.0625f);
            AABB bb = new AABB(trackTarget1.getPositionForMapMarker()).m_82310_(0.0, 0.625, 0.0);
            CreateClient.OUTLINER.chaseAABB(holder.TRACK_BOX, bb).colored(Color.SPRING_GREEN).lineWidth(0.0625f);
            CreateClient.OUTLINER.showLine(holder.CONNECTOR, aa.m_82399_(), bb.m_82399_()).colored(Color.SPRING_GREEN).lineWidth(0.0625f);
            SecondaryTrackTargetingBehaviour trackTarget2 = (SecondaryTrackTargetingBehaviour)SecondaryTrackTargetingBehaviour.get((BlockEntity)be, SecondaryTrackTargetingBehaviour.TYPE);
            if (trackTarget2 != null) {
                AABB cc = new AABB(trackTarget2.getGlobalPosition()).m_82310_(0.0, 0.625, 0.0);
                CreateClient.OUTLINER.chaseAABB(holder.TRACK_BOX2, cc).colored(Color.GREEN).lineWidth(0.0625f);
                CreateClient.OUTLINER.showLine(holder.CONNECTOR2, bb.m_82399_(), cc.m_82399_()).colored(Color.GREEN).lineWidth(0.0625f);
            }
            return true;
        }
        return false;
    }

    private static class HolderSet {
        final Object BLOCK_BOX = new Object();
        final Object CONNECTOR = new Object();
        final Object TRACK_BOX = new Object();
        final Object CONNECTOR2 = new Object();
        final Object TRACK_BOX2 = new Object();

        private HolderSet() {
        }
    }
}

