/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.data;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.gui.stats.bar.GuiStatIndicator;
import se.mickelus.tetra.gui.stats.data.StatRegistry;

public class StatIndicatorStore
implements ResourceManagerReloadListener {
    private static final Logger logger = LogManager.getLogger();
    public static StatIndicatorStore instance;
    private Map<ResourceLocation, GuiStatIndicator> indicators = Collections.emptyMap();

    public StatIndicatorStore() {
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)this);
        instance = this;
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.indicators = StatIndicatorStore.prepareIndicators();
    }

    public GuiStatIndicator[] getIndicatorsIn(ResourceLocation resourceLocation) {
        return (GuiStatIndicator[])this.indicators.entrySet().stream().filter(entry -> resourceLocation.m_135827_().equals(((ResourceLocation)entry.getKey()).m_135827_()) && ((ResourceLocation)entry.getKey()).m_135815_().startsWith(resourceLocation.m_135815_())).map(Map.Entry::getValue).toArray(GuiStatIndicator[]::new);
    }

    private static Map<ResourceLocation, GuiStatIndicator> prepareIndicators() {
        return Minecraft.m_91087_().m_91098_().m_214159_("stat_indicators", rl -> rl.m_135815_().endsWith(".json")).entrySet().stream().filter(entry -> "tetra".equals(((ResourceLocation)entry.getKey()).m_135827_())).map(entry -> Pair.of((Object)StatIndicatorStore.trimResourceLocation((ResourceLocation)entry.getKey()), (Object)((Object)StatIndicatorStore.parseBar((ResourceLocation)entry.getKey(), (Resource)entry.getValue())))).filter(pair -> pair.getRight() != null).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private static ResourceLocation trimResourceLocation(ResourceLocation resourceLocation) {
        return new ResourceLocation(resourceLocation.m_135827_(), resourceLocation.m_135815_().substring(16));
    }

    @Nullable
    private static GuiStatIndicator parseBar(ResourceLocation resourceLocation, Resource resource) {
        GuiStatIndicator guiStatIndicator;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                guiStatIndicator = (GuiStatIndicator)((Object)GsonHelper.m_13776_((Gson)StatRegistry.gson, (Reader)reader, GuiStatIndicator.class));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    logger.warn("Failed to parse stat indicator from '{}': {}", (Object)resourceLocation, (Object)e);
                    return null;
                }
            }
            reader.close();
        }
        return guiStatIndicator;
    }
}

