/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.chthonic;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockTile;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;

@ParametersAreNonnullByDefault
public class FracturedBedrockBlock
extends TetraBlock
implements EntityBlock {
    public static final String identifier = "fractured_bedrock";
    @ObjectHolder(registryName="block", value="tetra:fractured_bedrock")
    public static FracturedBedrockBlock instance;

    public FracturedBedrockBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(-1.0f, 3600000.0f).m_222994_());
    }

    public static boolean canPierce(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return Blocks.f_50752_.equals(blockState.m_60734_()) || blockState.m_60713_((Block)SeepingBedrockBlock.instance) && !SeepingBedrockBlock.isActive(blockState);
    }

    public static void pierce(Level world, BlockPos pos, int amount) {
        FracturedBedrockTile tile = TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, FracturedBedrockTile.class).orElse(null);
        if (tile == null && FracturedBedrockBlock.canPierce(world, pos)) {
            BlockState blockState = world.m_8055_(pos);
            world.m_7731_(pos, instance.m_49966_(), 2);
            tile = TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, FracturedBedrockTile.class).orElse(null);
            if (!world.f_46443_) {
                tile.updateLuck();
            }
        }
        if (tile != null) {
            tile.activate(amount);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FracturedBedrockTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return FracturedBedrockBlock.getTicker(entityType, FracturedBedrockTile.type, (lvl, pos, blockState, tile) -> tile.tick(lvl, pos, blockState));
    }
}

