/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.chthonic;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockTile;

@ParametersAreNonnullByDefault
public class ExtractorProjectileEntity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    public static final String unlocalizedName = "extractor_projectile";
    public static final String damageKey = "dmg";
    public static final String heatKey = "heat";
    @ObjectHolder(registryName="entity_type", value="tetra:extractor_projectile")
    public static EntityType<ExtractorProjectileEntity> type;
    private int damage;
    private int heat;
    private boolean extinguishing = false;

    public ExtractorProjectileEntity(Level world, LivingEntity shooter, ItemStack itemStack) {
        super(type, shooter, world);
        this.damage = itemStack.m_41773_();
        this.m_36740_(SoundEvents.f_12201_);
        this.m_36781_(0.5);
        this.m_36735_(3);
        this.m_36767_((byte)127);
    }

    public ExtractorProjectileEntity(EntityType<? extends ExtractorProjectileEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_36781_(0.5);
        this.m_36735_(3);
        this.m_36767_((byte)127);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ExtractorProjectileEntity(Level worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
        this.m_36781_(0.5);
        this.m_36735_(3);
        this.m_36767_((byte)127);
    }

    public ExtractorProjectileEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super(type, worldIn);
        this.m_36781_(0.5);
        this.m_36735_(3);
        this.m_36767_((byte)127);
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    protected void m_6532_(HitResult rayTraceResult) {
        if (!this.m_9236_().f_46443_ && rayTraceResult.m_6662_() == HitResult.Type.BLOCK && this.m_20184_().m_82556_() > 0.95) {
            ServerPlayer shooter = CastOptional.cast((Object)this.m_19749_(), ServerPlayer.class).orElse(null);
            BlockPos pos = ((BlockHitResult)rayTraceResult).m_82425_();
            if (shooter != null && this.breakBlock(this.m_9236_(), pos, shooter)) {
                this.breakAround(this.m_9236_(), pos, ((BlockHitResult)rayTraceResult).m_82434_(), shooter);
                this.m_20256_(this.m_20184_().m_82490_((double)0.95f));
                this.hitAdditional();
                return;
            }
        }
        super.m_6532_(rayTraceResult);
    }

    private void hitAdditional() {
        Vec3 position = this.m_20182_();
        Vec3 target = position.m_82549_(this.m_20184_());
        BlockHitResult rayTraceResult = this.m_9236_().m_45547_(new ClipContext(position, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)rayTraceResult)) {
            this.m_6532_((HitResult)rayTraceResult);
        }
    }

    private void breakAround(Level world, BlockPos pos, Direction face, ServerPlayer shooter) {
        Vec3i axis1 = RotationHelper.shiftAxis((Vec3i)face.m_122436_());
        Vec3i axis2 = RotationHelper.shiftAxis((Vec3i)axis1);
        ServerScheduler.schedule(2, () -> {
            this.breakBlock(world, pos.m_121955_(axis1), shooter);
            this.breakBlock(world, pos.m_121996_(axis1), shooter);
        });
        ServerScheduler.schedule(4, () -> {
            this.breakBlock(world, pos.m_121955_(axis2), shooter);
            this.breakBlock(world, pos.m_121996_(axis2), shooter);
        });
        ServerScheduler.schedule(6, () -> {
            this.breakBlock(world, pos.m_121955_(axis1).m_121955_(axis2), shooter);
            this.breakBlock(world, pos.m_121996_(axis1).m_121996_(axis2), shooter);
        });
        ServerScheduler.schedule(8, () -> {
            this.breakBlock(world, pos.m_121955_(axis1).m_121996_(axis2), shooter);
            this.breakBlock(world, pos.m_121996_(axis1).m_121955_(axis2), shooter);
        });
    }

    private boolean breakBlock(Level world, BlockPos pos, ServerPlayer shooter) {
        ServerLevel serverWorld = (ServerLevel)world;
        GameType gameType = shooter.f_8941_.m_9290_();
        BlockState blockState = world.m_8055_(pos);
        BlockEntity tileEntity = world.m_7702_(pos);
        if (blockState.m_60800_((BlockGetter)world, pos) != -1.0f && this.m_6084_() && !shooter.m_36187_(world, pos, gameType) && blockState.m_204336_(FracturedBedrockTile.extractorBreakable) && blockState.m_60734_().onDestroyedByPlayer(blockState, world, pos, (Player)shooter, true, world.m_6425_(pos)) && ForgeHooks.onBlockBreakEvent((Level)world, (GameType)gameType, (ServerPlayer)shooter, (BlockPos)pos) != -1) {
            blockState.m_60734_().m_6240_(world, (Player)shooter, pos, blockState, tileEntity, ItemStack.f_41583_);
            blockState.m_60734_().m_6786_((LevelAccessor)world, pos, blockState);
            world.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)blockState));
            ++this.damage;
            this.heat += 10;
            int exp = blockState.getExpDrop((LevelReader)world, world.m_213780_(), pos, 0, 0);
            if (exp > 0) {
                blockState.m_60734_().m_49805_(serverWorld, pos, exp);
            }
            if (this.damage > 1024) {
                this.destroyExtractor();
            }
            return true;
        }
        return false;
    }

    private void destroyExtractor() {
        this.m_146870_();
        this.m_9236_().m_255391_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, true, Level.ExplosionInteraction.TNT);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_20096_() && this.heat > 0) {
                int cooldown;
                int n = cooldown = this.m_20069_() ? 10 : 1;
                if (this.f_19797_ % 10 == 0) {
                    Vec3 pos = this.m_20182_().m_82549_(this.m_20154_().m_82490_(-Math.random()));
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_, pos.f_82480_, pos.f_82481_, cooldown, 0.0, 0.01, 0.0, 0.01);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, pos.f_82479_, pos.f_82480_ + 0.1, pos.f_82481_, 1, 0.0, 0.01, 0.0, 0.01);
                }
                if (cooldown > 1 && !this.extinguishing) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 0.2f, 0.9f);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123778_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 12, 0.0, 0.01, 0.0, 0.01);
                    this.extinguishing = true;
                }
                this.heat -= cooldown;
            } else if (this.f_19797_ % 40 == 0) {
                Vec3 pos = this.m_20182_().m_82549_(this.m_20154_().m_82490_(-Math.random()));
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.01, 0.0, 0.01);
            }
        }
    }

    public boolean m_20096_() {
        return this.f_36704_ > 0;
    }

    protected ItemStack m_7941_() {
        if (this.damage == 0) {
            return new ItemStack((ItemLike)ChthonicExtractorBlock.item);
        }
        ItemStack itemStack = new ItemStack((ItemLike)ChthonicExtractorBlock.usedItem);
        itemStack.m_41721_(this.damage);
        return itemStack;
    }

    protected void m_8060_(BlockHitResult rayTraceResult) {
        super.m_8060_(rayTraceResult);
        this.m_36740_(SoundEvents.f_12201_);
    }

    protected void m_5790_(EntityHitResult rayTraceResult) {
        super.m_5790_(rayTraceResult);
        this.m_20256_(this.m_20184_().m_82541_().m_82490_(-0.1));
    }

    protected boolean m_5603_(Entity entity) {
        return !type.equals((Object)entity.m_6095_()) && super.m_5603_(entity);
    }

    public void m_6123_(Player player) {
        if (this.f_36703_) {
            super.m_6123_(player);
            if (!this.m_6084_()) {
                this.ignitePlayer(player);
            }
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && this.m_20096_() && this.m_6084_() && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
            ItemStack itemStack = this.m_7941_();
            boolean success = false;
            if (player.m_21205_().m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                success = true;
            } else if (player.m_21206_().m_41619_()) {
                player.m_21008_(InteractionHand.OFF_HAND, itemStack);
                success = true;
            } else if (player.m_150109_().m_36054_(itemStack)) {
                success = true;
            }
            if (success) {
                player.m_7938_((Entity)this, 1);
                this.ignitePlayer(player);
                this.m_146870_();
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_7111_(player, vec, hand);
    }

    private void ignitePlayer(Player player) {
        if (!this.m_6084_() && this.heat > 10) {
            player.m_20254_(3 + this.heat / 20);
        }
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
            super.m_6901_();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.damage = compound.m_128451_(damageKey);
        this.heat = compound.m_128451_(heatKey);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_(damageKey, this.damage);
        compound.m_128405_(heatKey, this.heat);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.damage);
        buffer.writeInt(this.heat);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.damage = buffer.readInt();
        this.heat = buffer.readInt();
    }
}

