/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config;

import me.wesley1808.servercore.common.config.Copyable;
import me.wesley1808.servercore.common.config.data.CommandConfig;
import me.wesley1808.servercore.common.config.data.FeatureConfig;
import me.wesley1808.servercore.common.config.data.activation_range.ActivationRangeConfig;
import me.wesley1808.servercore.common.config.data.breeding_cap.BreedingCapConfig;
import me.wesley1808.servercore.common.config.data.dynamic.DynamicConfig;
import me.wesley1808.servercore.common.config.data.mob_spawning.MobSpawnConfig;
import me.wesley1808.servercore.common.config.impl.MainConfigImpl;
import space.arim.dazzleconf.annote.ConfComments;
import space.arim.dazzleconf.annote.ConfHeader;
import space.arim.dazzleconf.annote.ConfKey;
import space.arim.dazzleconf.annote.SubSection;
import space.arim.dazzleconf.sorter.AnnotationBasedSorter;

@ConfHeader(value={"The main configuration file for ServerCore.", "Most of these settings can be reloaded without restarting using /servercore reload.\n"})
public interface MainConfig
extends Copyable {
    @AnnotationBasedSorter.Order(value=1)
    @SubSection
    @ConfKey(value="features")
    @ConfComments(value={"Most miscellaneous feature toggles."})
    public FeatureConfig features();

    @AnnotationBasedSorter.Order(value=2)
    @SubSection
    @ConfKey(value="dynamic")
    @ConfComments(value={"Automatically modifies dynamic settings based on the server performance."})
    public DynamicConfig dynamic();

    @AnnotationBasedSorter.Order(value=3)
    @SubSection
    @ConfKey(value="breeding-cap")
    @ConfComments(value={"A special mobcap that only affects the breeding of animals and villagers."})
    public BreedingCapConfig breedingCap();

    @AnnotationBasedSorter.Order(value=4)
    @SubSection
    @ConfKey(value="mob-spawning")
    @ConfComments(value={"Gives more control over mob spawning."})
    public MobSpawnConfig mobSpawning();

    @AnnotationBasedSorter.Order(value=5)
    @SubSection
    @ConfKey(value="commands")
    @ConfComments(value={"Settings for commands and their formatting."})
    public CommandConfig commands();

    @AnnotationBasedSorter.Order(value=6)
    @SubSection
    @ConfKey(value="activation-range")
    @ConfComments(value={"Activation range can drastically reduce the amount of lag caused by ticking entities.", "It does this by cleverly skipping certain entity ticks based on the distance to players and other factors, like immunity checks.", "Immunity checks determine whether an entity should be ticked even when it's outside the activation range, like for example when it is falling or takes damage.", "Note: while this is a very powerful feature, it can still slow down mobfarms and break very specific technical contraptions."})
    public ActivationRangeConfig activationRange();

    @Override
    default public MainConfig optimizedCopy() {
        return new MainConfigImpl(this);
    }
}

