/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.monster.SkeletonDruid;
import twilightforest.init.TFEntities;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFSounds;
import twilightforest.util.LegacyLandmarkPlacements;

public class SwarmSpider
extends Spider {
    protected boolean shouldSpawn = false;

    public SwarmSpider(EntityType<? extends SwarmSpider> type, Level world) {
        this(type, world, true);
    }

    public SwarmSpider(EntityType<? extends SwarmSpider> type, Level world, boolean spawnMore) {
        super(type, world);
        this.setSpawnMore(spawnMore);
        this.f_21364_ = 2;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Spider.m_33815_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.f_25345_.removeIf(t -> t.m_26015_() instanceof MeleeAttackGoal);
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            protected double m_6639_(LivingEntity attackTarget) {
                return 4.0f + attackTarget.m_20205_();
            }
        });
        this.f_21346_.f_25345_.removeIf(t -> t.m_26012_() == 2 && t.m_26015_() instanceof NearestAttackableTargetGoal);
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.SWARM_SPIDER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)TFSounds.SWARM_SPIDER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.SWARM_SPIDER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)TFSounds.SWARM_SPIDER_STEP.get(), 0.15f, 1.0f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 0.3f;
    }

    public double m_6049_() {
        return 0.15;
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_() && this.shouldSpawnMore()) {
            int more = 1 + this.m_217043_().m_188503_(2);
            for (int i = 0; i < more; ++i) {
                if (this.spawnAnother()) continue;
                this.spawnAnother();
            }
            this.setSpawnMore(false);
        }
        super.m_8119_();
    }

    public boolean m_7327_(Entity entity) {
        return this.m_217043_().m_188503_(4) == 0 && super.m_7327_(entity);
    }

    protected boolean spawnAnother() {
        SwarmSpider another = new SwarmSpider((EntityType<? extends SwarmSpider>)((EntityType)TFEntities.SWARM_SPIDER.get()), this.m_9236_(), false);
        double sx = this.m_20185_() + (this.m_217043_().m_188499_() ? 0.9 : -0.9);
        double sy = this.m_20186_();
        double sz = this.m_20189_() + (this.m_217043_().m_188499_() ? 0.9 : -0.9);
        another.m_7678_(sx, sy, sz, this.m_217043_().m_188501_() * 360.0f, 0.0f);
        if (!another.m_5545_((LevelAccessor)this.m_9236_(), MobSpawnType.MOB_SUMMONED)) {
            another.m_146870_();
            return false;
        }
        this.m_9236_().m_7967_((Entity)another);
        another.m_21373_();
        return true;
    }

    public static boolean getCanSpawnHere(EntityType<? extends SwarmSpider> entity, ServerLevelAccessor accessor, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return accessor.m_46791_() != Difficulty.PEACEFUL && SwarmSpider.isValidLightLevel(accessor, pos, random) && SwarmSpider.m_217057_(entity, (LevelAccessor)accessor, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isValidLightLevel(ServerLevelAccessor accessor, BlockPos pos, RandomSource random) {
        int chunkZ;
        int chunkX = Mth.m_14143_((float)pos.m_123341_()) >> 4;
        return LegacyLandmarkPlacements.getNearestLandmark(chunkX, chunkZ = Mth.m_14143_((float)pos.m_123343_()) >> 4, (WorldGenLevel)accessor.m_6018_()) == TFLandmark.HEDGE_MAZE || Monster.m_219009_((ServerLevelAccessor)accessor, (BlockPos)pos, (RandomSource)random);
    }

    public boolean shouldSpawnMore() {
        return this.shouldSpawn;
    }

    public void setSpawnMore(boolean flag) {
        this.shouldSpawn = flag;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("SpawnMore", this.shouldSpawnMore());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSpawnMore(compound.m_128471_("SpawnMore"));
    }

    public float m_6100_() {
        return (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.5f;
    }

    public int m_5792_() {
        return 6;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingData, @Nullable CompoundTag dataTag) {
        livingData = super.m_6518_(accessor, difficulty, reason, livingData, dataTag);
        if (this.m_146895_() != null || accessor.m_213780_().m_188503_(20) <= difficulty.m_19048_().m_19028_()) {
            SkeletonDruid druid = (SkeletonDruid)((EntityType)TFEntities.SKELETON_DRUID.get()).m_20615_(this.m_9236_());
            druid.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            druid.m_6863_(true);
            ForgeEventFactory.onFinalizeSpawn((Mob)druid, (ServerLevelAccessor)accessor, (DifficultyInstance)difficulty, (MobSpawnType)MobSpawnType.JOCKEY, null, null);
            if (this.m_146862_(e -> true)) {
                this.m_20153_();
            }
            druid.m_20329_((Entity)this);
        }
        return livingData;
    }
}

