/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TwilightForestMod;
import twilightforest.block.KeepsakeCasketBlock;
import twilightforest.block.entity.KeepsakeCasketBlockEntity;
import twilightforest.client.model.TFModelLayers;
import twilightforest.init.TFBlocks;

@OnlyIn(value=Dist.CLIENT)
public class CasketTileEntityRenderer<T extends KeepsakeCasketBlockEntity>
implements BlockEntityRenderer<T> {
    public final ModelPart base;
    public final ModelPart lid;

    public CasketTileEntityRenderer(BlockEntityRendererProvider.Context renderer) {
        ModelPart root = renderer.m_173582_(TFModelLayers.KEEPSAKE_CASKET);
        this.base = root.m_171324_("base");
        this.lid = root.m_171324_("lid");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -13.0f, 16.0f, 10.0f, 14.0f).m_171514_(0, 46).m_171481_(-8.0f, -10.0f, -13.0f, 16.0f, 2.0f, 0.0f).m_171514_(2, 34).m_171481_(-7.99f, -10.0f, -12.0f, 0.0f, 2.0f, 14.0f).m_171514_(2, 36).m_171481_(7.99f, -10.0f, -12.0f, 0.0f, 2.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)6.0f));
        partdefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(1, 28).m_171481_(-7.0f, -10.0f, -2.0f, 14.0f, 10.0f, 8.0f).m_171514_(0, 26).m_171481_(-7.0f, -10.0f, -6.0f, 1.0f, 6.0f, 4.0f).m_171514_(40, 26).m_171481_(6.0f, -10.0f, -6.0f, 1.0f, 6.0f, 4.0f).m_171514_(0, 56).m_171481_(-7.0f, -4.0f, -6.0f, 14.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-0.01f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level world = tileEntityIn.m_58904_();
        boolean flag = world != null;
        BlockState blockstate = flag ? tileEntityIn.m_58900_() : ((Block)TFBlocks.KEEPSAKE_CASKET.get()).m_49966_();
        Block block = blockstate.m_60734_();
        if (block instanceof KeepsakeCasketBlock) {
            int damage = (Integer)blockstate.m_61143_((Property)KeepsakeCasketBlock.BREAKAGE);
            Direction facing = (Direction)blockstate.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.0, 0.5);
            matrixStackIn.m_252781_(facing.m_253075_());
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = DoubleBlockCombiner.Combiner::m_6502_;
            float f1 = ((Float2FloatFunction)icallbackwrapper.m_5649_(KeepsakeCasketBlock.getLidRotationCallback(tileEntityIn))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            ResourceLocation CASKET = TwilightForestMod.getModelTexture("casket/keepsake_casket_" + damage + ".png");
            this.renderModels(matrixStackIn, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)CASKET)), this.lid, this.base, f1, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
        }
    }

    private void renderModels(PoseStack matrixStackIn, VertexConsumer bufferIn, ModelPart lid, ModelPart base, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        lid.f_104203_ = -(lidAngle * 1.5707964f);
        lid.m_104301_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        base.m_104301_(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }
}

