/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.azure;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zigythebird.multiloaderutils.utils.Platform;
import com.zigythebird.playeranimatorapi.azure.AnimatablePlayerLayer;
import com.zigythebird.playeranimatorapi.azure.PlayerAnimationModel;
import com.zigythebird.playeranimatorapi.compatibility.PehkuiCompat;
import com.zigythebird.playeranimatorapi.misc.GetModelRendererInterface;
import com.zigythebird.playeranimatorapi.misc.PlayerModelInterface;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.renderer.GeoObjectRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class PlayerAnimationRenderer<T extends AnimatablePlayerLayer>
extends GeoObjectRenderer<T>
implements PlayerModelInterface {
    public PlayerModel playerModel;

    public PlayerAnimationRenderer() {
        super(new PlayerAnimationModel());
    }

    public PlayerAnimationRenderer(GeoModel<T> model) {
        super(model);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.objectRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        poseStack.m_85836_();
        if (Platform.isModLoaded((String)"pehkui")) {
            Vec2 scale = PehkuiCompat.getScale(((AnimatablePlayerLayer)animatable).getPlayer(), partialTick);
            poseStack.m_85841_(scale.f_82470_, scale.f_82471_, scale.f_82470_);
        }
        this.setupAnim(this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(animatable)));
        poseStack.m_85849_();
    }

    public void render(PoseStack poseStack, T animatable, @Nullable MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, int packedLight) {
        if (this.playerModel != null) {
            ((GetModelRendererInterface)this.playerModel).playeranimatorapi$setRenderer(this);
        }
        if (renderType == null) {
            renderType = RenderType.m_110473_((ResourceLocation)this.model.getTextureResource(animatable));
        }
        super.render(poseStack, animatable, bufferSource, renderType, buffer, packedLight);
    }

    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Direction bedDirection;
        Object object;
        float lerpHeadRot;
        poseStack.m_85836_();
        AbstractClientPlayer livingEntity = ((AnimatablePlayerLayer)animatable).getPlayer();
        boolean shouldSit = ((AnimatablePlayerLayer)animatable).getPlayer().m_20159_() && ((AnimatablePlayerLayer)animatable).getPlayer().m_20202_() != null;
        float lerpBodyRot = livingEntity == null ? 0.0f : Mth.m_14189_((float)partialTick, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
        float f = lerpHeadRot = livingEntity == null ? 0.0f : Mth.m_14189_((float)partialTick, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_);
        if (shouldSit && (object = ((AnimatablePlayerLayer)animatable).getPlayer().m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)object;
            lerpBodyRot = Mth.m_14189_((float)partialTick, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            float netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
        }
        if (((AnimatablePlayerLayer)animatable).getPlayer().m_20089_() == Pose.SLEEPING && livingEntity != null && (bedDirection = livingEntity.m_21259_()) != null) {
            float eyePosOffset = livingEntity.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_252880_((float)(-bedDirection.m_122429_()) * eyePosOffset, 0.0f, (float)(-bedDirection.m_122431_()) * eyePosOffset);
        }
        float ageInTicks = (float)((AnimatablePlayerLayer)animatable).getPlayer().f_19797_ + partialTick;
        this.applyRotations((AnimatablePlayerLayer)animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (!isReRender) {
            AnimationState animationState = new AnimationState(animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId((AnimatablePlayerLayer)animatable);
            animationState.setData(DataTickets.TICK, (Object)((AnimatablePlayerLayer)animatable).getTick(animatable));
            this.model.addAdditionalStateData(animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.model.handleAnimations(animatable, instanceId, animationState);
        }
        poseStack.m_252880_(0.0f, 0.01f, 0.0f);
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        if (!((AnimatablePlayerLayer)animatable).getPlayer().m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            this.updateAnimatedTextureFrame((GeoAnimatable)animatable);
            for (GeoBone group : model.topLevelBones()) {
                this.renderRecursively(poseStack, (GeoAnimatable)animatable, group, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        poseStack.m_85849_();
    }

    protected void applyRotations(AnimatablePlayerLayer animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
    }

    public boolean isShaking(AbstractClientPlayer entity) {
        return entity.m_146890_();
    }

    protected float getDeathMaxRotation(AbstractClientPlayer animatable) {
        return 90.0f;
    }

    @Override
    public void setPlayerModel(PlayerModel model) {
        this.playerModel = model;
    }

    public void setupAnim(BakedGeoModel model) {
        this.matchPlayerModel(model, this.playerModel.f_102808_, "head");
        this.matchPlayerModel(model, this.playerModel.f_102810_, "torso");
        this.matchPlayerModel(model, this.playerModel.f_102811_, "right_arm");
        this.matchPlayerModel(model, this.playerModel.f_102812_, "left_arm");
        this.matchPlayerModel(model, this.playerModel.f_102813_, "right_leg");
        this.matchPlayerModel(model, this.playerModel.f_102814_, "left_leg");
    }

    public void matchPlayerModel(BakedGeoModel model, ModelPart part, String name) {
        if (model.getBone(name).isPresent()) {
            GeoBone bone = (GeoBone)model.getBone(name).get();
            bone.setPosX(-part.f_104200_);
            bone.setPosY(-part.f_104201_);
            bone.setPosZ(part.f_104202_);
            bone.setRotX(-part.f_104203_);
            bone.setRotY(-part.f_104204_);
            bone.setRotZ(part.f_104205_);
        }
    }

    public long getInstanceId(AnimatablePlayerLayer animatable) {
        return animatable.getPlayer().m_19879_();
    }
}

