/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.cannon;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.model.ModelUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.schematics.cannon.LaunchedItem;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SchematicannonRenderer
extends SafeBlockEntityRenderer<SchematicannonBlockEntity> {
    public SchematicannonRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(SchematicannonBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean blocksLaunching;
        boolean bl = blocksLaunching = !blockEntity.flyingBlocks.isEmpty();
        if (blocksLaunching) {
            SchematicannonRenderer.renderLaunchedBlocks(blockEntity, partialTicks, ms, buffer, light, overlay);
        }
        if (Backend.canUseInstancing((Level)blockEntity.m_58904_())) {
            return;
        }
        BlockPos pos = blockEntity.m_58899_();
        BlockState state = blockEntity.m_58900_();
        double[] cannonAngles = SchematicannonRenderer.getCannonAngles(blockEntity, pos, partialTicks);
        double yaw = cannonAngles[0];
        double pitch = cannonAngles[1];
        double recoil = SchematicannonRenderer.getRecoil(blockEntity, partialTicks);
        ms.m_85836_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        SuperByteBuffer connector = CachedBufferer.partial(AllPartialModels.SCHEMATICANNON_CONNECTOR, state);
        connector.translate(0.5, 0.0, 0.5);
        connector.rotate(Direction.UP, (float)((yaw + 90.0) / 180.0 * Math.PI));
        connector.translate(-0.5, 0.0, -0.5);
        connector.light(light).renderInto(ms, vb);
        SuperByteBuffer pipe = CachedBufferer.partial(AllPartialModels.SCHEMATICANNON_PIPE, state);
        pipe.translate(0.5, 0.9375, 0.5);
        pipe.rotate(Direction.UP, (float)((yaw + 90.0) / 180.0 * Math.PI));
        pipe.rotate(Direction.SOUTH, (float)(pitch / 180.0 * Math.PI));
        pipe.translate(-0.5, -0.9375, -0.5);
        pipe.translate(0.0, -recoil / 100.0, 0.0);
        pipe.light(light).renderInto(ms, vb);
        ms.m_85849_();
    }

    public static double[] getCannonAngles(SchematicannonBlockEntity blockEntity, BlockPos pos, float partialTicks) {
        double pitch;
        double yaw;
        BlockPos target = blockEntity.printer.getCurrentTarget();
        if (target != null) {
            Vec3 diff = Vec3.m_82528_((Vec3i)target.m_121996_((Vec3i)pos));
            if (blockEntity.previousTarget != null) {
                diff = Vec3.m_82528_((Vec3i)blockEntity.previousTarget).m_82549_(Vec3.m_82528_((Vec3i)target.m_121996_((Vec3i)blockEntity.previousTarget)).m_82490_((double)partialTicks)).m_82546_(Vec3.m_82528_((Vec3i)pos));
            }
            double diffX = diff.m_7096_();
            double diffZ = diff.m_7094_();
            yaw = Mth.m_14136_((double)diffX, (double)diffZ);
            yaw = yaw / Math.PI * 180.0;
            float distance = Mth.m_14116_((float)((float)(diffX * diffX + diffZ * diffZ)));
            double yOffset = 0.0f + distance * 2.0f;
            pitch = Mth.m_14136_((double)distance, (double)(diff.m_7098_() * 3.0 + yOffset));
            pitch = pitch / Math.PI * 180.0 + 10.0;
        } else {
            yaw = blockEntity.defaultYaw;
            pitch = 40.0;
        }
        return new double[]{yaw, pitch};
    }

    public static double getRecoil(SchematicannonBlockEntity blockEntity, float partialTicks) {
        double recoil = 0.0;
        for (LaunchedItem launched : blockEntity.flyingBlocks) {
            if (launched.ticksRemaining == 0 || !((float)(launched.ticksRemaining + 1) - partialTicks > (float)(launched.totalTicks - 10))) continue;
            recoil = Math.max(recoil, (double)((float)(launched.ticksRemaining + 1) - partialTicks - (float)launched.totalTicks + 10.0f));
        }
        return recoil;
    }

    private static void renderLaunchedBlocks(SchematicannonBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        for (LaunchedItem launched : blockEntity.flyingBlocks) {
            if (launched.ticksRemaining == 0) continue;
            Vec3 start = Vec3.m_82512_((Vec3i)blockEntity.m_58899_().m_7494_());
            Vec3 target = Vec3.m_82512_((Vec3i)launched.target);
            Vec3 distance = target.m_82546_(start);
            double yDifference = target.f_82480_ - start.f_82480_;
            double throwHeight = Math.sqrt(distance.m_82556_()) * (double)0.6f + yDifference;
            Vec3 cannonOffset = distance.m_82520_(0.0, throwHeight, 0.0).m_82541_().m_82490_(2.0);
            start = start.m_82549_(cannonOffset);
            yDifference = target.f_82480_ - start.f_82480_;
            float progress = ((float)launched.totalTicks - ((float)(launched.ticksRemaining + 1) - partialTicks)) / (float)launched.totalTicks;
            Vec3 blockLocationXZ = target.m_82546_(start).m_82490_((double)progress).m_82542_(1.0, 0.0, 1.0);
            float t = progress;
            double yOffset = (double)(2.0f * (1.0f - t) * t) * throwHeight + (double)(t * t) * yDifference;
            Vec3 blockLocation = blockLocationXZ.m_82520_(0.5, yOffset + 1.5, 0.5).m_82549_(cannonOffset);
            ms.m_85836_();
            ms.m_85837_(blockLocation.f_82479_, blockLocation.f_82480_, blockLocation.f_82481_);
            ms.m_252880_(0.125f, 0.125f, 0.125f);
            ms.m_252781_(Axis.f_252436_.m_252977_(360.0f * t));
            ms.m_252781_(Axis.f_252529_.m_252977_(360.0f * t));
            ms.m_252880_(-0.125f, -0.125f, -0.125f);
            if (launched instanceof LaunchedItem.ForBlockState) {
                BlockState state = launched instanceof LaunchedItem.ForBelt ? AllBlocks.SHAFT.getDefaultState() : ((LaunchedItem.ForBlockState)launched).state;
                float scale = 0.3f;
                ms.m_85841_(scale, scale, scale);
                Minecraft.m_91087_().m_91289_().renderSingleBlock(state, ms, buffer, light, overlay, ModelUtil.VIRTUAL_DATA, null);
            } else if (launched instanceof LaunchedItem.ForEntity) {
                float scale = 1.2f;
                ms.m_85841_(scale, scale, scale);
                Minecraft.m_91087_().m_91291_().m_269128_(launched.stack, ItemDisplayContext.GROUND, light, overlay, ms, buffer, blockEntity.m_58904_(), 0);
            }
            ms.m_85849_();
            if (launched.ticksRemaining != launched.totalTicks || !blockEntity.firstRenderTick) continue;
            start = start.m_82492_(0.5, 0.5, 0.5);
            blockEntity.firstRenderTick = false;
            for (int i = 0; i < 10; ++i) {
                RandomSource r = blockEntity.m_58904_().m_213780_();
                double sX = cannonOffset.f_82479_ * (double)0.01f;
                double sY = (cannonOffset.f_82480_ + 1.0) * (double)0.01f;
                double sZ = cannonOffset.f_82481_ * (double)0.01f;
                double rX = (double)r.m_188501_() - sX * 40.0;
                double rY = (double)r.m_188501_() - sY * 40.0;
                double rZ = (double)r.m_188501_() - sZ * 40.0;
                blockEntity.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, start.f_82479_ + rX, start.f_82480_ + rY, start.f_82481_ + rZ, sX, sY, sZ);
            }
        }
    }

    public boolean shouldRenderOffScreen(SchematicannonBlockEntity blockEntity) {
        return true;
    }

    public int m_142163_() {
        return 128;
    }
}

