/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.povstalec.sgjourney.common.capabilities.BloodstreamNaquadah;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodstreamNaquadahProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<BloodstreamNaquadah> BLOODSTREAM_NAQUADAH = CapabilityManager.get((CapabilityToken)new CapabilityToken<BloodstreamNaquadah>(){});
    private BloodstreamNaquadah hasNaquadah = null;
    private final LazyOptional<BloodstreamNaquadah> optional = LazyOptional.of(this::getOrCreateNaquadahBloodstream);

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.getOrCreateNaquadahBloodstream().saveData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.getOrCreateNaquadahBloodstream().loadData(tag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == BLOODSTREAM_NAQUADAH) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    private BloodstreamNaquadah getOrCreateNaquadahBloodstream() {
        if (this.hasNaquadah == null) {
            this.hasNaquadah = new BloodstreamNaquadah();
        }
        return this.hasNaquadah;
    }
}

