/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.ClassicStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.StargateUpgradeItem;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.Symbols;

public class ClassicStargateBlock
extends AbstractStargateBaseBlock {
    public ClassicStargateBlock(BlockBehaviour.Properties properties) {
        super(properties, 8.0, 0.0);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        ClassicStargateEntity stargate = new ClassicStargateEntity(pos, state);
        return stargate;
    }

    @Override
    public AbstractStargateRingBlock getRing() {
        return (AbstractStargateRingBlock)((Object)BlockInit.CLASSIC_RING.get());
    }

    @Override
    public AbstractShieldingBlock getIris() {
        return (AbstractShieldingBlock)((Object)BlockInit.CLASSIC_SHIELDING.get());
    }

    @Override
    public BlockState ringState() {
        return ((ClassicStargateRingBlock)((Object)BlockInit.CLASSIC_RING.get())).m_49966_();
    }

    public boolean upgradeStargate(Level level, BlockPos pos, Player player, InteractionHand hand) {
        if (!((Boolean)CommonStargateConfig.enable_classic_stargate_upgrades.get()).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.classic.upgrading_disabled"), true);
            return true;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof StargateUpgradeItem) {
            StargateUpgradeItem upgrade = (StargateUpgradeItem)item;
            Optional<AbstractStargateBaseBlock> baseBlock = upgrade.getStargateBaseBlock(stack);
            if (!baseBlock.isPresent()) {
                player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.classic.invalid_upgrade"), true);
                return true;
            }
            CompoundTag tag = new CompoundTag();
            BlockEntity oldEntity = level.m_7702_(pos);
            if (oldEntity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)oldEntity;
                if (!level.m_5776_()) {
                    tag = stargate.serializeStargateInfo(new CompoundTag());
                }
            }
            Direction direction = (Direction)level.m_8055_(pos).m_61143_((Property)FACING);
            Orientation orientation = (Orientation)((Object)level.m_8055_(pos).m_61143_((Property)ORIENTATION));
            for (StargatePart stargatePart : baseBlock.get().getParts()) {
                BlockState partState = level.m_8055_(stargatePart.getRingPos(pos, direction, orientation));
                if (stargatePart.equals(StargatePart.BASE) || partState.m_247087_() || partState.m_60734_() instanceof AbstractStargateBlock) continue;
                player.m_5661_((Component)Component.m_237115_((String)"block.sgjourney.stargate.not_enough_space"), true);
                return true;
            }
            Block block = level.m_8055_(pos).m_60734_();
            if (block instanceof AbstractStargateBaseBlock) {
                AbstractStargateBaseBlock oldBaseBlock = (AbstractStargateBaseBlock)block;
                for (StargatePart part3 : oldBaseBlock.getParts()) {
                    level.m_7731_(part3.getRingPos(pos, direction, orientation), Blocks.f_50016_.m_49966_(), 3);
                }
                for (StargatePart part : baseBlock.get().getParts()) {
                    if (part.equals(StargatePart.BASE)) continue;
                    level.m_7731_(part.getRingPos(pos, direction, orientation), (BlockState)((BlockState)((BlockState)baseBlock.get().getRing().m_49966_().m_61124_((Property)AbstractStargateRingBlock.PART, (Comparable)((Object)part))).m_61124_((Property)AbstractStargateRingBlock.FACING, (Comparable)direction)).m_61124_((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)orientation)), 3);
                }
                level.m_7731_(pos, (BlockState)((BlockState)baseBlock.get().m_49966_().m_61124_((Property)AbstractStargateRingBlock.FACING, (Comparable)direction)).m_61124_((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)orientation)), 3);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                    if (!level.m_5776_()) {
                        stargate.deserializeStargateInfo(tag, true);
                        stargate.addStargateToNetwork();
                    }
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (player.m_21120_(hand).m_150930_((Item)ItemInit.STARGATE_UPGRADE_CRYSTAL.get())) {
            return this.upgradeStargate(level, pos, player, hand) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ClassicStargateBlock.createTickerHelper(type, (BlockEntityType)BlockEntityInit.CLASSIC_STARGATE.get(), ClassicStargateEntity::tick);
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        if (clientPacketListener != null) {
            RegistryAccess registries = clientPacketListener.m_105152_();
            Registry pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
            Registry symbolsRegistry = registries.m_175515_(Symbols.REGISTRY_KEY);
            String pointOfOrigin = "";
            if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128441_("PointOfOrigin")) {
                ResourceLocation location = new ResourceLocation(stack.m_41783_().m_128469_("BlockEntityTag").m_128461_("PointOfOrigin"));
                pointOfOrigin = location.toString().equals("sgjourney:empty") ? "Empty" : (pointOfOriginRegistry.m_7804_(location) ? ((PointOfOrigin)pointOfOriginRegistry.m_7745_(location)).getName() : "Error");
            }
            String symbols = "";
            if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128441_("Symbols")) {
                ResourceLocation location = new ResourceLocation(stack.m_41783_().m_128469_("BlockEntityTag").m_128461_("Symbols"));
                symbols = location.toString().equals("sgjourney:empty") ? "Empty" : (symbolsRegistry.m_7804_(location) ? ((Symbols)symbolsRegistry.m_7745_(location)).getTranslationName(!ClientStargateConfig.unique_symbols.get()) : "Error");
            }
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.point_of_origin").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)pointOfOrigin)).m_130940_(ChatFormatting.DARK_PURPLE));
            tooltipComponents.add((Component)Component.m_237115_((String)Symbols.symbolsOrSet()).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)symbols)).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }
}

