/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.dhd;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.dhd.AbstractDHDBlock;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.packets.ClientboundDHDUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Address;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDHDEntity
extends EnergyBlockEntity {
    public static final String CRYSTAL_MODE = "CrystalMode";
    public static final String ENERGY_TRANSFER = "ENERGY_TRANSFER";
    public static final String CALL_FORWARDING = "CallForwarding";
    public static final String STARGATE_POS = "StargatePos";
    public static final int DEFAULT_ENERGY_TARGET = 150000;
    public static final int DEFAULT_ENERGY_TRANSFER = 2500;
    public static final int DEFAULT_CONNECTION_DISTANCE = 16;
    protected Direction direction;
    private Optional<AbstractStargateEntity> stargate = Optional.empty();
    protected Optional<Vec3i> stargateRelativePos = Optional.empty();
    protected boolean isCenterButtonEngaged = false;
    protected Address address = new Address(true);
    protected boolean enableAdvancedProtocols = false;
    protected boolean enableCallForwarding = false;
    protected long energyTarget = 150000L;
    protected int maxEnergyTransfer = 2500;

    public AbstractDHDEntity(BlockEntityType<?> blockEntity, BlockPos pos, BlockState state) {
        super(blockEntity, pos, state);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        this.setStargate();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_(STARGATE_POS)) {
            int[] pos = tag.m_128465_(STARGATE_POS);
            this.stargateRelativePos = Optional.of(new Vec3i(pos[0], pos[1], pos[2]));
        }
        super.m_142466_(tag);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.stargateRelativePos.isPresent()) {
            Vec3i pos = this.stargateRelativePos.get();
            tag.m_128385_(STARGATE_POS, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        }
    }

    public int getMaxDistance() {
        return 16;
    }

    public long getEnergyTarget() {
        return this.energyTarget;
    }

    public long getMaxEnergyTransfer() {
        return this.maxEnergyTransfer;
    }

    protected void updateStargate() {
        if (this.stargate.isEmpty()) {
            return;
        }
        AbstractStargateEntity stargate = this.stargate.get();
        if (stargate == null) {
            return;
        }
        stargate.setDHD(this, this.enableAdvancedProtocols ? 10 : 0);
    }

    protected boolean setStargateFromPos(BlockPos pos) {
        BlockEntity blockEntity = this.m_58904_().m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            this.stargate = Optional.of(stargate);
            return true;
        }
        return false;
    }

    public void setStargate() {
        if (this.m_58904_() == null) {
            return;
        }
        this.updateStargate();
        if (this.stargate.isPresent()) {
            if (this.distance(this.m_58899_(), this.stargate.get().m_58899_()) > (double)this.getMaxDistance()) {
                this.unsetStargate();
            }
            return;
        }
        if (this.stargateRelativePos.isEmpty()) {
            this.stargateRelativePos = this.findNearestStargate(this.getMaxDistance());
        }
        if (this.stargateRelativePos.isPresent()) {
            BlockPos stargatePos;
            Vec3i pos = this.stargateRelativePos.get();
            Direction direction = this.getDirection();
            if (direction != null && (stargatePos = CoordinateHelper.Relative.getOffsetPos(direction, this.m_58899_(), pos)) != null && !this.setStargateFromPos(stargatePos)) {
                this.stargateRelativePos = Optional.empty();
            }
        }
        this.m_6596_();
    }

    public void unsetStargate() {
        if (this.stargate.isPresent()) {
            this.stargate.get().unsetDHD(false);
            this.stargate = Optional.empty();
        }
        if (this.stargateRelativePos.isPresent()) {
            this.stargateRelativePos = Optional.empty();
        }
        this.updateDHD(new Address(), false);
        this.m_6596_();
    }

    public void updateDHD(Address address, boolean isStargateConnected) {
        this.setAddress(address);
        this.setCenterButtonEngaged(isStargateConnected);
        this.updateClient();
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setCenterButtonEngaged(boolean isCenterButtonEngaged) {
        this.isCenterButtonEngaged = isCenterButtonEngaged;
    }

    public boolean isCenterButtonEngaged() {
        return this.isCenterButtonEngaged;
    }

    @Override
    public boolean isCorrectEnergySide(Direction side) {
        return false;
    }

    @Override
    protected long capacity() {
        return 0L;
    }

    @Override
    protected long maxReceive() {
        return 0L;
    }

    @Override
    protected long maxExtract() {
        return 0L;
    }

    @Override
    protected void outputEnergy(Direction outputDirection) {
        if (!this.stargate.isPresent()) {
            return;
        }
        AbstractStargateEntity stargate = this.stargate.get();
        if (stargate == null) {
            return;
        }
        if (stargate.getEnergyStored() < this.getEnergyTarget()) {
            long needed = this.getEnergyTarget() - stargate.getEnergyStored();
            long energySent = needed > this.getMaxEnergyTransfer() ? this.getMaxEnergyTransfer() : needed;
            stargate.receiveEnergy(energySent, false);
        }
    }

    public void setCallForwardingState(boolean enableCallForwarding) {
        this.enableCallForwarding = enableCallForwarding;
    }

    public boolean callForwardingEnabled() {
        return this.enableCallForwarding;
    }

    protected BlockState getState() {
        BlockPos gatePos = this.m_58899_();
        return this.f_58857_.m_8055_(gatePos);
    }

    public Direction getDirection() {
        if (this.direction == null) {
            BlockState gateState = this.getState();
            if (gateState.m_60734_() instanceof AbstractDHDBlock) {
                this.direction = (Direction)gateState.m_61143_((Property)AbstractDHDBlock.f_54117_);
            } else {
                StargateJourney.LOGGER.error("Couldn't find DHD Direction");
            }
        }
        return this.direction;
    }

    protected List<AbstractStargateEntity> getNearbyStargates(int maxDistance) {
        ArrayList<AbstractStargateEntity> stargates = new ArrayList<AbstractStargateEntity>();
        for (int x = -maxDistance / 16; x <= maxDistance / 16; ++x) {
            for (int z = -maxDistance / 16; z <= maxDistance / 16; ++z) {
                ChunkAccess chunk = this.f_58857_.m_46865_(this.m_58899_().m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity patt8664$temp = this.f_58857_.m_7702_(pos);
                    if (patt8664$temp instanceof AbstractStargateEntity) {
                        AbstractStargateEntity stargate = (AbstractStargateEntity)patt8664$temp;
                        if (this.distance(this.m_58899_(), stargate.m_58899_()) <= (double)maxDistance) {
                            stargates.add(stargate);
                        }
                    }
                });
            }
        }
        return stargates;
    }

    private double distance(BlockPos pos, BlockPos targetPos) {
        int x = Math.abs(targetPos.m_123341_() - pos.m_123341_());
        int y = Math.abs(targetPos.m_123342_() - pos.m_123342_());
        int z = Math.abs(targetPos.m_123343_() - pos.m_123343_());
        double stargateDistance = Math.sqrt(x * x + y * y + z * z);
        return stargateDistance;
    }

    public Optional<Vec3i> findNearestStargate(int maxDistance) {
        List<AbstractStargateEntity> stargates = this.getNearbyStargates(maxDistance);
        stargates.sort((stargateA, stargateB) -> Double.valueOf(this.distance(this.m_58899_(), stargateA.m_58899_())).compareTo(this.distance(this.m_58899_(), stargateB.m_58899_())));
        if (!stargates.isEmpty()) {
            for (AbstractStargateEntity stargate : stargates) {
                Direction direction;
                if (stargate.hasDHD() || (direction = this.getDirection()) == null) continue;
                this.stargate = Optional.of(stargate);
                return Optional.of(CoordinateHelper.Relative.getRelativeOffset(direction, this.m_58899_(), stargate.m_58899_()));
            }
        }
        return Optional.empty();
    }

    public void sendMessageToNearbyPlayers(Component message, int distance) {
        AABB localBox = new AABB((double)(this.m_58899_().m_123341_() - distance), (double)(this.m_58899_().m_123342_() - distance), (double)(this.m_58899_().m_123343_() - distance), (double)(this.m_58899_().m_123341_() + 1 + distance), (double)(this.m_58899_().m_123342_() + 1 + distance), (double)(this.m_58899_().m_123343_() + 1 + distance));
        this.f_58857_.m_45976_(Player.class, localBox).stream().forEach(player -> player.m_5661_(message, true));
    }

    protected abstract SoundEvent getEnterSound();

    protected abstract SoundEvent getPressSound();

    public void engageChevron(int symbol) {
        if (this.stargate.isPresent()) {
            AbstractStargateEntity stargate = this.stargate.get();
            if (symbol == 0) {
                this.f_58857_.m_5594_((Player)null, this.m_58899_(), this.getEnterSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                this.f_58857_.m_5594_((Player)null, this.m_58899_(), this.getPressSound(), SoundSource.BLOCKS, 0.25f, 1.0f);
            }
            stargate.engageSymbol(symbol);
        } else {
            this.sendMessageToNearbyPlayers((Component)Component.m_237115_((String)"message.sgjourney.dhd.error.not_connected_to_stargate").m_130940_(ChatFormatting.DARK_RED), 5);
        }
    }

    public boolean isSymbolEngaged(int symbol) {
        return this.address.containsSymbol(symbol);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractDHDEntity dhd) {
        if (level.m_5776_()) {
            return;
        }
        dhd.outputEnergy(null);
    }

    public void updateClient() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundDHDUpdatePacket(this.f_58858_, StargateJourney.EMPTY, this.address.toArray(), this.isCenterButtonEngaged));
    }
}

