/*
 * Decompiled with CFR 0.152.
 */
package forge.me.thosea.badoptimizations.mixin.tick;

import forge.me.thosea.badoptimizations.interfaces.BiomeSkyColorGetter;
import forge.me.thosea.badoptimizations.other.CommonColorFactors;
import forge.me.thosea.badoptimizations.other.Config;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientWorld
extends Level {
    @Shadow
    @Final
    private Minecraft f_104565_;
    private BiomeSkyColorGetter bo$biomeColors;
    private CommonColorFactors bo$commonFactors;
    private Vec3 bo$skyColorCache;
    private int bo$lastBiomeColor;
    private Vec3 bo$biomeColorVector;

    @Inject(method={"getSkyColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetSkyColor(Vec3 cameraPos, float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        if (this.bo$skyColorCache == null || this.f_104565_.f_91074_ == null) {
            return;
        }
        CommonColorFactors.tick(tickDelta);
        if (this.bo$commonFactors.didTickChange()) {
            if (this.bo$isBiomeDirty(cameraPos.m_82492_(2.0, 2.0, 2.0).m_82490_(0.25))) {
                this.bo$commonFactors.updateLastTime();
                return;
            }
            if (this.bo$commonFactors.isDirty() || this.bo$commonFactors.getTimeDelta() >= (long)Config.skycolor_time_change_needed_for_update) {
                this.bo$skyColorCache = this.bo$calcSkyColor(tickDelta);
                this.bo$commonFactors.updateLastTime();
            }
        }
        cir.setReturnValue((Object)this.bo$skyColorCache);
    }

    private boolean bo$isBiomeDirty(Vec3 pos) {
        int z;
        int y;
        int x = Mth.m_14107_((double)pos.f_82479_);
        int color = this.bo$biomeColors.get(x - 2, (y = Mth.m_14107_((double)pos.f_82480_)) - 2, (z = Mth.m_14107_((double)pos.f_82481_)) - 2);
        if (this.bo$lastBiomeColor != color) {
            this.bo$lastBiomeColor = color;
            this.bo$biomeColorVector = Vec3.m_82501_((int)color);
            return true;
        }
        return this.bo$biomeColors.get(x + 3, y + 3, z + 3) != color;
    }

    @Shadow
    public abstract int m_104819_();

    @Shadow
    public abstract Vec3 m_171660_(Vec3 var1, float var2);

    private Vec3 bo$calcSkyColor(float delta) {
        double color;
        float angle = Mth.m_14089_((float)(this.m_46942_(1.0f) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        angle = Mth.m_14036_((float)angle, (float)0.0f, (float)1.0f);
        double x = this.bo$biomeColorVector.f_82479_ * (double)angle;
        double y = this.bo$biomeColorVector.f_82480_ * (double)angle;
        double z = this.bo$biomeColorVector.f_82481_ * (double)angle;
        if (CommonColorFactors.rainGradientMultiplier > 0.0f) {
            color = (x * (double)0.3f + y * (double)0.59f + z * (double)0.11f) * (double)0.6f;
            x = x * (double)CommonColorFactors.rainGradientMultiplier + color * (1.0 - (double)CommonColorFactors.rainGradientMultiplier);
            y = y * (double)CommonColorFactors.rainGradientMultiplier + color * (1.0 - (double)CommonColorFactors.rainGradientMultiplier);
            z = z * (double)CommonColorFactors.rainGradientMultiplier + color * (1.0 - (double)CommonColorFactors.rainGradientMultiplier);
        }
        if (CommonColorFactors.thunderGradientMultiplier > 0.0f) {
            color = (x * (double)0.3f + y * (double)0.59f + z * (double)0.11f) * (double)0.2f;
            x = x * (double)CommonColorFactors.thunderGradientMultiplier + color * (1.0 - (double)CommonColorFactors.thunderGradientMultiplier);
            y = y * (double)CommonColorFactors.thunderGradientMultiplier + color * (1.0 - (double)CommonColorFactors.thunderGradientMultiplier);
            z = z * (double)CommonColorFactors.thunderGradientMultiplier + color * (1.0 - (double)CommonColorFactors.thunderGradientMultiplier);
        }
        if (CommonColorFactors.lastLightningTicks > 0) {
            float lightningMultiplier = (float)CommonColorFactors.lastLightningTicks - delta;
            if (lightningMultiplier > 1.0f) {
                lightningMultiplier = 1.0f;
            }
            x = x * (double)(1.0f - (lightningMultiplier *= 0.45f)) + (double)(0.8f * lightningMultiplier);
            y = y * (double)(1.0f - lightningMultiplier) + (double)(0.8f * lightningMultiplier);
            z = z * (double)(1.0f - lightningMultiplier) + (double)lightningMultiplier;
        }
        return new Vec3(x, y, z);
    }

    @Inject(method={"getSkyColor"}, at={@At(value="RETURN")})
    private void afterGetSkyColor(Vec3 cameraPos, float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        this.bo$skyColorCache = (Vec3)cir.getReturnValue();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void afterInit(CallbackInfo ci) {
        this.bo$commonFactors = CommonColorFactors.SKY_COLOR;
        this.bo$lastBiomeColor = Integer.MIN_VALUE;
        this.bo$biomeColorVector = Vec3.f_82478_;
        this.bo$biomeColors = BiomeSkyColorGetter.of(this.m_7062_());
    }

    protected MixinClientWorld(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
        throw new AssertionError((Object)"nuh uh");
    }
}

