/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.packet.handlers;

import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import me.vierdant.playeremotes.ModSuggests;
import me.vierdant.playeremotes.PlayeremotesClient;
import me.vierdant.playeremotes.packet.packets.AnimationStateChangePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import traben.entity_model_features.EMFAnimationApi;
import traben.entity_model_features.utils.EMFEntity;

public class AnimationStateChangeHandler {
    public static void handle(AnimationStateChangePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> AnimationStateChangeHandler.lambda$handle$1(msg, (Supplier)contextSupplier)));
        contextSupplier.get().setPacketHandled(true);
    }

    public static void handlePacket(AnimationStateChangePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        Minecraft client = Minecraft.m_91087_();
        if (!ModSuggests.hasEMF) {
            return;
        }
        Player target = AnimationStateChangeHandler.getPlayerByUUID(msg.uuid());
        if (target == null || client.f_91074_ == null) {
            return;
        }
        if (msg.state() && PlayeremotesClient.currentAnimation != null) {
            AnimationStateChangeHandler.pauseEMFAnimations(target, client, PlayeremotesClient.currentAnimation.excludeHead);
        } else {
            AnimationStateChangeHandler.resumeEMFAnimations(target);
        }
    }

    private static void pauseEMFAnimations(Player targetPlayer, Minecraft client, boolean excludeHead) {
        EMFEntity emfEntity = EMFAnimationApi.emfEntityOf((Entity)targetPlayer);
        if (emfEntity == null) {
            return;
        }
        EntityRenderDispatcher dispatcher = client.m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_((Entity)targetPlayer);
        if (renderer instanceof PlayerRenderer) {
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            PlayerModel model = (PlayerModel)playerRenderer.m_7200_();
            ArrayList<ModelPart> partsToPause = new ArrayList<ModelPart>();
            if (!excludeHead) {
                partsToPause.add(model.f_102808_);
            }
            partsToPause.add(model.f_102810_);
            partsToPause.add(model.f_102812_);
            partsToPause.add(model.f_102811_);
            partsToPause.add(model.f_102814_);
            partsToPause.add(model.f_102813_);
            ModelPart[] partsArray = partsToPause.toArray(new ModelPart[0]);
            EMFAnimationApi.pauseCustomAnimationsForThesePartsOfEntity((EMFEntity)emfEntity, (ModelPart[])partsArray);
        }
    }

    private static void resumeEMFAnimations(Player targetPlayer) {
        EMFEntity emfEntity = EMFAnimationApi.emfEntityOf((Entity)targetPlayer);
        if (emfEntity == null) {
            return;
        }
        EMFAnimationApi.resumeAllCustomAnimationsForEntity((EMFEntity)emfEntity);
    }

    private static Player getPlayerByUUID(UUID uuid) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            return Minecraft.m_91087_().f_91073_.m_46003_(uuid);
        }
        return null;
    }

    private static /* synthetic */ Runnable lambda$handle$1(AnimationStateChangePacket msg, Supplier contextSupplier) {
        return () -> AnimationStateChangeHandler.lambda$handle$0(msg, (Supplier)contextSupplier);
    }

    private static /* synthetic */ void lambda$handle$0(AnimationStateChangePacket msg, Supplier contextSupplier) {
        AnimationStateChangeHandler.handlePacket(msg, contextSupplier);
    }
}

