/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.vierdant.playeremotes.ModSuggests;
import me.vierdant.playeremotes.data.Animation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationRegistry {
    private static final HashMap<String, Animation> animations = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(AnimationRegistry.class);

    public static Animation getAnimation(String id) {
        return animations.get(id);
    }

    public static Animation register(String id, boolean excludeHead) {
        return AnimationRegistry.register("playeremotes", id, excludeHead);
    }

    public static Animation register(String namespace, String id, boolean excludeHead) {
        return AnimationRegistry.register(namespace, id, excludeHead, id, "A playable animation", "");
    }

    public static Animation register(String namespace, String id, boolean excludeHead, String name, String description) {
        return AnimationRegistry.register(namespace, id, excludeHead, name, description, "");
    }

    public static Animation register(String namespace, String id, boolean excludeHead, String name, String description, String author) {
        try {
            if (animations.containsKey(id)) {
                throw new Exception("Animation with key " + id + " is already registered.");
            }
            Animation animation = new Animation(namespace, id, excludeHead, name, description, author);
            animations.put(id, animation);
            return animation;
        }
        catch (Exception e) {
            log.atError().log(e.toString());
            return null;
        }
    }

    public static void replace(String id, Animation animation) {
        if (!animations.containsKey(id)) {
            log.atWarn().log("Replacing animation with ID " + id + " failed. Make sure the ID is correct.");
            return;
        }
        animations.replace(id, animation);
    }

    public static List<Animation> getAnimations() {
        return new ArrayList<Animation>(animations.values());
    }

    public static void registerDefault() {
        if (ModSuggests.hasSittingPlus) {
            AnimationRegistry.register("sittingplus", "buttsit", true, "Sitting Plus", "Sitting animations from the Sitting+ mod", "SaltyWater").populateAnimationList(animation -> {
                animation.animationList.put("floor", new String[]{"kneesitting", "buttsit", "buttsit2", "kneeleaning"});
                animation.animationList.put("stairs", new String[]{"chairsitting", "chairsitting2", "chairsitting3", "chairsitting4"});
                animation.animationList.put("fence", new String[]{"fencesitting", "fencesitting2"});
                animation.animationList.put("bed", new String[]{"bedlyingdown", "bedlyingdown2", "bedlyingdown3"});
                animation.animationList.put("sword", new String[]{"swordsit", "swordsit2"});
                animation.animationList.put("fishing", new String[]{"fishing"});
                animation.animationList.put("axe", new String[]{"sittingaxe"});
                animation.animationList.put("shovel", new String[]{"sittingshovel"});
                animation.animationList.put("campfire", new String[]{"campfiresit"});
                animation.animationList.put("furnace", new String[]{"furnacesit"});
            });
        }
        AnimationRegistry.register("playeremotes", "lean_to_left", true, "Lean", "A Playable Animation.").populateAnimationList(animation -> {
            animation.animationList.put("left", new String[]{"lean_to_left"});
            animation.animationList.put("right", new String[]{"lean_to_right"});
            animation.animationList.put("back", new String[]{"lean_to_back"});
        });
        AnimationRegistry.register("wave", true);
        AnimationRegistry.register("sit", true);
        AnimationRegistry.register("backflip", false);
        AnimationRegistry.register("cheer", true);
        AnimationRegistry.register("shrug", true);
        AnimationRegistry.register("hug", true);
        AnimationRegistry.register("laugh", true);
        AnimationRegistry.register("yawn", false);
        AnimationRegistry.register("hands_up", true);
        AnimationRegistry.register("flex_muscle", false);
        AnimationRegistry.register("arms_crossed", true);
        AnimationRegistry.register("hands_on_hips", true);
        AnimationRegistry.register("head_nod", false);
        AnimationRegistry.register("head_shake", false);
        AnimationRegistry.register("arm_stretch", true);
        AnimationRegistry.register("side_step_shuffle", false);
        AnimationRegistry.register("arm_wave_dance", true);
        AnimationRegistry.register("wiggling_torso", true);
        AnimationRegistry.register("air_drum", true);
        AnimationRegistry.register("robot_dance", false);
        AnimationRegistry.register("hide_barrel", false).setName("Hide (Barrel)");
        AnimationRegistry.register("clap", true).populateAnimationList("clap", "clap2", "clap3");
        AnimationRegistry.register("point", true).populateAnimationList("point", "point2");
        AnimationRegistry.register("cry", false).populateAnimationList("cry", "cry2");
        AnimationRegistry.register("salute", true).populateAnimationList("salute", "salute2");
        AnimationRegistry.register("facepalm", false).populateAnimationList("facepalm", "facepalm2", "facepalm3");
        AnimationRegistry.register("kneel", false).populateAnimationList("kneel", "kneel2", "kneel3");
        AnimationRegistry.register("lay", false).populateAnimationList("lay", "lay2", "lay3");
        AnimationRegistry.register("bow", false).populateAnimationList("bow", "bow2", "bow3");
    }
}

