/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.config.file;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.function.Function;
import me.vierdant.playeremotes.config.CommentedConfig;
import me.vierdant.playeremotes.config.Config;
import me.vierdant.playeremotes.config.ConfigFormat;
import me.vierdant.playeremotes.config.concurrent.ConcurrentCommentedConfig;
import me.vierdant.playeremotes.config.file.CheckedCommentedFileConfig;
import me.vierdant.playeremotes.config.file.CommentedFileConfigBuilder;
import me.vierdant.playeremotes.config.file.FileConfig;

public interface CommentedFileConfig
extends ConcurrentCommentedConfig,
FileConfig {
    @Override
    default public CommentedFileConfig checked() {
        return new CheckedCommentedFileConfig(this);
    }

    @Override
    public <R> R bulkCommentedUpdate(Function<? super CommentedConfig, R> var1);

    @Override
    default public void bulkCommentedUpdate(Consumer<? super CommentedConfig> action) {
        this.bulkCommentedUpdate((? super CommentedConfig config) -> {
            action.accept((CommentedConfig)config);
            return null;
        });
    }

    @Override
    default public <R> R bulkUpdate(Function<? super Config, R> action) {
        return this.bulkCommentedUpdate(action);
    }

    public static CommentedFileConfig of(File file, ConfigFormat<? extends CommentedConfig> format) {
        return CommentedFileConfig.of(file.toPath(), format);
    }

    public static CommentedFileConfig of(Path file, ConfigFormat<? extends CommentedConfig> format) {
        return (CommentedFileConfig)CommentedFileConfig.builder(file, format).build();
    }

    public static CommentedFileConfig of(String filePath, ConfigFormat<? extends CommentedConfig> format) {
        return CommentedFileConfig.of(Paths.get(filePath, new String[0]), format);
    }

    public static CommentedFileConfigBuilder builder(File file, ConfigFormat<? extends CommentedConfig> format) {
        return CommentedFileConfig.builder(file.toPath(), format);
    }

    public static CommentedFileConfigBuilder builder(Path file, ConfigFormat<? extends CommentedConfig> format) {
        return new CommentedFileConfigBuilder(file, format);
    }

    public static CommentedFileConfigBuilder builder(String filePath, ConfigFormat<? extends CommentedConfig> format) {
        return CommentedFileConfig.builder(Paths.get(filePath, new String[0]), format);
    }
}

