/*
 * Decompiled with CFR 0.152.
 */
package me.vierdant.playeremotes.config;

import java.util.ArrayList;
import me.vierdant.playeremotes.config.file.FileConfig;
import me.vierdant.playeremotes.config.file.GenericBuilder;
import me.vierdant.playeremotes.config.json.JsonFormat;
import org.jetbrains.annotations.Nullable;

public class ClientConfig {
    private final FileConfig config;
    private String[][] inMemoryWheelData;
    public boolean showIcons;

    public ClientConfig(String path) {
        GenericBuilder builder = FileConfig.builder(path, JsonFormat.minimalInstance()).defaultResource("/assets/playeremotes/config/playeremotes.json").sync().autosave();
        this.config = builder.build();
    }

    public void load() {
        this.config.load();
        this.update();
    }

    public void update() {
        this.showIcons = (Boolean)this.config.get("showIcons");
        this.inMemoryWheelData = ClientConfig.convertTo2DArray((ArrayList)this.config.get("quickWheel"));
    }

    public void save() {
        this.config.save();
    }

    @Nullable
    public String getQuickWheelEntry(int page, int index) {
        if (this.inMemoryWheelData == null) {
            this.inMemoryWheelData = ClientConfig.convertTo2DArray((ArrayList)this.config.get("quickWheel"));
        }
        return this.inMemoryWheelData[page][index];
    }

    public void setQuickWheelEntry(int page, int index, String value) {
        this.inMemoryWheelData[page][index] = value;
        this.config.set("quickWheel", (Object)this.inMemoryWheelData);
    }

    public static String[][] convertTo2DArray(ArrayList<ArrayList<String>> listOfLists) {
        int outerSize = listOfLists.size();
        int maxInnerSize = listOfLists.stream().mapToInt(ArrayList::size).max().orElse(0);
        String[][] result = new String[outerSize][maxInnerSize];
        for (int i = 0; i < outerSize; ++i) {
            ArrayList<String> innerList = listOfLists.get(i);
            for (int j = 0; j < innerList.size(); ++j) {
                result[i][j] = innerList.get(j);
            }
        }
        return result;
    }
}

