/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5742;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Logger;

public class ChunkWrapper
implements IChunkWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ThreadLocal<class_2338.class_2339> MUTABLE_BLOCK_POS_REF = ThreadLocal.withInitial(() -> new class_2338.class_2339());
    private final class_2791 chunk;
    private final DhChunkPos chunkPos;
    private final class_4538 lightSource;
    private final ILevelWrapper wrappedLevel;
    private boolean isDhLightCorrect = false;
    private boolean isMcClientLightingCorrect = false;
    private ChunkLightStorage blockLightStorage;
    private ChunkLightStorage skyLightStorage;
    private ArrayList<DhBlockPos> blockLightPosList = null;
    private boolean useDhLighting;
    private int minNonEmptyHeight = Integer.MIN_VALUE;
    private int maxNonEmptyHeight = Integer.MAX_VALUE;
    private int blockBiomeHashCode = 0;
    private static final ConcurrentLinkedQueue<ChunkWrapper> chunksNeedingClientLightUpdating = new ConcurrentLinkedQueue();

    public ChunkWrapper(class_2791 chunk, class_4538 lightSource, ILevelWrapper wrappedLevel) {
        boolean isDhGeneratedChunk;
        this.chunk = chunk;
        this.lightSource = lightSource;
        this.wrappedLevel = wrappedLevel;
        this.chunkPos = new DhChunkPos(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        this.useDhLighting = isDhGeneratedChunk = this.lightSource.getClass() == DhLitWorldGenRegion.class;
        chunksNeedingClientLightUpdating.add(this);
    }

    @Override
    public int getHeight() {
        return ChunkWrapper.getHeight(this.chunk);
    }

    public static int getHeight(class_2791 chunk) {
        return chunk.method_31605();
    }

    @Override
    public int getMinBuildHeight() {
        return ChunkWrapper.getMinBuildHeight(this.chunk);
    }

    public static int getMinBuildHeight(class_2791 chunk) {
        return chunk.method_31607();
    }

    @Override
    public int getMaxBuildHeight() {
        return ChunkWrapper.getMaxBuildHeight(this.chunk);
    }

    public static int getMaxBuildHeight(class_2791 chunk) {
        return chunk.method_31600();
    }

    @Override
    public int getMinNonEmptyHeight() {
        if (this.minNonEmptyHeight != Integer.MIN_VALUE) {
            return this.minNonEmptyHeight;
        }
        this.minNonEmptyHeight = this.getMinBuildHeight();
        class_2826[] sections = this.chunk.method_12006();
        for (int index = 0; index < sections.length; ++index) {
            if (sections[index] == null || ChunkWrapper.isChunkSectionEmpty(sections[index])) continue;
            this.minNonEmptyHeight = this.getChunkSectionMinHeight(index);
            break;
        }
        return this.minNonEmptyHeight;
    }

    @Override
    public int getMaxNonEmptyHeight() {
        if (this.maxNonEmptyHeight != Integer.MAX_VALUE) {
            return this.maxNonEmptyHeight;
        }
        this.maxNonEmptyHeight = this.getMaxBuildHeight();
        class_2826[] sections = this.chunk.method_12006();
        for (int index = sections.length - 1; index >= 0; --index) {
            this.maxNonEmptyHeight = this.getChunkSectionMinHeight(index) + 16;
            if (sections[index] != null && !ChunkWrapper.isChunkSectionEmpty(sections[index])) break;
        }
        return this.maxNonEmptyHeight;
    }

    private static boolean isChunkSectionEmpty(class_2826 section) {
        return section.method_38292();
    }

    private int getChunkSectionMinHeight(int index) {
        return index * 16 + this.getMinBuildHeight();
    }

    @Override
    public int getSolidHeightMapValue(int xRel, int zRel) {
        return this.chunk.method_12032(class_2902.class_2903.field_13202).method_12603(xRel, zRel);
    }

    @Override
    public int getLightBlockingHeightMapValue(int xRel, int zRel) {
        return this.chunk.method_12032(class_2902.class_2903.field_13197).method_12603(xRel, zRel);
    }

    @Override
    public IBiomeWrapper getBiome(int relX, int relY, int relZ) {
        return BiomeWrapper.getBiomeWrapper((class_6880<class_1959>)this.chunk.method_16359(class_5742.method_33100((int)relX), class_5742.method_33100((int)relY), class_5742.method_33100((int)relZ)), this.wrappedLevel);
    }

    @Override
    public IBlockStateWrapper getBlockState(int relX, int relY, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, relY, relZ);
        class_2338.class_2339 blockPos = MUTABLE_BLOCK_POS_REF.get();
        blockPos.method_33097(relX);
        blockPos.method_33098(relY);
        blockPos.method_33099(relZ);
        return BlockStateWrapper.fromBlockState(this.chunk.method_8320((class_2338)blockPos), this.wrappedLevel);
    }

    @Override
    public DhChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public class_2791 getChunk() {
        return this.chunk;
    }

    public class_2806 getStatus() {
        return ChunkWrapper.getStatus(this.getChunk());
    }

    public static class_2806 getStatus(class_2791 chunk) {
        return chunk.method_12009();
    }

    @Override
    public int getMaxBlockX() {
        return this.chunk.method_12004().method_8327();
    }

    @Override
    public int getMaxBlockZ() {
        return this.chunk.method_12004().method_8329();
    }

    @Override
    public int getMinBlockX() {
        return this.chunk.method_12004().method_8326();
    }

    @Override
    public int getMinBlockZ() {
        return this.chunk.method_12004().method_8328();
    }

    @Override
    public void setIsDhLightCorrect(boolean isDhLightCorrect) {
        this.isDhLightCorrect = isDhLightCorrect;
    }

    @Override
    public void setUseDhLighting(boolean useDhLighting) {
        this.useDhLighting = useDhLighting;
    }

    @Override
    public boolean isLightCorrect() {
        if (this.useDhLighting) {
            return this.isDhLightCorrect;
        }
        if (this.chunk instanceof class_2818) {
            class_2818 levelChunk = (class_2818)this.chunk;
            if (levelChunk.method_12200() instanceof class_638) {
                return this.isMcClientLightingCorrect;
            }
            return this.chunk.method_12038() && levelChunk.field_12855;
        }
        return this.chunk.method_12038();
    }

    @Override
    public int getDhBlockLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        return this.getBlockLightStorage().get(relX, y, relZ);
    }

    @Override
    public void setDhBlockLight(int relX, int y, int relZ, int lightValue) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        this.getBlockLightStorage().set(relX, y, relZ, lightValue);
    }

    private ChunkLightStorage getBlockLightStorage() {
        if (this.blockLightStorage == null) {
            this.blockLightStorage = ChunkLightStorage.createBlockLightStorage(this);
        }
        return this.blockLightStorage;
    }

    public void setBlockLightStorage(ChunkLightStorage lightStorage) {
        this.blockLightStorage = lightStorage;
    }

    @Override
    public void clearDhBlockLighting() {
        this.getBlockLightStorage().clear();
    }

    @Override
    public int getDhSkyLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        return this.getSkyLightStorage().get(relX, y, relZ);
    }

    @Override
    public void setDhSkyLight(int relX, int y, int relZ, int lightValue) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        this.getSkyLightStorage().set(relX, y, relZ, lightValue);
    }

    @Override
    public void clearDhSkyLighting() {
        this.getSkyLightStorage().clear();
    }

    private ChunkLightStorage getSkyLightStorage() {
        if (this.skyLightStorage == null) {
            this.skyLightStorage = ChunkLightStorage.createSkyLightStorage(this);
        }
        return this.skyLightStorage;
    }

    public void setSkyLightStorage(ChunkLightStorage lightStorage) {
        this.skyLightStorage = lightStorage;
    }

    @Override
    public int getBlockLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        if (this.useDhLighting) {
            return this.getBlockLightStorage().get(relX, y, relZ);
        }
        return this.lightSource.method_8314(class_1944.field_9282, new class_2338(relX + this.getMinBlockX(), y, relZ + this.getMinBlockZ()));
    }

    @Override
    public int getSkyLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        if (this.useDhLighting) {
            return this.getSkyLightStorage().get(relX, y, relZ);
        }
        return this.lightSource.method_8314(class_1944.field_9284, new class_2338(relX + this.getMinBlockX(), y, relZ + this.getMinBlockZ()));
    }

    @Override
    public synchronized ArrayList<DhBlockPos> getWorldBlockLightPosList() {
        if (this.blockLightPosList == null) {
            this.blockLightPosList = new ArrayList();
            this.chunk.method_51524((blockPos, blockState) -> {
                DhBlockPos pos = new DhBlockPos(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
                this.blockLightPosList.add(pos);
            });
        }
        return this.blockLightPosList;
    }

    public static void syncedUpdateClientLightStatus() {
        ChunkWrapper chunkWrapper = chunksNeedingClientLightUpdating.poll();
        while (chunkWrapper != null) {
            chunkWrapper.updateIsClientLightingCorrect();
            chunkWrapper = chunksNeedingClientLightUpdating.poll();
        }
    }

    private void updateIsClientLightingCorrect() {
        if (this.chunk instanceof class_2818 && ((class_2818)this.chunk).method_12200() instanceof class_638) {
            class_2818 levelChunk = (class_2818)this.chunk;
            class_631 clientChunkCache = ((class_638)levelChunk.method_12200()).method_2935();
            this.isMcClientLightingCorrect = clientChunkCache.method_12246(this.chunk.method_12004().field_9181, this.chunk.method_12004().field_9180) != null && ChunkWrapper.checkLightSectionsOnChunk(levelChunk, levelChunk.method_12200().method_22336());
        }
    }

    private static boolean checkLightSectionsOnChunk(class_2818 chunk, class_3568 engine) {
        class_2826[] sections = chunk.method_12006();
        int minY = chunk.method_32891();
        int maxY = chunk.method_31597();
        for (int y = minY; y < maxY; ++y) {
            class_2826 section = sections[chunk.method_31603(y)];
            if (section.method_38292() || engine.method_51559(class_4076.method_18681((class_1923)chunk.method_12004(), (int)y))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doNearbyChunksExist() {
        if (this.lightSource instanceof DhLitWorldGenRegion) {
            return true;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || this.lightSource.method_8402(dx + this.chunk.method_12004().field_9181, dz + this.chunk.method_12004().field_9180, class_2806.field_12794, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isStillValid() {
        return this.wrappedLevel.tryGetChunk(this.chunkPos) == this;
    }

    @Override
    public String toString() {
        return this.chunk.getClass().getSimpleName() + String.valueOf(this.chunk.method_12004());
    }
}

