/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.parts.p2p.multi;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKeyType;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import java.util.List;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import stone.mae2.MAE2;
import stone.mae2.parts.p2p.multi.CapabilityMultiP2PPart;

public class FluidMultiP2PPart
extends CapabilityMultiP2PPart<FluidMultiP2PPart, IFluidHandler> {
    private static final P2PModels MODELS = new P2PModels(MAE2.toKey("part/p2p/multi_p2p_tunnel_fluids"));
    private static final IFluidHandler NULL_FLUID_HANDLER = new NullFluidHandler();

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public FluidMultiP2PPart(IPartItem<?> partItem) {
        super(partItem, ForgeCapabilities.FLUID_HANDLER);
        this.inputHandler = new InputFluidHandler();
        this.outputHandler = new OutputFluidHandler();
        this.emptyHandler = NULL_FLUID_HANDLER;
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private class InputFluidHandler
    implements IFluidHandler {
        private InputFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int total = 0;
            int outputTunnels = FluidMultiP2PPart.this.getOutputs().size();
            int amount = resource.getAmount();
            if (outputTunnels == 0 || amount == 0) {
                return 0;
            }
            int amountPerOutput = amount / outputTunnels;
            int overflow = amountPerOutput == 0 ? amount : amount % amountPerOutput;
            for (FluidMultiP2PPart target : FluidMultiP2PPart.this.getOutputs()) {
                CapabilityMultiP2PPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                try {
                    IFluidHandler output = (IFluidHandler)capabilityGuard.get();
                    int toSend = amountPerOutput + overflow;
                    FluidStack fillWithFluidStack = resource.copy();
                    fillWithFluidStack.setAmount(toSend);
                    int received = output.fill(fillWithFluidStack, action);
                    overflow = toSend - received;
                    total += received;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            if (action == IFluidHandler.FluidAction.EXECUTE) {
                FluidMultiP2PPart.this.queueTunnelDrain(PowerUnits.FE, (double)total / (double)AEKeyType.fluids().getAmountPerOperation());
            }
            return total;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    private class OutputFluidHandler
    implements IFluidHandler {
        private OutputFluidHandler() {
        }

        public int getTanks() {
            return FluidMultiP2PPart.this.getInputStream().mapToInt(input -> {
                try (CapabilityMultiP2PPart.CapabilityGuard guard = input.getAdjacentCapability();){
                    int n = ((IFluidHandler)guard.get()).getTanks();
                    return n;
                }
            }).sum();
        }

        public FluidStack getFluidInTank(int tank) {
            List inputs = FluidMultiP2PPart.this.getInputs();
            int currentTank = tank;
            for (FluidMultiP2PPart input : inputs) {
                CapabilityMultiP2PPart.CapabilityGuard guard = input.getAdjacentCapability();
                try {
                    IFluidHandler handler = (IFluidHandler)guard.get();
                    int slotCount = handler.getTanks();
                    if (currentTank < slotCount) {
                        FluidStack fluidStack = handler.getFluidInTank(currentTank);
                        return fluidStack;
                    }
                    currentTank -= slotCount;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            List inputs = FluidMultiP2PPart.this.getInputs();
            int currentTank = tank;
            for (FluidMultiP2PPart input : inputs) {
                CapabilityMultiP2PPart.CapabilityGuard guard = input.getAdjacentCapability();
                try {
                    IFluidHandler handler = (IFluidHandler)guard.get();
                    int slotCount = handler.getTanks();
                    if (currentTank < slotCount) {
                        int n = handler.getTankCapacity(currentTank);
                        return n;
                    }
                    currentTank -= slotCount;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return 0;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getAmount() == 0) {
                return FluidStack.EMPTY;
            }
            FluidStack toDrain = resource.copy();
            for (FluidMultiP2PPart target : FluidMultiP2PPart.this.getInputs()) {
                CapabilityMultiP2PPart.CapabilityGuard input = target.getAdjacentCapability();
                try {
                    FluidStack result = ((IFluidHandler)input.get()).drain(resource, action);
                    toDrain.shrink(result.getAmount());
                    if (toDrain.getAmount() > 0) continue;
                    break;
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            FluidStack drained = resource.copy();
            drained.shrink(toDrain.getAmount());
            if (action.execute()) {
                FluidMultiP2PPart.this.queueTunnelDrain(PowerUnits.FE, (double)drained.getAmount() / (double)AEKeyType.fluids().getAmountPerOperation());
            }
            return drained;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (maxDrain == 0) {
                return FluidStack.EMPTY;
            }
            FluidStack potential = FluidStack.EMPTY;
            List inputs = FluidMultiP2PPart.this.getInputs();
            for (FluidMultiP2PPart input : inputs) {
                CapabilityMultiP2PPart.CapabilityGuard guard = input.getAdjacentCapability();
                try {
                    potential = ((IFluidHandler)guard.get()).drain(maxDrain, action);
                    if (potential == FluidStack.EMPTY) continue;
                    break;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            FluidStack toDrain = potential.copy();
            toDrain.setAmount(maxDrain - potential.getAmount());
            return this.drain(toDrain, action);
        }
    }

    private static class NullFluidHandler
    implements IFluidHandler {
        private NullFluidHandler() {
        }

        public int getTanks() {
            return 0;
        }

        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 0;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

