/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.integration.PermissionsHelper;
import dev.ftb.mods.ftbessentials.mixin.PlayerListAccess;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.Leaderboard;
import dev.ftb.mods.ftblibrary.util.PlayerDisplayNameUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MiscCommands {
    protected static final int DEFAULT_RADIUS = 200;
    protected static final int MAX_PLAYER_RADIUS = 16;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (FTBEConfig.KICKME.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"kickme").requires((Predicate)FTBEConfig.KICKME)).executes(context -> MiscCommands.kickme(((CommandSourceStack)context.getSource()).m_81375_())));
        }
        if (FTBEConfig.TRASHCAN.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"trashcan").requires((Predicate)FTBEConfig.TRASHCAN)).executes(context -> MiscCommands.trashcan(((CommandSourceStack)context.getSource()).m_81375_())));
        }
        if (FTBEConfig.ENDER_CHEST.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"enderchest").requires((Predicate)FTBEConfig.ENDER_CHEST)).executes(context -> MiscCommands.enderChest(((CommandSourceStack)context.getSource()).m_81375_(), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(context -> MiscCommands.enderChest(((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))));
        }
        if (FTBEConfig.ANVIL.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"anvil").requires(FTBEConfig.ANVIL.enabledAndOp())).executes(context -> MiscCommands.openWorkSite(((CommandSourceStack)context.getSource()).m_81375_(), "block.minecraft.anvil", (id, inv, player) -> new VirtualAnvilMenu(id, inv, (ServerPlayer)player))));
        }
        if (FTBEConfig.SMITHING_TABLE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"smithing").requires(FTBEConfig.SMITHING_TABLE.enabledAndOp())).executes(context -> MiscCommands.openWorkSite(((CommandSourceStack)context.getSource()).m_81375_(), "block.minecraft.smithing_table", (id, inv, player) -> new VirtualSmithingMenu(id, inv, (ServerPlayer)player))));
        }
        if (FTBEConfig.CRAFTING_TABLE.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"crafting").requires(FTBEConfig.CRAFTING_TABLE.enabledAndOp())).executes(context -> MiscCommands.openWorkSite(((CommandSourceStack)context.getSource()).m_81375_(), "block.minecraft.crafting_table", (id, inv, player) -> new VirtualCraftingMenu(id, inv, (ServerPlayer)player))));
        }
        if (FTBEConfig.STONECUTTER.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stonecutter").requires(FTBEConfig.STONECUTTER.enabledAndOp())).executes(context -> MiscCommands.openWorkSite(((CommandSourceStack)context.getSource()).m_81375_(), "block.minecraft.stonecutter", (id, inv, player) -> new VirtualStoneCutterMenu(id, inv, (ServerPlayer)player))));
        }
        if (FTBEConfig.LEADERBOARD.isEnabled()) {
            dispatcher.register(Leaderboard.buildCommand());
        }
        if (FTBEConfig.REC.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"recording").requires((Predicate)FTBEConfig.REC)).executes(context -> MiscCommands.recording(((CommandSourceStack)context.getSource()).m_81375_())));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"streaming").requires((Predicate)FTBEConfig.REC)).executes(context -> MiscCommands.streaming(((CommandSourceStack)context.getSource()).m_81375_())));
        }
        if (FTBEConfig.HAT.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"hat").requires(FTBEConfig.HAT.enabledAndOp())).executes(context -> MiscCommands.hat(((CommandSourceStack)context.getSource()).m_81375_())));
        }
        if (FTBEConfig.NICK.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"nickname").requires((Predicate)FTBEConfig.NICK)).executes(context -> MiscCommands.nickname(((CommandSourceStack)context.getSource()).m_81375_(), ""))).then(Commands.m_82129_((String)"nickname", (ArgumentType)StringArgumentType.greedyString()).executes(context -> MiscCommands.nickname(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"nickname")))));
        }
        if (FTBEConfig.NEAR.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"near").requires(FTBEConfig.NEAR.enabledAndOp())).executes(context -> MiscCommands.showNear((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), 200))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> MiscCommands.showNear((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> MiscCommands.showNear((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), 200))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(context -> MiscCommands.showNear((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"))))));
        }
    }

    private static int openWorkSite(ServerPlayer player, String xlateKey, MenuConstructor ctor) {
        player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inv, p) -> ctor.m_7208_(id, inv, (Player)player), (Component)Component.m_237115_((String)xlateKey)));
        return 1;
    }

    private static int enderChest(ServerPlayer player, @Nullable ServerPlayer target) {
        MutableComponent title = Component.m_237115_((String)"container.enderchest");
        if (target != null) {
            title.m_130946_(" \u00d7 ").m_7220_(target.m_5446_());
        }
        ServerPlayer t = target == null ? player : target;
        player.m_5893_((MenuProvider)new SimpleMenuProvider((i, inv, p) -> ChestMenu.m_39237_((int)i, (Inventory)inv, (Container)t.m_36327_()), (Component)title));
        return 1;
    }

    public static int kickme(ServerPlayer player) {
        player.f_8906_.m_9942_((Component)Component.m_237113_((String)"You kicked yourself!"));
        return 1;
    }

    public static int trashcan(ServerPlayer player) {
        player.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Trash Can");
            }

            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                return ChestMenu.m_39258_((int)id, (Inventory)playerInventory);
            }
        });
        return 1;
    }

    public static <T extends Number> int leaderboard(CommandSourceStack source, Leaderboard<T> leaderboard, boolean reverse) {
        int i;
        try (Stream<Path> stream = Files.list(FTBEWorldData.instance.mkdirs("playerdata"));){
            stream.filter(path -> path.toString().endsWith(".json")).map(Path::getFileName).map(path -> new GameProfile(UUID.fromString(path.toString().replace(".json", "")), null)).filter(profile -> !FTBEPlayerData.playerExists(profile.getId())).map(FTBEPlayerData::getOrCreate).filter(Optional::isPresent).forEach(data -> ((FTBEPlayerData)data.get()).load());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<Pair> list = new ArrayList<Pair>();
        int self = -1;
        FTBEPlayerData.forEachPlayer(playerData -> {
            ServerStatsCounter stats = MiscCommands.getPlayerStats(source.m_81377_(), playerData.getUuid());
            Object num = leaderboard.getValue(stats);
            if (leaderboard.test(num)) {
                list.add(Pair.of((Object)playerData, num));
            }
        });
        if (reverse) {
            list.sort(Comparator.comparingDouble(pair -> ((Number)pair.getRight()).doubleValue()));
        } else {
            list.sort((pair1, pair2) -> Double.compare(((Number)pair2.getRight()).doubleValue(), ((Number)pair1.getRight()).doubleValue()));
        }
        if (source.m_81373_() instanceof ServerPlayer) {
            for (i = 0; i < list.size(); ++i) {
                if (!((FTBEPlayerData)((Pair)list.get(i)).getLeft()).getUuid().equals(source.m_81373_().m_20148_())) continue;
                self = list.size();
                break;
            }
        }
        source.m_288197_(() -> Component.m_237113_((String)("== Leaderboard [" + leaderboard.getName() + "] ==")).m_130940_(ChatFormatting.DARK_GREEN), false);
        if (list.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"No data!").m_130940_(ChatFormatting.GRAY), false);
            return 1;
        }
        for (i = 0; i < Math.min(20, list.size()); ++i) {
            Pair pair3 = (Pair)list.get(i);
            Object num = String.valueOf(i + 1);
            if (i < 10) {
                num = "0" + (String)num;
            }
            MutableComponent component = Component.m_237113_((String)"");
            component.m_130940_(ChatFormatting.GRAY);
            if (i == 0) {
                component.m_7220_((Component)Component.m_237113_((String)("#" + (String)num + " ")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)13938487))));
            } else if (i == 1) {
                component.m_7220_((Component)Component.m_237113_((String)("#" + (String)num + " ")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xC0C0C0))));
            } else if (i == 2) {
                component.m_7220_((Component)Component.m_237113_((String)("#" + (String)num + " ")).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)10451508))));
            } else {
                component.m_7220_((Component)Component.m_237113_((String)("#" + (String)num + " ")));
            }
            component.m_7220_((Component)Component.m_237113_((String)((FTBEPlayerData)pair3.getLeft()).getName()).m_130940_(i == self ? ChatFormatting.GREEN : ChatFormatting.YELLOW));
            component.m_7220_((Component)Component.m_237113_((String)": "));
            component.m_7220_((Component)Component.m_237113_((String)leaderboard.asString((Number)pair3.getRight())));
            source.m_288197_(() -> component, false);
        }
        return 1;
    }

    public static int recording(ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            data.setRecording(data.getRecording() == FTBEPlayerData.RecordingStatus.RECORDING ? FTBEPlayerData.RecordingStatus.NONE : FTBEPlayerData.RecordingStatus.RECORDING);
            PlayerDisplayNameUtil.refreshDisplayName((Player)player);
            if (data.getRecording() == FTBEPlayerData.RecordingStatus.RECORDING) {
                player.f_8924_.m_6846_().m_240416_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW).m_130946_(" is now recording!"), false);
            } else {
                player.f_8924_.m_6846_().m_240416_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW).m_130946_(" is no longer recording!"), false);
            }
            data.sendTabName(player.f_8924_);
            return 1;
        }).orElse(0);
    }

    public static int streaming(ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            data.setRecording(data.getRecording() == FTBEPlayerData.RecordingStatus.STREAMING ? FTBEPlayerData.RecordingStatus.NONE : FTBEPlayerData.RecordingStatus.STREAMING);
            PlayerDisplayNameUtil.refreshDisplayName((Player)player);
            if (data.getRecording() == FTBEPlayerData.RecordingStatus.STREAMING) {
                player.f_8924_.m_6846_().m_240416_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW).m_130946_(" is now streaming!"), false);
            } else {
                player.f_8924_.m_6846_().m_240416_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW).m_130946_(" is no longer streaming!"), false);
            }
            data.sendTabName(player.f_8924_);
            return 1;
        }).orElse(0);
    }

    public static int hat(ServerPlayer player) {
        ItemStack hstack = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack istack = player.m_6844_(EquipmentSlot.MAINHAND);
        player.m_8061_(EquipmentSlot.HEAD, istack);
        player.m_8061_(EquipmentSlot.MAINHAND, hstack);
        player.f_36095_.m_38946_();
        return 1;
    }

    public static int nickname(ServerPlayer player, String nick) {
        if (nick.length() > 30) {
            player.m_5661_((Component)Component.m_237113_((String)"Nickname too long!"), false);
            return 0;
        }
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            data.setNick(nick.trim());
            PlayerDisplayNameUtil.refreshDisplayName((Player)player);
            if (data.getNick().isEmpty()) {
                player.m_5661_((Component)Component.m_237113_((String)"Nickname reset!"), false);
            } else {
                player.m_5661_((Component)Component.m_237113_((String)("Nickname changed to '" + data.getNick() + "'")), false);
            }
            data.sendTabName(player.f_8924_);
            return 1;
        }).orElse(0);
    }

    private static ServerStatsCounter getPlayerStats(MinecraftServer server, UUID playerId) {
        Map<UUID, ServerStatsCounter> stats = ((PlayerListAccess)server.m_6846_()).getStats();
        return stats.computeIfAbsent(playerId, k -> {
            File file1 = server.m_129843_(LevelResource.f_78175_).toFile();
            File file2 = new File(file1, playerId + ".json");
            return new ServerStatsCounter(server, file2);
        });
    }

    private static int showNear(CommandSourceStack source, ServerPlayer target, int radius) {
        int max;
        if (!source.m_6761_(2) && source.m_230897_() && radius > (max = PermissionsHelper.getInstance().getInt(source.m_230896_(), 16, "ftbessentials.near.max_radius"))) {
            source.m_288197_(() -> Component.m_237113_((String)("Limiting radius to " + max)).m_130940_(ChatFormatting.GOLD), false);
            radius = max;
        }
        int radius2 = radius * radius;
        List<ServerPlayer> l = target.m_20194_().m_6846_().m_11314_().stream().filter(other -> other != target).filter(other -> other.m_20280_((Entity)target) < (double)radius2).sorted(Comparator.comparingDouble(o -> o.m_20280_((Entity)target))).toList();
        int r = radius;
        source.m_288197_(() -> Component.m_237113_((String)(l.size() + " player(s) within " + r + "m")).m_130940_(ChatFormatting.YELLOW), false);
        l.forEach(player -> source.m_288197_(() -> Component.m_237113_((String)"\u2022 ").m_7220_(player.m_5446_()).m_130940_(ChatFormatting.AQUA).m_130946_(String.format(" - %5.2fm", Float.valueOf(player.m_20270_((Entity)target)))), false));
        return 1;
    }

    private static class VirtualStoneCutterMenu
    extends StonecutterMenu {
        public VirtualStoneCutterMenu(int id, Inventory inv, ServerPlayer player) {
            super(id, inv, ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)player.m_20183_()));
        }

        public boolean m_6875_(Player player) {
            return true;
        }
    }

    private static class VirtualCraftingMenu
    extends CraftingMenu {
        public VirtualCraftingMenu(int id, Inventory inv, ServerPlayer player) {
            super(id, inv, ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)player.m_20183_()));
        }

        public boolean m_6875_(Player player) {
            return true;
        }
    }

    private static class VirtualSmithingMenu
    extends SmithingMenu {
        public VirtualSmithingMenu(int id, Inventory inv, ServerPlayer player) {
            super(id, inv, ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)player.m_20183_()));
        }

        protected boolean m_8039_(BlockState blockState) {
            return true;
        }
    }

    private static class VirtualAnvilMenu
    extends AnvilMenu {
        public VirtualAnvilMenu(int id, Inventory inv, ServerPlayer player) {
            super(id, inv, ContainerLevelAccess.m_39289_((Level)player.m_9236_(), (BlockPos)player.m_20183_()));
        }

        protected boolean m_8039_(BlockState blockState) {
            return true;
        }
    }
}

