/*
 * Decompiled with CFR 0.152.
 */
package appeng.worldgen.meteorite;

import appeng.worldgen.meteorite.CraterType;
import appeng.worldgen.meteorite.fallout.FalloutMode;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public final class PlacedMeteoriteSettings {
    private final BlockPos pos;
    private final float meteoriteRadius;
    private final CraterType craterType;
    private final FalloutMode fallout;
    private final boolean pureCrater;
    private final boolean craterLake;

    public PlacedMeteoriteSettings(BlockPos pos, float meteoriteRadius, CraterType craterType, FalloutMode fallout, boolean pureCrater, boolean craterLake) {
        this.pos = pos;
        this.craterType = craterType;
        this.meteoriteRadius = meteoriteRadius;
        this.fallout = fallout;
        this.pureCrater = pureCrater;
        this.craterLake = craterLake;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public CraterType getCraterType() {
        return this.craterType;
    }

    public float getMeteoriteRadius() {
        return this.meteoriteRadius;
    }

    public FalloutMode getFallout() {
        return this.fallout;
    }

    public boolean shouldPlaceCrater() {
        return this.craterType != CraterType.NONE;
    }

    public boolean isPureCrater() {
        return this.pureCrater;
    }

    public boolean isCraterLake() {
        return this.craterLake;
    }

    public CompoundTag write(CompoundTag tag) {
        tag.m_128356_("c", this.pos.m_121878_());
        tag.m_128350_("r", this.meteoriteRadius);
        tag.m_128344_("t", (byte)this.craterType.ordinal());
        tag.m_128344_("f", (byte)this.fallout.ordinal());
        tag.m_128379_("p", this.pureCrater);
        tag.m_128379_("l", this.craterLake);
        return tag;
    }

    public static PlacedMeteoriteSettings read(CompoundTag tag) {
        BlockPos pos = BlockPos.m_122022_((long)tag.m_128454_("c"));
        float meteoriteRadius = tag.m_128457_("r");
        CraterType craterType = CraterType.values()[tag.m_128445_("t")];
        FalloutMode fallout = FalloutMode.values()[tag.m_128445_("f")];
        boolean pureCrater = tag.m_128471_("p");
        boolean craterLake = tag.m_128471_("l");
        return new PlacedMeteoriteSettings(pos, meteoriteRadius, craterType, fallout, pureCrater, craterLake);
    }

    public String toString() {
        return "PlacedMeteoriteSettings [pos=" + this.pos + ", meteoriteRadius=" + this.meteoriteRadius + ", craterType=" + this.craterType + ", fallout=" + this.fallout + ", pureCrater=" + this.pureCrater + ", craterLake=" + this.craterLake + "]";
    }
}

