/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene;

import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.BlockTagCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.scene.CameraSettings;
import appeng.client.guidebook.scene.GuidebookScene;
import appeng.client.guidebook.scene.LytGuidebookScene;
import appeng.client.guidebook.scene.PerspectivePreset;
import appeng.client.guidebook.scene.level.GuidebookLevel;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.libs.mdast.model.MdAstNode;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class BlockImageTagCompiler
extends BlockTagCompiler {
    public static final String TAG_NAME = "BlockImage";

    @Override
    public Set<String> getTagNames() {
        return Set.of(TAG_NAME);
    }

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        Pair<ResourceLocation, Block> pair = MdxAttrs.getRequiredBlockAndId(compiler, parent, el, "id");
        if (pair == null) {
            return;
        }
        float scale = MdxAttrs.getFloat(compiler, parent, el, "scale", 1.0f);
        PerspectivePreset perspective = MdxAttrs.getEnum(compiler, parent, el, "perspective", PerspectivePreset.ISOMETRIC_NORTH_EAST);
        if (perspective == null) {
            return;
        }
        BlockState state = ((Block)pair.getRight()).m_49966_();
        state = MdxAttrs.applyBlockStateProperties(compiler, parent, el, state);
        GuidebookLevel level = new GuidebookLevel();
        CameraSettings cameraSettings = new CameraSettings();
        cameraSettings.setZoom(scale);
        cameraSettings.setPerspectivePreset(perspective);
        GuidebookScene scene = new GuidebookScene(level, cameraSettings);
        level.m_46597_(BlockPos.f_121853_, state);
        scene.centerScene();
        LytGuidebookScene lytScene = new LytGuidebookScene(compiler.getExtensions());
        lytScene.setScene(scene);
        lytScene.setInteractive(false);
        lytScene.setSourceNode((MdAstNode)((Object)el));
        parent.append(lytScene);
    }
}

