/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.features;

import appeng.core.definitions.AEParts;
import appeng.items.parts.PartItem;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;

public final class P2PTunnelAttunement {
    private static final int INITIAL_CAPACITY = 40;
    static final Map<TagKey<Item>, Item> tagTunnels = new IdentityHashMap<TagKey<Item>, Item>(40);
    static final List<ApiAttunement> apiAttunements = new ArrayList<ApiAttunement>(40);
    public static final ItemLike ME_TUNNEL = AEParts.ME_P2P_TUNNEL;
    public static final ItemLike ENERGY_TUNNEL = AEParts.FE_P2P_TUNNEL;
    public static final ItemLike REDSTONE_TUNNEL = AEParts.REDSTONE_P2P_TUNNEL;
    public static final ItemLike FLUID_TUNNEL = AEParts.FLUID_P2P_TUNNEL;
    public static final ItemLike ITEM_TUNNEL = AEParts.ITEM_P2P_TUNNEL;
    public static final ItemLike LIGHT_TUNNEL = AEParts.LIGHT_P2P_TUNNEL;

    private P2PTunnelAttunement() {
    }

    public static TagKey<Item> getAttunementTag(ItemLike tunnel) {
        Objects.requireNonNull(tunnel.m_5456_(), "tunnel.asItem()");
        ResourceLocation itemKey = BuiltInRegistries.f_257033_.m_7981_((Object)tunnel.m_5456_());
        if (itemKey.equals((Object)BuiltInRegistries.f_257033_.m_122315_())) {
            throw new IllegalArgumentException("Tunnel item must be registered first.");
        }
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(itemKey.m_135827_(), "p2p_attunements/" + itemKey.m_135815_()));
    }

    public static synchronized void registerAttunementTag(ItemLike tunnel) {
        Objects.requireNonNull(tunnel.m_5456_(), "tunnel.asItem()");
        tagTunnels.put(P2PTunnelAttunement.getAttunementTag(tunnel), P2PTunnelAttunement.validateTunnelPartItem(tunnel));
    }

    public static synchronized <T> void registerAttunementApi(ItemLike tunnelPart, Capability<?> cap, Component description) {
        Objects.requireNonNull(cap, "cap");
        apiAttunements.add(new ApiAttunement(cap, P2PTunnelAttunement.validateTunnelPartItem(tunnelPart), description));
    }

    public static synchronized ItemStack getTunnelPartByTriggerItem(ItemStack trigger) {
        if (trigger.m_41619_()) {
            return ItemStack.f_41583_;
        }
        for (TagKey tag : trigger.m_204131_().toList()) {
            Item tagTunnelItem = tagTunnels.get(tag);
            if (tagTunnelItem == null) continue;
            return new ItemStack((ItemLike)tagTunnelItem);
        }
        for (ApiAttunement apiAttunement : apiAttunements) {
            if (!apiAttunement.hasApi(trigger)) continue;
            return new ItemStack((ItemLike)apiAttunement.tunnelType());
        }
        return ItemStack.f_41583_;
    }

    private static Item validateTunnelPartItem(ItemLike itemLike) {
        Objects.requireNonNull(itemLike, "item");
        Item item = itemLike.m_5456_();
        Objects.requireNonNull(item, "item");
        if (!(item instanceof PartItem)) {
            throw new IllegalArgumentException("Given tunnel part item is not a part");
        }
        PartItem partItem = (PartItem)item;
        if (!P2PTunnelPart.class.isAssignableFrom(partItem.getPartClass())) {
            throw new IllegalArgumentException("Given tunnel part item results in a part that is not a P2P tunnel: " + partItem);
        }
        return item;
    }

    record ApiAttunement(Capability<?> capability, Item tunnelType, Component component) {
        public boolean hasApi(ItemStack stack) {
            return stack.getCapability(this.capability).isPresent();
        }
    }
}

