/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.util;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class NBTHelper {
    public static boolean hasTag(ItemStack item) {
        return item.m_41782_();
    }

    public static CompoundTag getTag(ItemStack item) {
        return item.m_41784_();
    }

    public static boolean hasKey(ItemStack item, String key) {
        return NBTHelper.hasTag(item) && NBTHelper.getTag(item).m_128441_(key);
    }

    public void removeTag(ItemStack item, String key) {
        if (NBTHelper.hasKey(item, key)) {
            NBTHelper.getTag(item).m_128473_(key);
            if (NBTHelper.getTag(item).m_128440_() == 0) {
                item.m_41751_(null);
            }
        }
    }

    public static void setString(ItemStack stack, String key, String val) {
        NBTHelper.getTag(stack).m_128359_(key, val);
    }

    @Nullable
    public static String getString(ItemStack stack, String key, String defaultVal) {
        return NBTHelper.hasTag(stack) ? NBTHelper.getTag(stack).m_128461_(key) : defaultVal;
    }

    public static void setLong(ItemStack stack, String key, long val) {
        NBTHelper.getTag(stack).m_128356_(key, val);
    }

    public static long getLong(ItemStack stack, String key, long defaultVal) {
        return NBTHelper.hasTag(stack) ? NBTHelper.getTag(stack).m_128454_(key) : defaultVal;
    }

    public static void setInt(ItemStack stack, String key, int val) {
        NBTHelper.getTag(stack).m_128405_(key, val);
    }

    public static int getInt(ItemStack stack, String key, int defaultVal) {
        return NBTHelper.hasTag(stack) ? NBTHelper.getTag(stack).m_128451_(key) : defaultVal;
    }

    public static boolean getBoolean(ItemStack stack, String key, boolean defaultVal) {
        return NBTHelper.hasTag(stack) ? NBTHelper.getTag(stack).m_128471_(key) : defaultVal;
    }

    public static void setBoolean(ItemStack stack, String key, boolean value) {
        NBTHelper.getTag(stack).m_128379_(key, value);
    }

    public static void setStringList(ItemStack stack, NonNullList<String> list, String key) {
        ListTag stringList = new ListTag();
        int index = 0;
        for (String s : list) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("" + index, s);
            stringList.add((Object)tag);
            ++index;
        }
        NBTHelper.getTag(stack).m_128365_(key, (Tag)stringList);
    }

    public static NonNullList<String> getStringList(ItemStack stack, String key) {
        NonNullList list = NonNullList.m_122779_();
        if (stack.m_41782_()) {
            ListTag tagList = stack.m_41783_().m_128437_(key, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tag = tagList.m_128728_(i);
                list.add(i, (Object)tag.m_128461_("" + i));
            }
        }
        return list;
    }
}

