/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.util;

import jp.artan.dmlreloaded.common.ILivingMatterType;
import jp.artan.dmlreloaded.common.IMobKey;
import jp.artan.dmlreloaded.common.MobKey;
import jp.artan.dmlreloaded.common.mobmetas.MobMetaData;
import jp.artan.dmlreloaded.item.ItemDataModel;
import jp.artan.dmlreloaded.item.ItemGlitchSword;
import jp.artan.dmlreloaded.util.DataModelLevelupHelper;
import jp.artan.dmlreloaded.util.NBTHelper;
import jp.artan.dmlreloaded.util.TierHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DataModelHelper {
    public static NonNullList<ItemStack> getValidFromList(NonNullList<ItemStack> list) {
        NonNullList filteredList = NonNullList.m_122779_();
        for (ItemStack stack : list) {
            Item item = stack.m_41720_();
            if (!(item instanceof ItemDataModel)) continue;
            filteredList.add((Object)stack);
        }
        return filteredList;
    }

    public static MutableComponent getTierName(ItemStack stack, boolean getNextTierName) {
        return TierHelper.getTierName(DataModelHelper.getTier(stack), getNextTierName);
    }

    public static ILivingMatterType getMatterTypeName(ItemStack stack) {
        return DataModelHelper.getMobMetaData(stack).getType();
    }

    public static int getSimulationTickCost(ItemStack stack) {
        return DataModelHelper.getMobMetaData(stack).getSimulationTickCost();
    }

    public static MobMetaData getMobMetaData(ItemStack stack) {
        return (MobMetaData)DataModelHelper.getMobKey(stack).getMobMetaData().get();
    }

    public static int getTier(ItemStack stack) {
        return NBTHelper.getInt(stack, "tier", 0);
    }

    public static void setTier(ItemStack stack, int tier) {
        NBTHelper.setInt(stack, "tier", tier);
    }

    public static int getCurrentTierKillCount(ItemStack stack) {
        return NBTHelper.getInt(stack, "killCount", 0);
    }

    public static void setCurrentTierKillCount(ItemStack stack, int count) {
        NBTHelper.setInt(stack, "killCount", count);
    }

    public static int getCurrentTierSimulationCount(ItemStack stack) {
        return NBTHelper.getInt(stack, "simulationCount", 0);
    }

    public static void setCurrentTierSimulationCount(ItemStack stack, int count) {
        NBTHelper.setInt(stack, "simulationCount", count);
    }

    public static int getTotalKillCount(ItemStack stack) {
        return NBTHelper.getInt(stack, "totalKillCount", 0);
    }

    public static void setTotalKillCount(ItemStack stack, int count) {
        NBTHelper.setInt(stack, "totalKillCount", count);
    }

    public static int getTotalSimulationCount(ItemStack stack) {
        return NBTHelper.getInt(stack, "totalSimulationCount", 0);
    }

    public static void setTotalSimulationCount(ItemStack stack, int count) {
        NBTHelper.setInt(stack, "totalSimulationCount", count);
    }

    public static IMobKey getMobKey(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemDataModel) {
            ItemDataModel model = (ItemDataModel)item;
            return model.getMobKey();
        }
        return MobKey.ZOMBIE;
    }

    public static double getCurrentTierKillCountWithSims(ItemStack stack) {
        return DataModelLevelupHelper.getCurrentTierKillCountWithSims(DataModelHelper.getTier(stack), DataModelHelper.getCurrentTierKillCount(stack), DataModelHelper.getCurrentTierSimulationCount(stack));
    }

    public static int getCurrentTierSimulationCountWithKills(ItemStack stack) {
        return DataModelLevelupHelper.getCurrentTierSimulationCountWithKills(DataModelHelper.getTier(stack), DataModelHelper.getCurrentTierKillCount(stack), DataModelHelper.getCurrentTierSimulationCount(stack));
    }

    public static double getKillsToNextTier(ItemStack stack) {
        return DataModelLevelupHelper.getKillsToNextTier(DataModelHelper.getTier(stack), DataModelHelper.getCurrentTierKillCount(stack), DataModelHelper.getCurrentTierSimulationCount(stack));
    }

    public static int getSimulationsToNextTier(ItemStack stack) {
        return DataModelLevelupHelper.getSimulationsToNextTier(DataModelHelper.getTier(stack), DataModelHelper.getCurrentTierKillCount(stack), DataModelHelper.getCurrentTierSimulationCount(stack));
    }

    public static int getTierRoofAsKills(ItemStack stack) {
        if (DataModelHelper.getTier(stack) == 4) {
            return 0;
        }
        return DataModelLevelupHelper.getTierRoof(DataModelHelper.getTier(stack), true);
    }

    public static int getTierRoof(ItemStack stack) {
        if (DataModelHelper.getTier(stack) == 4) {
            return 0;
        }
        return DataModelLevelupHelper.getTierRoof(DataModelHelper.getTier(stack), false);
    }

    public static int getPristineChance(ItemStack stack) {
        return TierHelper.getPristineChance(DataModelHelper.getTier(stack));
    }

    public static void increaseMobKillCount(ItemStack stack, ServerPlayer player) {
        int tier = DataModelHelper.getTier(stack);
        int i = DataModelHelper.getCurrentTierKillCount(stack);
        boolean isGlitchSwordEquipped = player.m_21205_().m_41720_() instanceof ItemGlitchSword;
        DataModelHelper.setCurrentTierKillCount(stack, i += isGlitchSwordEquipped ? 2 : 1);
        DataModelHelper.setTotalKillCount(stack, DataModelHelper.getTotalKillCount(stack) + 1);
        if (DataModelLevelupHelper.shouldIncreaseTier(tier, i, DataModelHelper.getCurrentTierSimulationCount(stack))) {
            player.m_5661_((Component)Component.m_237110_((String)"dmlreloaded.tiers.increase_tier", (Object[])new Object[]{Component.m_237115_((String)stack.m_41778_()), DataModelHelper.getTierName(stack, true)}), true);
            DataModelHelper.setCurrentTierKillCount(stack, 0);
            DataModelHelper.setCurrentTierSimulationCount(stack, 0);
            DataModelHelper.setTier(stack, tier + 1);
        }
    }

    public static void increaseSimulationCount(ItemStack stack) {
        int tier = DataModelHelper.getTier(stack);
        int i = DataModelHelper.getCurrentTierSimulationCount(stack);
        DataModelHelper.setCurrentTierSimulationCount(stack, ++i);
        DataModelHelper.setTotalSimulationCount(stack, DataModelHelper.getTotalSimulationCount(stack) + 1);
        if (DataModelLevelupHelper.shouldIncreaseTier(tier, DataModelHelper.getCurrentTierKillCount(stack), i)) {
            DataModelHelper.setCurrentTierKillCount(stack, 0);
            DataModelHelper.setCurrentTierSimulationCount(stack, 0);
            DataModelHelper.setTier(stack, tier + 1);
        }
    }
}

