/*
 * Decompiled with CFR 0.152.
 */
package jp.artan.dmlreloaded.util;

public class Animation {
    private boolean hasStarted = false;
    private int renderPos = 0;
    private int renderStop = 0;
    private int currentTick = 0;
    private long lastAlterTick = 0L;
    private String currentString = "";

    public String animate(String string, int totalTickTime, long currentWorldTick, boolean loop) {
        if (this.lastAlterTick != currentWorldTick) {
            this.alterString(string, totalTickTime, loop);
            this.lastAlterTick = currentWorldTick;
        }
        return this.currentString;
    }

    public void alterString(String string, int totalTickTime, boolean loop) {
        if (!this.hasStarted) {
            this.hasStarted = true;
            this.renderPos = 0;
            this.renderStop = string.length();
        } else {
            ++this.currentTick;
            if (this.renderPos < this.renderStop) {
                if (this.renderPos >= 0) {
                    this.currentString = string.substring(0, this.renderPos);
                }
                this.renderPos = this.currentTick % totalTickTime == 0 ? this.renderPos + 1 : this.renderPos;
            } else {
                if (loop) {
                    this.hasStarted = this.currentTick % totalTickTime != 0;
                }
                this.currentString = string;
            }
        }
    }

    public boolean hasFinished() {
        return this.renderPos == this.renderStop && this.renderStop != 0;
    }

    public void clear() {
        this.currentString = "";
        this.hasStarted = false;
        this.renderPos = 0;
        this.renderStop = 0;
        this.currentTick = 0;
    }
}

